/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.gui.component;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;

public class LabeledInput
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JLabel label;
    private JTextField input;
    private boolean isPassword;
    private static final int DEFAULT_FIELD_SIZE = 6;

    public LabeledInput(String label) {
        this(label, 6);
    }

    public LabeledInput(String label, int size) {
        this(label, false, size);
    }

    public LabeledInput(String label, boolean isPassword, int size) {
        this(label, isPassword, isPassword ? new JPasswordField(size) : new JTextField(size));
    }

    private LabeledInput(String label, boolean isPassword, JTextField input) {
        this.isPassword = isPassword;
        this.label = new JLabel(label);
        this.input = input;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 4, 2, 4), 0, 0);
        this.add((Component)this.label, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        this.add((Component)this.input, gbc);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.input.setEnabled(enabled);
        this.label.setEnabled(enabled);
    }

    public String getLabel() {
        return this.label.getText();
    }

    public String getText() {
        if (this.isPassword) {
            return String.valueOf(((JPasswordField)this.input).getPassword());
        }
        return this.input.getText();
    }

    public void setText(String text) {
        this.input.setText(text);
    }

    public void addActionListener(ActionListener al) {
        this.input.addActionListener(al);
    }

    public void addDocumentListener(DocumentListener dl) {
        this.input.getDocument().addDocumentListener(dl);
    }

    @Override
    public void addFocusListener(FocusListener fl) {
        this.input.addFocusListener(fl);
    }
}

