/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.gui.component;

import com.glitchcog.fontificator.gui.controls.ControlWindow;
import com.glitchcog.fontificator.gui.controls.panel.ControlPanelBase;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ColorButton
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JLabel label;
    private JButton button;
    private final ControlPanelBase control;

    public ColorButton(final String label, Color value, String explanation, ControlPanelBase controlPanel) {
        this.control = controlPanel;
        this.button = new JButton();
        this.button.setToolTipText("");
        this.label = new JLabel(label);
        this.setColor(value == null ? Color.BLACK : value);
        this.button.setBackground(value);
        this.button.setOpaque(true);
        this.add(this.label);
        this.add(this.button);
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = JColorChooser.showDialog(ControlWindow.me, "Select Color" + (label == null ? "" : " for " + label), ColorButton.this.getColor());
                if (color != null) {
                    ColorButton.this.setColor(color);
                    ColorButton.this.control.update();
                }
            }
        });
    }

    public Color getColor() {
        return this.button.getBackground();
    }

    public void setColor(Color value) {
        this.button.setBackground(value);
    }

    public String getLabel() {
        return this.label.getText();
    }
}

