/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.gui.component;

import com.glitchcog.fontificator.config.ConfigFont;
import com.glitchcog.fontificator.gui.chat.ChatPanel;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JToggleButton;

public class CharacterPicker
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JToggleButton[] charButtons;
    private ButtonGroup buttonGroup;
    private ConfigFont config;
    private JLabel selectionLabel;
    private String baseLabelText;
    private ChatPanel chat;

    public CharacterPicker(JDialog parent, ConfigFont config, JLabel selectionLabel, ChatPanel chat) {
        super((Dialog)parent, true);
        this.selectionLabel = selectionLabel;
        this.baseLabelText = selectionLabel.getText();
        this.config = config;
        this.chat = chat;
        this.build();
    }

    private void build() {
        this.setLayout(new GridLayout(12, 8));
        this.setTitle("Character Picker");
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JToggleButton tb = (JToggleButton)e.getSource();
                CharacterPicker.this.setSelectedChar(tb.getText().charAt(0));
                CharacterPicker.this.setVisible(false);
            }
        };
        this.buttonGroup = new ButtonGroup(){
            private static final long serialVersionUID = 1L;

            @Override
            public void setSelected(ButtonModel model, boolean selected) {
                if (selected) {
                    super.setSelected(model, selected);
                } else {
                    this.clearSelection();
                }
            }
        };
        this.charButtons = new JToggleButton[96];
        int i = 0;
        while (i < this.charButtons.length) {
            this.charButtons[i] = new JToggleButton(Character.toString((char)(i + 32)));
            this.charButtons[i].addActionListener(al);
            this.buttonGroup.add(this.charButtons[i]);
            this.add(this.charButtons[i]);
            ++i;
        }
        this.pack();
        this.setResizable(false);
    }

    public void setSelectedChar(char selectedChar) {
        this.config.setUnknownChar(selectedChar);
        this.charButtons[selectedChar - 32].setSelected(true);
        String label = "'" + Character.toString(selectedChar) + "' (ASCII " + selectedChar + ")";
        this.selectionLabel.setText(String.valueOf(this.baseLabelText) + label);
        this.chat.repaint();
    }

    public char getSelectedChar() {
        return this.config.getUnknownChar();
    }
}

