/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.gui.chat.clock;

import com.glitchcog.fontificator.bot.Message;
import com.glitchcog.fontificator.gui.chat.ChatPanel;
import com.glitchcog.fontificator.gui.chat.clock.MessageClock;
import java.util.Timer;
import java.util.TimerTask;

public class MessageProgressor
extends MessageClock {
    public MessageProgressor(ChatPanel chat) {
        super(chat);
    }

    public boolean isSomethingBeingDrawn() {
        return this.active;
    }

    @Override
    public void startClock(long messageDelay) {
        if (!this.active) {
            this.refreshTimer(messageDelay);
        }
    }

    @Override
    public void initTask() {
        this.task = new TimerTask(){

            @Override
            public void run() {
                MessageProgressor.this.active = false;
                Message[] messageArray = MessageProgressor.this.chat.getMessages();
                int i = 0;
                while (i < messageArray.length) {
                    if (!(messageArray[i].isCompletelyDrawn() || messageArray[i].isCensored() && MessageProgressor.this.chat.isCensorshipEnabled())) {
                        messageArray[i].incrementDrawCursor(MessageProgressor.this.chat.getEmojiManager(), MessageProgressor.this.chat.getMessageConfig(), MessageProgressor.this.chat.getEmojiConfig());
                        MessageProgressor.this.active = true;
                        MessageProgressor.this.chat.repaint();
                        break;
                    }
                    ++i;
                }
                if (!MessageProgressor.this.active) {
                    this.cancel();
                }
            }
        };
    }

    public void refreshTimer(long messageDelay) {
        this.cancelLatest();
        this.initTask();
        this.clock = new Timer();
        this.clock.schedule(this.task, 0L, messageDelay);
    }
}

