/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.gui.chat;

import com.glitchcog.fontificator.config.ConfigChat;
import com.glitchcog.fontificator.config.FontificatorProperties;
import com.glitchcog.fontificator.gui.FontificatorError;
import com.glitchcog.fontificator.gui.chat.ChatMouseListeners;
import com.glitchcog.fontificator.gui.chat.ChatPanel;
import com.glitchcog.fontificator.gui.controls.ControlWindow;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;

public class ChatWindow
extends JFrame {
    private static final long serialVersionUID = 1L;
    private ChatPanel chatPanel;
    public static ChatWindow me;
    public static FontificatorError popup;
    private ChatMouseListeners mouseListeners;
    private static final KeyStroke escapeStroke;

    static {
        escapeStroke = KeyStroke.getKeyStroke(27, 0);
    }

    public ChatWindow() {
        me = this;
        this.setTitle("Fontificator Chat");
        popup = new FontificatorError(null);
    }

    public void initChat(FontificatorProperties fProps, final ControlWindow ctrlWindow) throws IOException {
        this.chatPanel = new ChatPanel();
        this.add(this.chatPanel);
        this.mouseListeners = new ChatMouseListeners(this, ctrlWindow);
        this.addMouseListener(this.mouseListeners);
        this.addMouseMotionListener(this.mouseListeners);
        this.addMouseWheelListener(this.chatPanel);
        this.setDefaultCloseOperation(0);
        this.setChatSize(fProps.getChatConfig());
        this.setResizable(fProps.getChatConfig().isResizable());
        this.setAlwaysOnTop(fProps.getChatConfig().isAlwaysOnTop());
        this.chatPanel.setConfig(fProps);
        this.chatPanel.initExpirationTimer();
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                this.callExit(e.getComponent());
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            private void callExit(Component caller) {
                ctrlWindow.attemptToExit(caller);
            }
        });
    }

    public void setChatSize(ConfigChat chatConfig) {
        if (chatConfig.getWindowWidth() != null && chatConfig.getWindowHeight() != null) {
            this.setSize(chatConfig.getWindowWidth(), chatConfig.getWindowHeight());
            chatConfig.setWidth(this.getContentPane().getWidth());
            chatConfig.setHeight(this.getContentPane().getHeight());
            chatConfig.clearLegacyWindowSize();
        } else if (chatConfig.getWidth() > 0 && chatConfig.getHeight() > 0) {
            this.getContentPane().setPreferredSize(new Dimension(chatConfig.getWidth(), chatConfig.getHeight()));
            this.getContentPane().setSize(chatConfig.getWidth(), chatConfig.getHeight());
            this.pack();
        }
    }

    public static void setupHideOnEscape(final JDialog popup) {
        AbstractAction aa = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                popup.setVisible(false);
            }
        };
        String mapKey = "escapePressed";
        JRootPane root = popup.getRootPane();
        root.getInputMap(2).put(escapeStroke, "escapePressed");
        root.getActionMap().put("escapePressed", aa);
    }

    public ChatPanel getChatPanel() {
        return this.chatPanel;
    }

    public void clearUsernameCases() {
        this.mouseListeners.clearUsernameCases();
    }
}

