/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.gui.chat;

import com.glitchcog.fontificator.bot.Message;
import com.glitchcog.fontificator.config.ConfigCensor;
import com.glitchcog.fontificator.config.ConfigChat;
import com.glitchcog.fontificator.config.ConfigColor;
import com.glitchcog.fontificator.config.ConfigEmoji;
import com.glitchcog.fontificator.config.ConfigFont;
import com.glitchcog.fontificator.config.ConfigMessage;
import com.glitchcog.fontificator.config.FontificatorProperties;
import com.glitchcog.fontificator.emoji.EmojiManager;
import com.glitchcog.fontificator.gui.chat.clock.MessageExpirer;
import com.glitchcog.fontificator.gui.chat.clock.MessageProgressor;
import com.glitchcog.fontificator.gui.controls.panel.ControlPanelDebug;
import com.glitchcog.fontificator.gui.controls.panel.ControlPanelFont;
import com.glitchcog.fontificator.gui.controls.panel.MessageCensorPanel;
import com.glitchcog.fontificator.sprite.Sprite;
import com.glitchcog.fontificator.sprite.SpriteFont;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class ChatPanel
extends JPanel
implements MouseWheelListener {
    private static final Logger logger = Logger.getLogger(ChatPanel.class);
    private static final long serialVersionUID = 1L;
    private ConcurrentLinkedQueue<Message> messages;
    private MessageCensorPanel censor;
    private MessageProgressor messageProgressor;
    private MessageExpirer messageExpirer;
    private Sprite border;
    private int lineCount = Integer.MAX_VALUE;
    private int onScreenLineCount = 0;
    private ConfigFont fontConfig;
    private ConfigChat chatConfig;
    private ConfigColor colorConfig;
    private ConfigMessage messageConfig;
    private ConfigEmoji emojiConfig;
    private ConfigCensor censorConfig;
    private ControlPanelDebug debugSettings;
    private SpriteFont font;
    private boolean loaded = false;
    private EmojiManager emojiManager;

    public ChatPanel() throws IOException {
        this.messages = new ConcurrentLinkedQueue();
        this.emojiManager = new EmojiManager();
        this.messageProgressor = new MessageProgressor(this);
        this.messageExpirer = new MessageExpirer(this);
    }

    public boolean isLoaded() {
        return this.loaded && this.censor != null;
    }

    public void setConfig(FontificatorProperties fProps) throws IOException {
        logger.trace("Setting chat panel config via fontificator properties object");
        this.fontConfig = fProps.getFontConfig();
        this.chatConfig = fProps.getChatConfig();
        this.colorConfig = fProps.getColorConfig();
        this.messageConfig = fProps.getMessageConfig();
        this.emojiConfig = fProps.getEmojiConfig();
        this.censorConfig = fProps.getCensorConfig();
        this.font = new SpriteFont(this.fontConfig);
        this.reloadFontFromConfig();
        this.reloadBorderFromConfig();
        this.loaded = true;
    }

    public void setDebugSettings(ControlPanelDebug debugSettings) {
        this.debugSettings = debugSettings;
    }

    public void setMessageCensor(MessageCensorPanel censor) {
        this.censor = censor;
    }

    @Override
    public void paint(Graphics g) {
        if (!this.isLoaded()) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        if (this.chatConfig.isAntiAlias()) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        }
        boolean stillFits = true;
        int fontSize = 0;
        while (stillFits) {
            g2d.setFont(new Font(g2d.getFont().getName(), 0, ++fontSize));
            boolean bl = stillFits = (double)((float)(this.font.getFontHeight() - this.fontConfig.getBaselineOffset()) * this.fontConfig.getFontScale()) > g2d.getFontMetrics().getStringBounds("A", 0, 1, (Graphics)g2d).getHeight();
        }
        logger.trace("Calulated font size: " + fontSize);
        ArrayList<Message> drawMessages = new ArrayList<Message>();
        long drawTime = System.currentTimeMillis();
        for (Message msg : this.messages) {
            boolean expired;
            boolean censored = this.censorConfig.isCensorshipEnabled() && msg.isCensored();
            boolean bl = expired = this.messageConfig.isMessageExpirable() && msg.getAge(drawTime) > (long)this.messageConfig.getExpirationTime().intValue();
            if (!censored && !expired) {
                drawMessages.add(msg);
            }
            if (!censored && !expired && !msg.isCompletelyDrawn()) break;
        }
        if (this.messageConfig.isHideEmptyBackground() && drawMessages.isEmpty()) {
            g2d.setColor(this.colorConfig.getChromaColor());
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        } else {
            this.drawBackgroundAndChroma(g2d);
        }
        Point offset = new Point();
        if (!(!(this.fontConfig.getBorderScale() > 0.0f) || this.messageConfig.isHideEmptyBorder() && drawMessages.isEmpty())) {
            int gridWidth = this.getWidth() / this.border.getSpriteDrawWidth(this.fontConfig.getBorderScale());
            int gridHeight = this.getHeight() / this.border.getSpriteDrawHeight(this.fontConfig.getBorderScale());
            int leftOffset = (this.getWidth() - gridWidth * this.border.getSpriteDrawWidth(this.fontConfig.getBorderScale())) / 2;
            int topOffset = (this.getHeight() - gridHeight * this.border.getSpriteDrawHeight(this.fontConfig.getBorderScale())) / 2;
            offset = new Point(leftOffset, topOffset);
            this.drawBorder(g2d, gridWidth, gridHeight, offset, this.colorConfig.getBorderColor(), this.debugSettings.isDrawBorderGrid(), this.debugSettings.getBorderGridColor());
        }
        this.drawChat(g2d, drawMessages, offset, this.debugSettings.isDrawTextGrid(), this.debugSettings.getTextGridColor());
    }

    protected void drawGrid(Graphics g, Color one, Color two, int x, int y, int width, int height, int squareSize) {
        int r = 0;
        while (r < height / squareSize + 1) {
            int c = 0;
            while (c < width / squareSize + 1) {
                boolean colorOne = r % 2 == 1 && c % 2 == 0 || r % 2 == 0 && c % 2 == 1;
                g.setColor(colorOne ? one : two);
                g.fillRect(x + c * squareSize, y + r * squareSize, squareSize, squareSize);
                ++c;
            }
            ++r;
        }
    }

    private void drawBackgroundAndChroma(Graphics2D g2d) {
        if (this.chatConfig.isChromaEnabled().booleanValue()) {
            g2d.setColor(this.chatConfig.isChromaInvert() ? this.colorConfig.getBgColor() : this.colorConfig.getChromaColor());
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2d.setColor(this.chatConfig.isChromaInvert() ? this.colorConfig.getChromaColor() : this.colorConfig.getBgColor());
            Rectangle border = this.chatConfig.getChromaBorder();
            g2d.fillRoundRect(Math.min(this.getWidth(), border.x), Math.min(this.getHeight(), border.y), Math.max(0, this.getWidth() - border.width - border.x), Math.max(0, this.getHeight() - border.height - border.y), this.chatConfig.getChromaCornerRadius(), this.chatConfig.getChromaCornerRadius());
        } else {
            g2d.setColor(this.colorConfig.getBgColor());
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    private void drawChat(Graphics2D g2d, List<Message> drawMessages, Point offset, boolean debug, Color debugColor) {
        int lineWrapLength = (this.border == null || this.fontConfig.getBorderScale() <= 0.0f ? this.getWidth() : this.border.getSpriteDrawWidth(this.fontConfig.getBorderScale()) * (this.getWidth() / this.border.getSpriteDrawWidth(this.fontConfig.getBorderScale()) - 2)) - this.fontConfig.getBorderInsetX() * 2;
        int leftEdge = offset.x + (this.border == null || this.fontConfig.getBorderScale() <= 0.0f ? 0 : this.border.getSpriteDrawWidth(this.fontConfig.getBorderScale())) + this.fontConfig.getBorderInsetX();
        int totalHeight = 0;
        int i = 0;
        while (i < drawMessages.size()) {
            Message msg = drawMessages.get(i);
            boolean lastMessage = i >= drawMessages.size() - 1;
            Dimension dim = this.font.getMessageDimensions(msg, g2d.getFontMetrics(), this.messageConfig, this.emojiConfig, this.emojiManager, lineWrapLength, lastMessage);
            totalHeight = (int)((double)totalHeight + dim.getHeight());
            ++i;
        }
        int lineHeight = this.font.getLineHeightScaled();
        if (lineHeight == 0) {
            lineHeight = 1;
        }
        this.lineCount = lineHeight == 0 ? 0 : totalHeight / lineHeight;
        int borderEdgeThickness = offset.y + (this.border == null || this.fontConfig.getBorderScale() < 0.25f ? 0 : this.border.getSpriteDrawHeight(this.fontConfig.getBorderScale())) + this.fontConfig.getBorderInsetY();
        int drawableVerticalRange = this.getHeight() - borderEdgeThickness * 2;
        this.onScreenLineCount = drawableVerticalRange / lineHeight;
        int y = this.chatConfig.isChatFromBottom() ? (this.chatConfig.isReverseScrolling() ? (totalHeight > drawableVerticalRange ? borderEdgeThickness : this.getHeight() - totalHeight - borderEdgeThickness) : this.getHeight() - totalHeight - borderEdgeThickness) : (this.chatConfig.isReverseScrolling() ? borderEdgeThickness : (totalHeight > drawableVerticalRange ? this.getHeight() - borderEdgeThickness - totalHeight : borderEdgeThickness));
        int botLimit = this.chatConfig.isReverseScrolling() && totalHeight > drawableVerticalRange ? this.getHeight() - borderEdgeThickness - this.font.getLineHeightScaled() : this.getHeight() - borderEdgeThickness;
        int i2 = 0;
        while (i2 < drawMessages.size()) {
            int msgIndex = this.chatConfig.isReverseScrolling() ? drawMessages.size() - i2 - 1 : i2;
            Message msg = drawMessages.get(msgIndex);
            Color col = ChatPanel.getUsernameColor(this.colorConfig, msg);
            boolean lastMessage = i2 >= drawMessages.size() - 1;
            Dimension dim = this.font.drawMessage(g2d, g2d.getFontMetrics(), msg, col, this.colorConfig, this.messageConfig, this.emojiConfig, this.emojiManager, leftEdge, y, borderEdgeThickness, botLimit, lineWrapLength, debug, debugColor, this, lastMessage);
            y = (int)((double)y + dim.getHeight());
            ++i2;
        }
    }

    private static Color getUsernameColor(ConfigColor colorConfig, Message msg) {
        Color col = msg.isJoinType() ? colorConfig.getHighlight() : (colorConfig.isUseTwitchColors() && msg.getPrivmsg().getColor() != null ? msg.getPrivmsg().getColor() : (colorConfig.getPalette().isEmpty() ? colorConfig.getHighlight() : colorConfig.getPalette().get(Math.abs(msg.getUsername().toLowerCase().hashCode()) % colorConfig.getPalette().size())));
        return col;
    }

    private void drawBorder(Graphics2D g2d, int gridWidth, int gridHeight, Point offset, Color color, boolean debug, Color debugColor) {
        float scale = this.fontConfig.getBorderScale();
        if (scale <= 0.0f) {
            return;
        }
        if (debug) {
            g2d.setColor(debugColor);
        }
        int r = 0;
        while (r < gridHeight) {
            int c = 0;
            while (c < gridWidth) {
                int pixelX = c * this.border.getSpriteDrawWidth(scale) + offset.x;
                int pixelY = r * this.border.getSpriteDrawHeight(scale) + offset.y;
                if (r == 0) {
                    if (c == 0) {
                        this.border.draw(g2d, pixelX, pixelY, 0, scale, color);
                    } else if (c == gridWidth - 1) {
                        this.border.draw(g2d, pixelX, pixelY, 2, scale, color);
                    } else {
                        this.border.draw(g2d, pixelX, pixelY, 1, scale, color);
                    }
                } else if (r == gridHeight - 1) {
                    if (c == 0) {
                        this.border.draw(g2d, pixelX, pixelY, 6, scale, color);
                    } else if (c == gridWidth - 1) {
                        this.border.draw(g2d, pixelX, pixelY, 8, scale, color);
                    } else {
                        this.border.draw(g2d, pixelX, pixelY, 7, scale, color);
                    }
                } else if (c == 0) {
                    this.border.draw(g2d, pixelX, pixelY, 3, scale, color);
                } else if (c == gridWidth - 1) {
                    this.border.draw(g2d, pixelX, pixelY, 5, scale, color);
                } else {
                    this.border.draw(g2d, pixelX, pixelY, 4, scale, color);
                }
                if (debug) {
                    g2d.drawRect(pixelX, pixelY, (int)((float)this.border.getSpriteWidth() * scale), (int)((float)this.border.getSpriteHeight() * scale));
                }
                ++c;
            }
            ++r;
        }
    }

    public synchronized void addMessage(Message addition) {
        if (addition.isJoinType() && !this.messageConfig.showJoinMessages()) {
            return;
        }
        this.censor.checkCensor(addition);
        this.messages.add(addition);
        int remCount = Math.max(0, this.messages.size() - this.messageConfig.getQueueSize());
        Iterator<Message> iter = this.messages.iterator();
        while (iter.hasNext() && remCount > 0) {
            iter.next();
            iter.remove();
            --remCount;
        }
        this.initMessageRollout();
        if (this.censor.isVisible()) {
            this.censor.updateManualTable();
        }
        this.repaint();
    }

    public synchronized void clearChat() {
        this.messages.clear();
        this.repaint();
    }

    public void resetScrollOffset() {
        if (this.isLoaded()) {
            this.font.setLineScrollOffset(0);
        }
    }

    public void incrementScrollOffset(boolean positiveDirection, int lines) {
        if (this.isLoaded()) {
            int dir;
            int n = dir = positiveDirection ? lines : -lines;
            if (this.chatConfig.isChatFromBottom()) {
                this.font.incrementLineScrollOffset(dir, 0, this.lineCount);
            } else {
                boolean screenIsOverflowing;
                boolean bl = screenIsOverflowing = this.lineCount >= this.onScreenLineCount;
                if (screenIsOverflowing) {
                    this.font.incrementLineScrollOffset(dir, -this.onScreenLineCount + 1, this.lineCount - this.onScreenLineCount + 1);
                } else {
                    this.font.incrementLineScrollOffset(dir, this.lineCount == 0 ? 0 : -this.lineCount + 1, 1);
                }
            }
            this.repaint();
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (this.isLoaded() && this.chatConfig.isScrollable()) {
            this.incrementScrollOffset(e.getWheelRotation() < 0, 1);
        }
    }

    public synchronized Message[] getMessages() {
        return this.messages.toArray(new Message[this.messages.size()]);
    }

    public ConcurrentLinkedQueue<Message> getMessageQueue() {
        return this.messages;
    }

    public void reloadFontFromConfig() throws IOException {
        this.font.updateForConfigChange();
    }

    public void reloadBorderFromConfig() throws IOException {
        try {
            this.border = new Sprite(this.fontConfig.getBorderFilename(), 3, 3);
        }
        catch (Exception e) {
            String errorMessage = "Unable to load border sprite " + (this.fontConfig == null ? "for null font configuration" : "for border filename " + this.fontConfig.getBorderFilename());
            logger.error(errorMessage, e);
            this.border = new Sprite();
        }
    }

    public ConfigMessage getMessageConfig() {
        return this.messageConfig;
    }

    public ConfigEmoji getEmojiConfig() {
        return this.emojiConfig;
    }

    public MessageProgressor getMessageProgressor() {
        return this.messageProgressor;
    }

    public MessageExpirer getMessageExpirer() {
        return this.messageExpirer;
    }

    public void banUser(String bannedUser) {
        this.censor.addBan(bannedUser);
        this.repaint();
    }

    public void unbanUser(String bannedUser) {
        this.censor.removeBan(bannedUser);
        this.repaint();
    }

    public EmojiManager getEmojiManager() {
        return this.emojiManager;
    }

    public void initExpirationTimer() {
        if (this.messageConfig.isMessageExpirable()) {
            this.messageExpirer.startClock();
        }
    }

    public void initMessageRollout() {
        this.messageProgressor.startClock(this.messageConfig.getMessageDelay());
    }

    public boolean isCensorshipEnabled() {
        return this.censorConfig.isCensorshipEnabled();
    }

    public void purgeMessagesForUser(String username, String reason) {
        this.censor.purgeMessagesForUser(username, reason);
    }

    public String getFontGameName() {
        return ControlPanelFont.getFontGameName(this.fontConfig.getFontFilename());
    }

    public String getBorderGameName() {
        return ControlPanelFont.getBorderGameName(this.fontConfig.getBorderFilename());
    }
}

