/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.gui.chat;

import com.glitchcog.fontificator.gui.controls.ControlWindow;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JFrame;
import javax.swing.event.MouseInputListener;

public class ChatMouseListeners
implements MouseMotionListener,
MouseInputListener {
    private Point pressOffset = new Point();
    private boolean pressed;
    private JFrame chatWindow;
    private ControlWindow ctrlWindow;

    public ChatMouseListeners(JFrame chatWindow, ControlWindow ctrlWindow) {
        this.chatWindow = chatWindow;
        this.ctrlWindow = ctrlWindow;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int x = e.getLocationOnScreen().x - this.pressOffset.x;
        int y = e.getLocationOnScreen().y - this.pressOffset.y;
        this.chatWindow.setLocation(x, y);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1) {
            this.ctrlWindow.setVisible(true);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1 && !this.pressed) {
            this.pressOffset.x = e.getX();
            this.pressOffset.y = e.getY();
            this.pressed = true;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.pressed = false;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public void clearUsernameCases() {
        this.ctrlWindow.clearUsernameCases();
    }
}

