/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.gui;

import com.glitchcog.fontificator.config.loadreport.LoadConfigReport;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class FontificatorError {
    private JFrame parent;
    private static final int MAX_ERRORS_TO_DISPLAY = 12;

    public FontificatorError(JFrame parent) {
        this.parent = parent;
    }

    public void handleProblem(String description) {
        this.handleProblem(description, (Throwable)null);
    }

    public void handleProblem(LoadConfigReport report) {
        if (report.getMainMessage() == null) {
            this.handleProblem("", report.getMessages());
        } else {
            this.handleProblem(report.getMainMessage(), report.getMessages());
        }
    }

    public void handleProblem(List<String> errors) {
        this.handleProblem("Error" + (errors.size() == 1 ? "" : "s") + ":<br />", errors);
    }

    public void handleProblem(String summary, List<String> errors) {
        String allErrors = "<html>" + summary + (summary == null || summary.isEmpty() ? "" : "<br />");
        int eCount = 0;
        for (String er : errors) {
            allErrors = String.valueOf(allErrors) + er + "<br />";
            if (++eCount <= 12 || errors.size() - eCount <= 0) continue;
            int remaining = errors.size() - eCount;
            allErrors = String.valueOf(allErrors) + "and " + remaining + " other error" + (remaining == 1 ? "" : "s") + "<br />";
            break;
        }
        allErrors = String.valueOf(allErrors) + "</html>";
        this.handleProblem(allErrors);
    }

    public void handleProblem(String description, Throwable t) {
        JOptionPane.showMessageDialog(this.parent, description);
    }
}

