/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.gui;

import com.glitchcog.fontificator.FontificatorMain;
import com.glitchcog.fontificator.gui.controls.panel.LogBox;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public class DebugAppender
extends WriterAppender
implements Thread.UncaughtExceptionHandler {
    private LogBox debugLogBox;

    public DebugAppender(LogBox debugLogBox) {
        super((Layout)FontificatorMain.LOG_PATTERN_LAYOUT, System.out);
        this.debugLogBox = debugLogBox;
        this.setName("Debug Logging");
        this.setThreshold(Level.DEBUG);
    }

    @Override
    public void append(LoggingEvent event) {
        this.debugLogBox.log(this.layout.format(event));
        ThrowableInformation info = event.getThrowableInformation();
        if (info != null && info.getThrowable() != null) {
            Throwable t = info.getThrowable();
            this.debugLogBox.log(DebugAppender.throwableToString(t));
        }
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        try {
            System.err.println("Exception in thread \"" + t.getName() + "\" ");
            e.printStackTrace(System.err);
            this.debugLogBox.log("Exception in thread \"" + t.getName() + "\" ");
            this.debugLogBox.log(DebugAppender.throwableToString(e));
        }
        catch (Exception debugException) {
            debugException.printStackTrace();
        }
    }

    private static String throwableToString(Throwable e) {
        StringWriter stackTraceWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stackTraceWriter));
        return stackTraceWriter.toString();
    }
}

