/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.gui;

import com.glitchcog.fontificator.config.FontType;
import com.glitchcog.fontificator.gui.controls.panel.ControlPanelFont;
import com.glitchcog.fontificator.gui.controls.panel.model.DropdownBorder;
import com.glitchcog.fontificator.gui.controls.panel.model.DropdownFont;
import com.glitchcog.fontificator.gui.controls.panel.model.DropdownLabel;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AssetIndexLoader {
    private static final Logger logger = Logger.getLogger(AssetIndexLoader.class);
    private static final String INDEX_FONTS_FILENAME = "index_fonts.txt";
    private static final String INDEX_BORDERS_FILENAME = "index_borders.txt";
    private static final String INDEX_PRESETS_FILENAME = "index_presets.txt";
    private static final String PRESET_DIRECTORY = "presets/";

    public static Map<DropdownLabel, DropdownFont> loadFonts() {
        LinkedHashMap<DropdownLabel, DropdownFont> fontMap = new LinkedHashMap<DropdownLabel, DropdownFont>();
        fontMap.put(ControlPanelFont.CUSTOM_KEY, null);
        String errorLine = null;
        try {
            List<String> fontLines = AssetIndexLoader.loadIndexFile(INDEX_FONTS_FILENAME);
            Iterator<String> iterator = fontLines.iterator();
            while (iterator.hasNext()) {
                String line;
                errorLine = line = iterator.next();
                if (line.trim().startsWith("#")) continue;
                String[] splitLine = line.split(",");
                String category = splitLine[0].trim();
                String name = splitLine[1].trim();
                String filename = splitLine[2].trim();
                FontType type = FontType.valueOf(splitLine[3].trim());
                fontMap.put(new DropdownLabel(category, name), new DropdownFont(filename, type));
            }
        }
        catch (Exception e) {
            logger.error("Error loading font index" + (errorLine == null ? "" : "\n" + errorLine), e);
        }
        return fontMap;
    }

    public static Map<DropdownLabel, DropdownBorder> loadBorders() {
        LinkedHashMap<DropdownLabel, DropdownBorder> borderMap = new LinkedHashMap<DropdownLabel, DropdownBorder>();
        borderMap.put(ControlPanelFont.CUSTOM_KEY, null);
        String errorLine = null;
        try {
            List<String> borderLines = AssetIndexLoader.loadIndexFile(INDEX_BORDERS_FILENAME);
            Iterator<String> iterator = borderLines.iterator();
            while (iterator.hasNext()) {
                String line;
                errorLine = line = iterator.next();
                if (line.trim().startsWith("#")) continue;
                String[] splitLine = line.split(",");
                String category = splitLine[0].trim();
                String name = splitLine[1].trim();
                String filename = splitLine[2].trim();
                int color = Integer.parseInt(splitLine[3].trim(), 16);
                borderMap.put(new DropdownLabel(category, name), new DropdownBorder(filename, color));
            }
        }
        catch (Exception e) {
            logger.error("Error loading border index" + (errorLine == null ? "" : "\n" + errorLine), e);
        }
        return borderMap;
    }

    public static Map<String, List<String[]>> loadPresets() {
        LinkedHashMap<String, List<String[]>> presetMapSubmenuToItem = new LinkedHashMap<String, List<String[]>>();
        String errorLine = null;
        try {
            List<String> presetLines = AssetIndexLoader.loadIndexFile(INDEX_PRESETS_FILENAME);
            Iterator<String> iterator = presetLines.iterator();
            while (iterator.hasNext()) {
                String line;
                errorLine = line = iterator.next();
                if (line.trim().startsWith("#")) continue;
                String[] splitLine = line.split(",");
                String category = splitLine[0].trim();
                String item = splitLine[1].trim();
                String filename = splitLine[2].trim();
                ArrayList<String[]> catArray = (ArrayList<String[]>)presetMapSubmenuToItem.get(category);
                if (catArray == null) {
                    catArray = new ArrayList<String[]>();
                    presetMapSubmenuToItem.put(category, catArray);
                }
                catArray.add(new String[]{item, "preset://presets/" + filename});
            }
        }
        catch (Exception e) {
            logger.error("Error loading preset index" + (errorLine == null ? "" : "\n" + errorLine), e);
        }
        return presetMapSubmenuToItem;
    }

    private static List<String> loadIndexFile(String indexFilename) throws IOException {
        String line;
        InputStream is = AssetIndexLoader.class.getClassLoader().getResourceAsStream(indexFilename);
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            lines.add(line);
        }
        return lines;
    }
}

