/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.game;

public enum GameSystem {
    NES("NES", "Nintendo", "Nintendo Entertainment System", "Famicom", "Famicom Disk System", "FamicomDiskSystem", "FDS"),
    SNES("SNES", "Super Nintendo", "SuperNintendo", "Super Nintendo Entertainment System", "SuperNintendoEntertainmentSystem", "SFC", "Super Famicom", "SuperFamicom"),
    N64("N64", "Nintendo 64", "Nintendo64", "Ultra 64", "Ultra64"),
    GAME_BOY("Game Boy", "Gameboy", "GB"),
    GAME_BOY_COLOR("Game Boy Color", "Gameboy Color", "GameboyColor", "GBC", "Game Boy Colour", "Gameboy Colour", "GameboyColour"),
    GAME_BOY_ADVANCE("GBA", "Game Boy Advance", "Gameboy Advance", "Game Boy Advance SP", "Game Boy Advanced", "Gameboy Advanced", "Game Boy Advanced SP", "Game Boy SP", "Game Boy Micro"),
    NDS("DS", "NDS", "Nintendo DS", "iQue DS", "Nintendo DS Lite", "DS Lite", "Nintendo DSi", "DSi", "Nintendo DSi XL"),
    PS("PlayStation", "Play Station", "PS", "Sony Playstation", "Sony Play Station"),
    PS2("PS2", "PlayStation 2", "Play Station 2", "Sony Playstation 2", "Sony Play Station 2"),
    GCN("GameCube", "Game Cube", "GCN", "NGC"),
    SMS("Master System", "MasterSystem", "SMS", "Sega Master System", "Sega MasterSystem"),
    GENESIS("Genesis", "Sega Genesis", "SegaGenesis", "Mega Drive", "MegaDrive", "Sega Mega Drive", "Sega MegaDrive"),
    SATURN("Saturn", "Sega Saturn", "SegaSaturn"),
    DREAMCAST("Dreamcast", "Sega Dreamcast", "SegaDreamcast"),
    PC("PC", "Personal Computer", "Computer", "Mac");

    private final String[] names;

    private GameSystem(String ... names) {
        this.names = names;
    }

    public String[] getNames() {
        return this.names;
    }

    public boolean matchesName(String testName) {
        String[] stringArray = this.names;
        int n = this.names.length;
        int n2 = 0;
        while (n2 < n) {
            String n3 = stringArray[n2];
            if (testName.equalsIgnoreCase(n3)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String toString() {
        return this.names[0];
    }

    public static GameSystem getByName(String testName) {
        if (testName != null) {
            GameSystem[] gameSystemArray = GameSystem.values();
            int n = gameSystemArray.length;
            int n2 = 0;
            while (n2 < n) {
                GameSystem system = gameSystemArray[n2];
                String[] stringArray = system.getNames();
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String n5 = stringArray[n4];
                    if (testName.toLowerCase().equals(n5)) {
                        return system;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return null;
    }
}

