/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.emoji.loader;

import com.glitchcog.fontificator.bot.UserType;
import com.glitchcog.fontificator.config.ConfigEmoji;
import com.glitchcog.fontificator.emoji.EmojiManager;
import com.glitchcog.fontificator.emoji.EmojiType;
import com.glitchcog.fontificator.emoji.LazyLoadEmoji;
import com.glitchcog.fontificator.emoji.TypedEmojiMap;
import com.glitchcog.fontificator.emoji.loader.betterttv.BttvEmote;
import com.glitchcog.fontificator.emoji.loader.frankerfacez.Badge;
import com.glitchcog.fontificator.emoji.loader.frankerfacez.FfzBadgesAndUsers;
import com.glitchcog.fontificator.emoji.loader.frankerfacez.FfzEmote;
import com.glitchcog.fontificator.emoji.loader.frankerfacez.Room;
import com.glitchcog.fontificator.emoji.loader.twitch.TwitchBadges;
import com.glitchcog.fontificator.emoji.loader.twitch.TwitchIdSetLink;
import com.glitchcog.fontificator.gui.controls.panel.LogBox;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.awt.Color;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class EmojiParser {
    private static final int TWITCH_BADGE_PIXEL_SIZE = 18;
    private LogBox logBox;

    public EmojiParser(LogBox logBox) {
        this.logBox = logBox;
    }

    public void putJsonEmojiIntoManager(EmojiManager manager, EmojiType type, String jsonData) throws IOException {
        TypedEmojiMap emojiMap = manager.getEmojiByType(type);
        switch (type) {
            case FRANKERFACEZ_CHANNEL: 
            case FRANKERFACEZ_GLOBAL: {
                this.parseFrankerFaceZEmoteJson(emojiMap, jsonData, type == EmojiType.FRANKERFACEZ_GLOBAL);
                break;
            }
            case FRANKERFACEZ_BADGE: {
                this.parseFrankerFaceZBadges(manager, jsonData);
                break;
            }
            case TWITCH_BADGE: {
                this.parseTwitchBadges(emojiMap, jsonData);
                break;
            }
            case BETTER_TTV_CHANNEL: 
            case BETTER_TTV_GLOBAL: {
                this.parseBetterTtvEmoteJson(emojiMap, jsonData, type == EmojiType.BETTER_TTV_GLOBAL);
                break;
            }
        }
    }

    protected Map<Integer, Integer> parseSetMap(String jsonMapData) {
        Gson gson = new Gson();
        JsonElement setLinksElement = new JsonParser().parse(jsonMapData).getAsJsonObject().get("emoticons");
        Type setLinkType = new TypeToken<TwitchIdSetLink[]>(){}.getType();
        TwitchIdSetLink[] idToSetTwitchLinks = (TwitchIdSetLink[])gson.fromJson(setLinksElement, setLinkType);
        HashMap<Integer, Integer> setIdByEmoteId = new HashMap<Integer, Integer>();
        TwitchIdSetLink[] twitchIdSetLinkArray = idToSetTwitchLinks;
        int n = idToSetTwitchLinks.length;
        int n2 = 0;
        while (n2 < n) {
            TwitchIdSetLink tLink = twitchIdSetLinkArray[n2];
            Integer emoteId = Integer.parseInt(tLink.getId());
            Integer setId = tLink.getEmoticon_set() == null ? null : Integer.valueOf(Integer.parseInt(tLink.getEmoticon_set()));
            setIdByEmoteId.put(emoteId, setId);
            ++n2;
        }
        return setIdByEmoteId;
    }

    private void parseTwitchBadges(TypedEmojiMap badgeMap, String jsonData) throws IOException {
        JsonElement jsonElement = new JsonParser().parse(jsonData);
        Gson gson = new Gson();
        Type emoteType = new TypeToken<Map<String, TwitchBadges>>(){}.getType();
        Map jsonMap = (Map)gson.fromJson(jsonElement, emoteType);
        Color subBgColor = new Color(6570404);
        int badgeCount = 0;
        for (Map.Entry badge : jsonMap.entrySet()) {
            if (badge.getValue() == null || ((TwitchBadges)badge.getValue()).getImage() == null) continue;
            boolean isSubBadge = "subscriber".equals(badge.getKey());
            ++badgeCount;
            LazyLoadEmoji llBadge = new LazyLoadEmoji((String)badge.getKey(), ((TwitchBadges)badge.getValue()).getImage(), 18, 18, isSubBadge ? subBgColor : null, EmojiType.TWITCH_BADGE);
            badgeMap.put((String)badge.getKey(), llBadge);
        }
        this.logBox.log(String.valueOf(badgeCount) + " Twitch badge" + (badgeCount == 1 ? "" : "s") + " loaded");
    }

    private void parseFrankerFaceZBadges(EmojiManager manager, String jsonData) throws IOException {
        JsonElement ffzBadgesAndUsersElement = new JsonParser().parse(jsonData);
        Gson gson = new Gson();
        Type emoteType = new TypeToken<FfzBadgesAndUsers>(){}.getType();
        FfzBadgesAndUsers badgesAndUsers = (FfzBadgesAndUsers)gson.fromJson(ffzBadgesAndUsersElement, emoteType);
        for (Badge b : badgesAndUsers.getBadges()) {
            manager.getEmojiByType(EmojiType.FRANKERFACEZ_BADGE).put("" + b.getId(), new LazyLoadEmoji(b.getName(), "moderator".equals(b.getReplaces()) ? UserType.MOD.getKey() : b.getReplaces(), "https:" + b.getImage(), b.getColorParsed(), EmojiType.FRANKERFACEZ_BADGE));
        }
        manager.setFfzBadgeUsers(badgesAndUsers.getUsers());
    }

    public void parseFrankerFaceZModBadge(EmojiManager manager, String jsonData) throws IOException {
        boolean customFfzModBadgeExists;
        Gson gson = new Gson();
        Type roomType = new TypeToken<Room>(){}.getType();
        JsonObject jsonObject = new JsonParser().parse(jsonData).getAsJsonObject();
        Room room = (Room)gson.fromJson(jsonObject.get("room"), roomType);
        boolean bl = customFfzModBadgeExists = room != null && room.getModerator_badge() != null;
        if (customFfzModBadgeExists) {
            LazyLoadEmoji modLle = new LazyLoadEmoji(UserType.MOD.getKey(), UserType.MOD.getKey(), "https:" + room.getModerator_badge(), ConfigEmoji.MOD_BADGE_COLOR, EmojiType.FRANKERFACEZ_BADGE);
            manager.getEmojiByType(EmojiType.FRANKERFACEZ_BADGE).put(UserType.MOD.getKey(), modLle);
            this.logBox.log("Loaded the custom FrankerFaceZ moderator badge");
        }
    }

    private void parseFrankerFaceZEmoteJson(TypedEmojiMap emoji, String jsonData, boolean isGlobal) throws IOException {
        ArrayList<String> setsToLoad;
        JsonParser jp = new JsonParser();
        JsonObject root = jp.parse(jsonData).getAsJsonObject();
        if (root.get("error") != null) {
            String errorMessage = "Unable to load FrankerFaceZ emotes";
            if (!root.get("message").isJsonNull()) {
                errorMessage = String.valueOf(errorMessage) + ": " + root.get("message");
            }
            this.logBox.log(errorMessage);
            return;
        }
        if (root.get("sets").isJsonNull() || isGlobal && root.get("default_sets").isJsonNull()) {
            this.logBox.log("Unable to load FrankerFaceZ global emotes");
            return;
        }
        if (isGlobal) {
            setsToLoad = new ArrayList<String>();
            JsonArray defaultSetsArray = root.get("default_sets").getAsJsonArray();
            int i = 0;
            while (i < defaultSetsArray.size()) {
                setsToLoad.add(defaultSetsArray.get(i).getAsString());
                ++i;
            }
        } else {
            setsToLoad = null;
        }
        JsonObject sets = root.get("sets").getAsJsonObject();
        Gson gson = new Gson();
        Type emoteType = new TypeToken<FfzEmote[]>(){}.getType();
        int frankerCount = 0;
        int eMultiCount = 0;
        ArrayList<String> setNames = new ArrayList<String>();
        for (Map.Entry<String, JsonElement> entry : sets.entrySet()) {
            FfzEmote[] jsonEmoteObjects;
            setNames.add(entry.getKey());
            JsonElement emoteElement = entry.getValue().getAsJsonObject().get("emoticons");
            FfzEmote[] ffzEmoteArray = jsonEmoteObjects = (FfzEmote[])gson.fromJson(emoteElement, emoteType);
            int n = jsonEmoteObjects.length;
            int n2 = 0;
            while (n2 < n) {
                FfzEmote e = ffzEmoteArray[n2];
                LazyLoadEmoji lle = null;
                Iterator<String> iterator = e.getUrls().keySet().iterator();
                if (iterator.hasNext()) {
                    String key = iterator.next();
                    lle = new LazyLoadEmoji(e.getName(), "https:" + e.getUrls().get(key), e.getWidth(), e.getHeight(), isGlobal ? EmojiType.FRANKERFACEZ_GLOBAL : EmojiType.FRANKERFACEZ_CHANNEL);
                }
                if (e.getUrls().size() > 1) {
                    ++eMultiCount;
                }
                emoji.put(e.getName(), lle);
                ++frankerCount;
                ++n2;
            }
        }
        String allSets = "";
        int n = 0;
        while (n < setNames.size()) {
            allSets = String.valueOf(allSets) + (n == 0 ? "" : ", ") + (String)setNames.get(n);
            ++n;
        }
        this.logBox.log(String.valueOf(setNames.size()) + " FrankerFaceZ set" + (setNames.size() == 1 ? "" : "s") + " found: {" + allSets + "}");
        this.logBox.log(String.valueOf(frankerCount) + " FrankerFaceZ emote" + (frankerCount == 1 ? "" : "s") + " loaded (" + eMultiCount + " multi-image emote" + (eMultiCount == 1 ? "" : "s") + ")");
    }

    private void parseBetterTtvEmoteJson(TypedEmojiMap emoji, String jsonData, boolean isGlobal) throws IOException {
        JsonParser jp = new JsonParser();
        JsonObject root = jp.parse(jsonData).getAsJsonObject();
        if (root.get("emotes").isJsonNull()) {
            this.logBox.log("Unable to load Better TTV global emotes");
            return;
        }
        Gson gson = new Gson();
        Type emoteType = new TypeToken<BttvEmote[]>(){}.getType();
        String urlTemplate = "https:" + root.get("urlTemplate").getAsString().replace("{{image}}", "2x");
        BttvEmote[] bttvEmotes = (BttvEmote[])gson.fromJson((JsonElement)root.get("emotes").getAsJsonArray(), emoteType);
        int bttvCount = 0;
        BttvEmote[] bttvEmoteArray = bttvEmotes;
        int n = bttvEmotes.length;
        int n2 = 0;
        while (n2 < n) {
            BttvEmote be = bttvEmoteArray[n2];
            LazyLoadEmoji lle = new LazyLoadEmoji(be.getCode(), urlTemplate.replace("{{id}}", be.getId()), isGlobal ? EmojiType.BETTER_TTV_GLOBAL : EmojiType.BETTER_TTV_CHANNEL);
            lle.setAnimatedGif("gif".equals(be.getImageType()));
            emoji.put(be.getCode(), lle);
            ++bttvCount;
            ++n2;
        }
        this.logBox.log(String.valueOf(bttvCount) + " Better TTV emote" + (bttvCount == 1 ? "" : "s") + " found");
    }
}

