/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.emoji.loader;

import com.glitchcog.fontificator.emoji.EmojiType;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.log4j.Logger;

public class EmojiApiLoader {
    private static final Logger logger = Logger.getLogger(EmojiApiLoader.class);
    private static final String CHANNEL_NAME_REPLACE = "%CHANNEL_NAME%";
    public static final String OAUTH_REPLACE = "%OAUTH%";
    public static final String EMOTE_ID_REPLACE = "%EMOTE_ID%";
    public static final String EMOTE_SIZE_REPLACE = "%EMOTE_SIZE%";
    public static final String TWITCH_EMOTE_ID_V1_URL = "https://static-cdn.jtvnw.net/emoticons/v1/%EMOTE_ID%/%EMOTE_SIZE%";
    private static final String TWITCH_URL_BADGES = "https://api.twitch.tv/kraken/chat/%CHANNEL_NAME%/badges%OAUTH%";
    private static final String FFZ_GLOBAL_URL = "https://api.frankerfacez.com/v1/set/global";
    private static final String FFZ_BASE_URL = "https://api.frankerfacez.com/v1/room/%CHANNEL_NAME%";
    private static final String FFZ_BADGES = "https://api.frankerfacez.com/v1/badges";
    private static final String BTTV_GLOBAL_URL = "https://api.betterttv.net/2/emotes";
    private static final String BTTV_BASE_URL = "https://api.betterttv.net/2/channels/%CHANNEL_NAME%";
    private static final int BUFFER_SIZE = 512;
    private final char[] buffer = new char[512];
    private StringBuilder jsonStringBuilder;
    private String url;
    private float jsonLength;
    private BufferedReader reader;
    private boolean loadComplete;

    public static String getTwitchEmoteV1Url(Integer emoteId) {
        return EmojiApiLoader.getTwitchEmoteV1Url(emoteId, 2);
    }

    public static String getTwitchEmoteV1Url(Integer emoteId, int emoteSize) {
        if (1 > emoteSize || emoteSize > 3) {
            logger.warn("Invalid emote size: " + emoteSize + ". Valid sizes are 1, 2, or 3.");
            emoteSize = 2;
            logger.info("Defaulting to size " + emoteSize + ".");
        }
        return TWITCH_EMOTE_ID_V1_URL.replaceAll(EMOTE_ID_REPLACE, Integer.toString(emoteId)).replaceAll(EMOTE_SIZE_REPLACE, String.valueOf(Integer.toString(emoteSize)) + ".0");
    }

    public void reset() {
        this.jsonStringBuilder = null;
        this.url = null;
        this.jsonLength = 0.0f;
        this.reader = null;
        this.loadComplete = false;
    }

    public void prepLoad(String url) {
        this.loadComplete = false;
        this.jsonStringBuilder = new StringBuilder();
        this.url = url;
    }

    public void prepLoad(EmojiType emojiType, String channel, String oauth) {
        channel = channel == null ? null : channel.toLowerCase();
        String chanUrl = this.getUrl(emojiType, channel, oauth);
        this.prepLoad(chanUrl);
    }

    private String getUrl(EmojiType emojiType, String channel, String oauth) {
        switch (emojiType) {
            case FRANKERFACEZ_CHANNEL: {
                return FFZ_BASE_URL.replaceAll(CHANNEL_NAME_REPLACE, channel);
            }
            case FRANKERFACEZ_GLOBAL: {
                return FFZ_GLOBAL_URL;
            }
            case FRANKERFACEZ_BADGE: {
                return FFZ_BADGES;
            }
            case BETTER_TTV_CHANNEL: {
                return BTTV_BASE_URL.replaceAll(CHANNEL_NAME_REPLACE, channel);
            }
            case BETTER_TTV_GLOBAL: {
                return BTTV_GLOBAL_URL;
            }
            case TWITCH_BADGE: {
                oauth = EmojiApiLoader.formatOauth(oauth);
                return TWITCH_URL_BADGES.replaceAll(CHANNEL_NAME_REPLACE, channel).replaceAll(OAUTH_REPLACE, oauth);
            }
        }
        return null;
    }

    private static String formatOauth(String oauth) {
        if (oauth == null) {
            oauth = "";
        }
        String oauthLabel = "oauth:";
        if (oauth.contains("oauth:")) {
            oauth = oauth.substring("oauth:".length());
        }
        oauth = "?oauth_token=" + oauth;
        return oauth;
    }

    public boolean initLoad() throws IOException, MalformedURLException, FileNotFoundException {
        if (this.url != null) {
            URL url = new URL(this.url);
            URLConnection conn = url.openConnection();
            this.jsonLength = conn.getContentLengthLong();
            this.reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            return true;
        }
        return false;
    }

    public boolean isPercentCalculationPossible() {
        return this.jsonLength > 0.0f;
    }

    public int loadChunk() throws IOException, MalformedURLException {
        int n = this.reader.read(this.buffer);
        if (n == -1) {
            this.loadComplete = true;
        } else {
            this.jsonStringBuilder.append(this.buffer, 0, n);
        }
        return this.isPercentCalculationPossible() ? (int)(100.0f * ((float)this.jsonStringBuilder.length() / this.jsonLength)) : this.jsonStringBuilder.length();
    }

    public boolean isLoadComplete() {
        return this.loadComplete;
    }

    public String getLoadedJson() {
        return this.jsonStringBuilder == null ? null : this.jsonStringBuilder.toString();
    }
}

