/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.emoji;

import com.glitchcog.fontificator.config.ConfigEmoji;
import com.glitchcog.fontificator.emoji.EmojiType;
import com.glitchcog.fontificator.emoji.LazyLoadEmoji;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class TypedEmojiMap {
    private final EmojiType type;
    private Map<String, LazyLoadEmoji> normalMap;
    private Map<String, LazyLoadEmoji> regexMap;

    public TypedEmojiMap(EmojiType type) {
        this.type = type;
        this.normalMap = new HashMap<String, LazyLoadEmoji>();
        this.regexMap = new HashMap<String, LazyLoadEmoji>();
    }

    public LazyLoadEmoji getEmoji(Integer testKey) {
        return this.getEmoji(testKey == null ? null : Integer.toString(testKey));
    }

    public LazyLoadEmoji getEmoji(String testKey) {
        return this.getEmoji(testKey, null);
    }

    public LazyLoadEmoji getEmoji(String testKey, ConfigEmoji config) {
        if (config != null && !config.isTypeEnabledAndLoaded(this.type)) {
            return null;
        }
        LazyLoadEmoji emoji = this.normalMap.get(testKey);
        if (emoji == null) {
            for (String regex : this.regexMap.keySet()) {
                if (!testKey.matches(regex)) continue;
                emoji = this.regexMap.get(regex);
                break;
            }
        }
        return emoji;
    }

    public LazyLoadEmoji put(String key, LazyLoadEmoji value) {
        if (TypedEmojiMap.isRegularExpression(key)) {
            key = this.fixRegularExpression(key);
            return this.regexMap.put(key, value);
        }
        return this.normalMap.put(key, value);
    }

    public Collection<String> keySet() {
        HashSet<String> keys = new HashSet<String>(this.normalMap.keySet().size() + this.regexMap.keySet().size());
        keys.addAll(this.normalMap.keySet());
        keys.addAll(this.regexMap.keySet());
        return keys;
    }

    private static boolean isRegularExpression(String key) {
        return !key.matches("^[a-zA-Z0-9_]*$");
    }

    private String fixRegularExpression(String regex) {
        regex = regex.replaceAll("\\\\\\\\", "\\\\");
        regex = regex.replaceAll("\\\\;", ";");
        regex = regex.replaceAll("\\\\:", ":");
        regex = regex.replaceAll("\\\\&", "&");
        regex = regex.replaceAll("&lt;", "<");
        regex = regex.replaceAll("&gt;", ">");
        if (this.type.isBetterTtvEmote()) {
            regex = regex.replaceAll("\\(", "\\\\(");
            regex = regex.replaceAll("\\)", "\\\\)");
        }
        return regex;
    }

    public Map<String, LazyLoadEmoji> getNormalMap() {
        return this.normalMap;
    }

    public Map<String, LazyLoadEmoji> getRegexMap() {
        return this.regexMap;
    }
}

