/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.emoji;

import com.glitchcog.fontificator.emoji.AnimatedGifUtil;
import com.glitchcog.fontificator.emoji.EmojiOpacityHandler;
import com.glitchcog.fontificator.emoji.EmojiType;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;

public class LazyLoadEmoji {
    private static final Logger logger = Logger.getLogger(LazyLoadEmoji.class);
    private static List<String> BUSTED_URLS = new ArrayList<String>();
    private final String identifier;
    private final String replaces;
    private final EmojiType type;
    private Image image;
    private Image animatedGifImage;
    private URL url;
    private boolean subscriber;
    private String state;
    private int width;
    private int height;
    private boolean animated;
    private boolean animatedGif;
    private static final int DEFAULT_EMOJI_SIZE = 24;
    private boolean firstLoadFailureReported;
    private final Color bgColor;

    public LazyLoadEmoji(String id, String url, EmojiType type) throws MalformedURLException {
        this(id, null, url, null, type);
    }

    public LazyLoadEmoji(String id, String replaces, String url, Color bgColor, EmojiType type) throws MalformedURLException {
        this(id, replaces, url, 24, 24, bgColor, type);
    }

    public LazyLoadEmoji(String identifier, String url, int width, int height, EmojiType type) throws MalformedURLException {
        this(identifier, url, width, height, null, type);
    }

    public LazyLoadEmoji(String identifier, String url, int width, int height, Color bgColor, EmojiType type) throws MalformedURLException {
        this(identifier, null, url, width, height, bgColor, type);
    }

    public LazyLoadEmoji(String identifier, String replaces, String url, int width, int height, Color bgColor, EmojiType type) throws MalformedURLException {
        this.identifier = identifier;
        this.replaces = replaces;
        this.url = new URL(url);
        this.type = type;
        this.width = width;
        this.height = height;
        this.firstLoadFailureReported = false;
        this.bgColor = bgColor;
    }

    public void cacheImage() {
        this.getImage(this.isAnimatedGif());
    }

    public Image getImage(boolean animated) {
        block9: {
            if (this.url == null || BUSTED_URLS.contains(this.url.toString())) {
                return null;
            }
            if (this.image == null) {
                if (!LazyLoadEmoji.checkUrl(this.url)) {
                    BUSTED_URLS.add(this.url.toString());
                    return null;
                }
                try {
                    BufferedImage imageFromTwitch = ImageIO.read(this.url);
                    this.image = EmojiOpacityHandler.isCandidateForModification(this.type, imageFromTwitch.getType(), this.identifier) ? EmojiOpacityHandler.fixOpaqueEmote(this.identifier, imageFromTwitch) : imageFromTwitch;
                    if (this.image != null) {
                        this.width = this.image.getWidth(null);
                        this.height = this.image.getHeight(null);
                    }
                }
                catch (IOException e) {
                    if (this.firstLoadFailureReported) break block9;
                    logger.error("Unable to load emoji: " + this.url, e);
                    this.firstLoadFailureReported = true;
                    this.image = null;
                }
            }
        }
        if (this.animatedGif && this.animatedGifImage == null) {
            if ("(ditto)".equals(this.identifier)) {
                Dimension dim = new Dimension();
                this.animatedGifImage = AnimatedGifUtil.loadDittoAnimatedGif(this.url, dim);
                this.width = (int)dim.getWidth();
                this.height = (int)dim.getHeight();
            } else {
                this.animatedGifImage = AnimatedGifUtil.loadAnimatedGif(this.url);
            }
        }
        return animated && this.animatedGif ? this.animatedGifImage : this.image;
    }

    public boolean isSubscriber() {
        return this.subscriber;
    }

    public void setSubscriber(boolean subscriber) {
        this.subscriber = subscriber;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public EmojiType getType() {
        return this.type;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public URL getUrl() {
        return this.url;
    }

    public boolean isAnimated() {
        return this.animated;
    }

    public void setAnimated(boolean animated) {
        this.animated = animated;
    }

    public boolean isAnimatedGif() {
        return this.animatedGif;
    }

    public void setAnimatedGif(boolean animatedGif) {
        this.animatedGif = animatedGif;
    }

    public boolean isColoringRequired() {
        return this.type == EmojiType.FRANKERFACEZ_BADGE || this.bgColor != null;
    }

    public Color getBgColor() {
        return this.bgColor;
    }

    public boolean isReplacement() {
        return this.replaces != null;
    }

    public String getReplaces() {
        return this.replaces;
    }

    public static boolean checkUrl(URL url) {
        try {
            HttpURLConnection.setFollowRedirects(true);
            HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection();
            httpURLConnection.setRequestMethod("HEAD");
            httpURLConnection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 6.0; en-US; rv:1.9.1.2) Gecko/20090729 Firefox/3.5.2 (.NET CLR 3.5.30729)");
            int responseCode = httpURLConnection.getResponseCode();
            return responseCode == 200;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), e);
            return false;
        }
    }
}

