/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.emoji;

import com.glitchcog.fontificator.emoji.EmojiGroup;

public enum EmojiType {
    TWITCH_V1("Twitch Emotes from Chat V1", EmojiGroup.TWITCH, false),
    TWITCH_BADGE("Twitch Badge", EmojiGroup.TWITCH, true),
    FRANKERFACEZ_CHANNEL("FrankerFaceZ Emotes", EmojiGroup.FFZ, false),
    FRANKERFACEZ_GLOBAL("FrankerFaceZ Global Emotes", EmojiGroup.FFZ, false),
    FRANKERFACEZ_BADGE("FrankerFaceZ Badge", EmojiGroup.FFZ, true),
    FRANKERFACEZ_REPLACEMENT("FrankerFaceZ Replacement Emotes", EmojiGroup.FFZ, false),
    BETTER_TTV_CHANNEL("Better Twitch TV Emotes", EmojiGroup.BTTV, false),
    BETTER_TTV_GLOBAL("Better Twitch TV Global Emotes", EmojiGroup.BTTV, false),
    TWITTER_EMOJI("Twitter Unicode Emotes", EmojiGroup.UNICODE, false);

    private final EmojiGroup group;
    private final boolean badge;
    private final String description;
    public static EmojiType[] MANUAL_EMOJI_TYPES;
    public static EmojiType[] THIRD_PARTY_EMOJI_TYPES;

    static {
        MANUAL_EMOJI_TYPES = new EmojiType[]{FRANKERFACEZ_CHANNEL, FRANKERFACEZ_GLOBAL, BETTER_TTV_CHANNEL, BETTER_TTV_GLOBAL, TWITTER_EMOJI};
        THIRD_PARTY_EMOJI_TYPES = new EmojiType[]{FRANKERFACEZ_CHANNEL, FRANKERFACEZ_GLOBAL, BETTER_TTV_CHANNEL, BETTER_TTV_GLOBAL, TWITTER_EMOJI};
    }

    private EmojiType(String description, EmojiGroup group, boolean badge) {
        this.group = group;
        this.description = description;
        this.badge = badge;
    }

    public boolean isTwitchEmote() {
        return this.group == EmojiGroup.TWITCH;
    }

    public boolean isFrankerFaceZEmote() {
        return this.group == EmojiGroup.FFZ;
    }

    public boolean isBetterTtvEmote() {
        return this.group == EmojiGroup.BTTV;
    }

    public boolean isBadge() {
        return this.badge;
    }

    public String getDescription() {
        return this.description;
    }
}

