/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.emoji;

import com.glitchcog.fontificator.emoji.EmojiType;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class EmojiOpacityHandler {
    private static final Logger logger = Logger.getLogger(EmojiOpacityHandler.class);
    public static final Map<String, Double> TWITCH_EMOTES_WITH_OPAQUE_BACKGROUNDS = new HashMap<String, Double>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("Kappa", 0.0);
            this.put("StoneLightning", 0.21);
            this.put("TheRinger", 0.11);
            this.put("EagleEye", 0.12);
            this.put("CougarHunt", 0.085);
            this.put("RedCoat", 0.12);
        }
    };

    public static boolean isCandidateForModification(EmojiType emojiType, int imageType, String identifier) {
        boolean emojiTypeQualifies = emojiType.isTwitchEmote();
        boolean specificEmojiQualifies = false;
        for (String key : TWITCH_EMOTES_WITH_OPAQUE_BACKGROUNDS.keySet()) {
            if (!key.equals(identifier)) continue;
            specificEmojiQualifies = true;
            break;
        }
        return emojiTypeQualifies && specificEmojiQualifies;
    }

    public static Image fixOpaqueEmote(String identifier, Image imageFromTwitch) {
        logger.trace("Doing custom background transparancy for " + identifier + " emote");
        BufferedImage customTransparencyImage = new BufferedImage(imageFromTwitch.getWidth(null), imageFromTwitch.getHeight(null), 2);
        Graphics big = customTransparencyImage.getGraphics();
        big.drawImage(imageFromTwitch, 0, 0, null);
        int pixelThatShouldBeTransparent = customTransparencyImage.getRGB(0, 0);
        int transparentPixel = new Color(0, true).getRGB();
        int y = 0;
        while (y < customTransparencyImage.getHeight()) {
            int x = 0;
            while (x < customTransparencyImage.getWidth()) {
                if (EmojiOpacityHandler.getDifferenceBetweenColors(customTransparencyImage.getRGB(x, y), pixelThatShouldBeTransparent) <= TWITCH_EMOTES_WITH_OPAQUE_BACKGROUNDS.get(identifier)) {
                    customTransparencyImage.setRGB(x, y, transparentPixel);
                }
                ++x;
            }
            ++y;
        }
        return customTransparencyImage;
    }

    private static double getDifferenceBetweenColors(int a, int b) {
        Color ca = new Color(a);
        Color cb = new Color(b);
        double rDiff = ca.getRed() - cb.getRed();
        double gDiff = ca.getGreen() - cb.getGreen();
        double bDiff = ca.getBlue() - cb.getBlue();
        double diff = Math.sqrt(rDiff * rDiff + gDiff * gDiff + bDiff * bDiff);
        double percentDiff = diff / Math.sqrt(195075.0);
        return percentDiff;
    }
}

