/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.emoji;

import com.glitchcog.fontificator.config.ConfigEmoji;
import com.glitchcog.fontificator.emoji.EmojiType;
import com.glitchcog.fontificator.emoji.LazyLoadEmoji;
import com.glitchcog.fontificator.emoji.TypedEmojiMap;
import com.glitchcog.fontificator.emoji.loader.EmojiApiLoader;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class EmojiManager {
    private static final Logger logger = Logger.getLogger(EmojiManager.class);
    private static final String FFZ_REPLACEMENT_EMOTE_URL_BASE = "https://cdn.frankerfacez.com/static/replacements/";
    private static final Map<Integer, String> FFZ_REPLACEMENT_EMOTE_URLS = new HashMap<Integer, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(15, "https://cdn.frankerfacez.com/static/replacements/15-JKanStyle.png");
            this.put(16, "https://cdn.frankerfacez.com/static/replacements/16-OptimizePrime.png");
            this.put(17, "https://cdn.frankerfacez.com/static/replacements/17-StoneLightning.png");
            this.put(18, "https://cdn.frankerfacez.com/static/replacements/18-TheRinger.png");
            this.put(19, "https://cdn.frankerfacez.com/static/replacements/19-PazPazowitz.png");
            this.put(20, "https://cdn.frankerfacez.com/static/replacements/20-EagleEye.png");
            this.put(21, "https://cdn.frankerfacez.com/static/replacements/21-CougarHunt.png");
            this.put(22, "https://cdn.frankerfacez.com/static/replacements/22-RedCoat.png");
            this.put(26, "https://cdn.frankerfacez.com/static/replacements/26-JonCarnage.png");
            this.put(33, "https://cdn.frankerfacez.com/static/replacements/33-DansGame.png");
            this.put(26, "https://cdn.frankerfacez.com/static/replacements/26-JonCarnage.png");
            this.put(27, "https://cdn.frankerfacez.com/static/replacements/27-PicoMause.png");
            this.put(30, "https://cdn.frankerfacez.com/static/replacements/30-BCWarrior.png");
            this.put(33, "https://cdn.frankerfacez.com/static/replacements/33-DansGame.png");
            this.put(36, "https://cdn.frankerfacez.com/static/replacements/36-PJSalt.png");
        }
    };
    private Map<EmojiType, TypedEmojiMap> preloadedEmoji;
    private Map<String, LazyLoadEmoji> emojiById;
    private Map<Integer, Set<String>> ffzBadgeUsers = new HashMap<Integer, Set<String>>();

    public EmojiManager() {
        this.preloadedEmoji = new HashMap<EmojiType, TypedEmojiMap>();
        EmojiType[] emojiTypeArray = EmojiType.values();
        int n = emojiTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            EmojiType type = emojiTypeArray[n2];
            this.preloadedEmoji.put(type, new TypedEmojiMap(type));
            ++n2;
        }
        this.emojiById = new HashMap<String, LazyLoadEmoji>();
    }

    public TypedEmojiMap getEmojiByType(EmojiType type) {
        return this.preloadedEmoji.get((Object)type);
    }

    public LazyLoadEmoji getEmojiWords(EmojiType type, String testKey, ConfigEmoji config) {
        return this.getEmojiWords(new EmojiType[]{type}, testKey, config);
    }

    public LazyLoadEmoji getEmojiWords(EmojiType[] types, String testKey, ConfigEmoji config) {
        LazyLoadEmoji emoji = null;
        EmojiType[] emojiTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            TypedEmojiMap typedEmoji;
            EmojiType type = emojiTypeArray[n2];
            if ((config == null || config.isTypeEnabledAndLoaded(type)) && (typedEmoji = this.preloadedEmoji.get((Object)type)) != null && (emoji = typedEmoji.getEmoji(testKey, config)) != null) {
                return emoji;
            }
            ++n2;
        }
        return emoji;
    }

    public LazyLoadEmoji putEmojiById(Integer emojiId, String word, ConfigEmoji emojiConfig) throws MalformedURLException {
        logger.trace("Loading unmapped emote from emote ID " + emojiId);
        String emoteUrl = EmojiApiLoader.getTwitchEmoteV1Url(emojiId);
        LazyLoadEmoji emoji = new LazyLoadEmoji(word, emoteUrl, EmojiType.TWITCH_V1);
        this.emojiById.put(Integer.toString(emojiId), emoji);
        return emoji;
    }

    public LazyLoadEmoji getEmojiById(Integer emojiId, String word, ConfigEmoji emojiConfig) {
        if (emojiConfig != null && emojiConfig.isTwitchEnabled() && emojiConfig.isFfzEnabled() && FFZ_REPLACEMENT_EMOTE_URLS.keySet().contains(emojiId)) {
            TypedEmojiMap tem = this.preloadedEmoji.get((Object)EmojiType.FRANKERFACEZ_REPLACEMENT);
            LazyLoadEmoji emoji = tem.getEmoji(EmojiManager.getFfzReplacementKey(emojiId), emojiConfig);
            if (emoji == null) {
                try {
                    logger.trace("Loading replacement FFZ emote for " + word);
                    emoji = new LazyLoadEmoji(word, FFZ_REPLACEMENT_EMOTE_URLS.get(emojiId), EmojiType.FRANKERFACEZ_REPLACEMENT);
                    tem.put(EmojiManager.getFfzReplacementKey(emojiId), emoji);
                    return emoji;
                }
                catch (MalformedURLException e) {
                    logger.error(e.toString(), e);
                    return this.emojiById.get(Integer.toString(emojiId));
                }
            }
            return emoji;
        }
        if (emojiConfig != null && emojiConfig.isTwitchEnabled()) {
            return this.emojiById.get(Integer.toString(emojiId));
        }
        return null;
    }

    private static String getFfzReplacementKey(Integer emojiId) {
        return "FfzRep" + Integer.toString(emojiId);
    }

    public void setFfzBadgeUsers(Map<Integer, Set<String>> ffzBadgeUsers) {
        this.ffzBadgeUsers = ffzBadgeUsers;
    }

    public Map<Integer, Set<String>> getFfzBadgeUsers() {
        return this.ffzBadgeUsers;
    }
}

