/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.config.loadreport;

import com.glitchcog.fontificator.config.loadreport.LoadConfigErrorType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class LoadConfigReport {
    private static final int MAX_NUMBER_OF_NON_PROBLEMS = 15;
    private String mainMessage;
    private Set<LoadConfigErrorType> types = new HashSet<LoadConfigErrorType>();
    private List<String> messages = new ArrayList<String>();
    private String directory;

    public LoadConfigReport() {
    }

    public LoadConfigReport(LoadConfigErrorType type) {
        this();
        this.types.add(type);
    }

    public void addError(String message, LoadConfigErrorType type) {
        this.messages.add(message);
        this.types.add(type);
    }

    public boolean isErrorFree() {
        return this.messages.isEmpty();
    }

    public boolean isSuccess() {
        return !this.isProblem();
    }

    public boolean isProblem() {
        for (LoadConfigErrorType result : this.types) {
            if (!result.isProblem()) continue;
            return true;
        }
        return this.messages.size() > 15;
    }

    public boolean isOnlyMissingKeys() {
        for (LoadConfigErrorType result : this.types) {
            if (result == LoadConfigErrorType.MISSING_KEY) continue;
            return false;
        }
        return true;
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public Set<LoadConfigErrorType> getTypes() {
        return this.types;
    }

    public void addFromReport(LoadConfigReport otherReport) {
        for (String msg : otherReport.getMessages()) {
            this.messages.add(msg);
        }
        for (LoadConfigErrorType rslt : otherReport.getTypes()) {
            this.types.add(rslt);
        }
    }

    public String getMainMessage() {
        return this.mainMessage;
    }

    public void setMainMessage(String mainMessage) {
        this.mainMessage = mainMessage;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }
}

