/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.config;

import com.glitchcog.fontificator.config.ConfigCensor;
import com.glitchcog.fontificator.config.ConfigChat;
import com.glitchcog.fontificator.config.ConfigColor;
import com.glitchcog.fontificator.config.ConfigEmoji;
import com.glitchcog.fontificator.config.ConfigFont;
import com.glitchcog.fontificator.config.ConfigIrc;
import com.glitchcog.fontificator.config.ConfigMessage;
import com.glitchcog.fontificator.config.EmojiLoadingDisplayStragegy;
import com.glitchcog.fontificator.config.FontType;
import com.glitchcog.fontificator.config.MessageCasing;
import com.glitchcog.fontificator.config.UsernameCaseResolutionType;
import com.glitchcog.fontificator.config.loadreport.LoadConfigErrorType;
import com.glitchcog.fontificator.config.loadreport.LoadConfigReport;
import com.glitchcog.fontificator.gui.chat.ChatWindow;
import com.glitchcog.fontificator.gui.controls.ControlWindow;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.util.Properties;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.jasypt.util.text.BasicTextEncryptor;

public class FontificatorProperties
extends Properties {
    private static final Logger logger = Logger.getLogger(FontificatorProperties.class);
    private static final long serialVersionUID = 1L;
    private FontificatorProperties lastSavedCopy;
    private static final String ENC_PASSWORD = "Eastmost penninsula is the secret.";
    private static final String CONFIG_FILE_LAST_LOCATION = ".fontificator.conf";
    public static final String KEY_IRC_USER = "ircUser";
    public static final String KEY_IRC_HOST = "ircHost";
    public static final String KEY_IRC_PORT = "ircPort";
    public static final String KEY_IRC_AUTH = "ircAuth";
    public static final String KEY_IRC_ANON = "ircAnon";
    public static final String KEY_IRC_CHAN = "ircChannel";
    public static final String KEY_IRC_AUTO_RECONNECT = "ircAutoReconnect";
    public static final String[] IRC_KEYS = new String[]{"ircUser", "ircHost", "ircPort", "ircAuth", "ircAnon", "ircChannel", "ircAutoReconnect"};
    public static final String KEY_FONT_FILE_BORDER = "fontBorderFile";
    public static final String KEY_FONT_FILE_FONT = "fontFile";
    public static final String KEY_FONT_TYPE = "fontType";
    public static final String KEY_FONT_GRID_WIDTH = "fontGridWidth";
    public static final String KEY_FONT_GRID_HEIGHT = "fontGridHeight";
    public static final String KEY_FONT_SCALE = "fontScale";
    public static final String KEY_FONT_BORDER_SCALE = "fontBorderScale";
    public static final String KEY_FONT_BORDER_INSET_X = "fontBorderInsetX";
    public static final String KEY_FONT_BORDER_INSET_Y = "fontBorderInsetY";
    public static final String KEY_FONT_SPACE_WIDTH = "fontSpaceWidth";
    public static final String KEY_FONT_BASELINE_OFFSET = "fontBaselineOffset";
    public static final String KEY_FONT_UNKNOWN_CHAR = "fontUnknownChar";
    public static final String KEY_FONT_EXTENDED_CHAR = "fontExtendedChar";
    public static final String KEY_FONT_CHARACTERS = "fontCharacters";
    public static final String KEY_FONT_SPACING_LINE = "fontLineSpacing";
    public static final String KEY_FONT_SPACING_CHAR = "fontCharSpacing";
    public static final String KEY_FONT_SPACING_MESSAGE = "fontMessageSpacing";
    public static final String[] FONT_KEYS = new String[]{"fontBorderFile", "fontFile", "fontType", "fontGridWidth", "fontGridHeight", "fontScale", "fontBorderScale", "fontBorderInsetX", "fontBorderInsetY", "fontSpaceWidth", "fontBaselineOffset", "fontUnknownChar", "fontExtendedChar", "fontCharacters", "fontLineSpacing", "fontCharSpacing", "fontMessageSpacing"};
    public static final String KEY_CHAT_SCROLL = "chatScrollEnabled";
    public static final String KEY_CHAT_RESIZABLE = "chatResizable";
    public static final String KEY_CHAT_POSITION = "chatPosition";
    public static final String KEY_CHAT_POSITION_X = "chatPositionX";
    public static final String KEY_CHAT_POSITION_Y = "chatPositionY";
    public static final String KEY_CHAT_FROM_BOTTOM = "chatFromBottom";
    public static final String KEY_CHAT_WINDOW_WIDTH = "chatWidth";
    public static final String KEY_CHAT_WINDOW_HEIGHT = "chatHeight";
    public static final String KEY_CHAT_WIDTH = "chatPixelWidth";
    public static final String KEY_CHAT_HEIGHT = "chatPixelHeight";
    public static final String KEY_CHAT_CHROMA_ENABLED = "chromaEnabled";
    public static final String KEY_CHAT_INVERT_CHROMA = "invertChroma";
    public static final String KEY_CHAT_REVERSE_SCROLLING = "reverseScrolling";
    public static final String KEY_CHAT_CHROMA_LEFT = "chromaLeft";
    public static final String KEY_CHAT_CHROMA_TOP = "chromaTop";
    public static final String KEY_CHAT_CHROMA_RIGHT = "chromaRight";
    public static final String KEY_CHAT_CHROMA_BOTTOM = "chromaBottom";
    public static final String KEY_CHAT_CHROMA_CORNER = "chromaCornerRadius";
    public static final String KEY_CHAT_ALWAYS_ON_TOP = "chatAlwaysOnTop";
    public static final String KEY_CHAT_ANTIALIAS = "chatAntialias";
    public static final String[] CHAT_KEYS = new String[]{"chatScrollEnabled", "chatResizable", "chatPosition", "chatPositionX", "chatPositionY", "chatFromBottom", "chatPixelWidth", "chatPixelHeight", "chromaEnabled", "invertChroma", "reverseScrolling", "chromaLeft", "chromaTop", "chromaRight", "chromaBottom", "chromaCornerRadius", "chatAlwaysOnTop", "chatAntialias"};
    public static final String[] CHAT_KEYS_EXCEPT_WINDOW_POSITION = new String[]{"chatScrollEnabled", "chatResizable", "chatPosition", "chatFromBottom", "chatPixelWidth", "chatPixelHeight", "chromaEnabled", "invertChroma", "reverseScrolling", "chromaLeft", "chromaTop", "chromaRight", "chromaBottom", "chromaCornerRadius", "chatAlwaysOnTop", "chatAntialias"};
    public static final String KEY_COLOR_BG = "colorBackground";
    public static final String KEY_COLOR_FG = "colorForeground";
    public static final String KEY_COLOR_BORDER = "colorBorder";
    public static final String KEY_COLOR_HIGHLIGHT = "colorHighlight";
    public static final String KEY_COLOR_CHROMA_KEY = "chromaKey";
    public static final String KEY_COLOR_PALETTE = "colorPalette";
    public static final String KEY_COLOR_USERNAME = "colorUsername";
    public static final String KEY_COLOR_TIMESTAMP = "colorTimestamp";
    public static final String KEY_COLOR_MESSAGE = "colorMessage";
    public static final String KEY_COLOR_JOIN = "colorJoin";
    public static final String KEY_COLOR_TWITCH = "colorUseTwitch";
    public static final String[] COLOR_KEYS = new String[]{"colorBackground", "colorForeground", "colorBorder", "colorHighlight", "chromaKey", "colorPalette", "colorUsername", "colorTimestamp", "colorMessage", "colorJoin", "colorUseTwitch"};
    public static final String[] COLOR_KEYS_WITHOUT_PALETTE = new String[]{"colorBackground", "colorForeground", "colorBorder", "colorHighlight", "chromaKey", "colorUsername", "colorTimestamp", "colorMessage", "colorJoin", "colorUseTwitch"};
    public static final String KEY_MESSAGE_JOIN = "messageShowJoin";
    public static final String KEY_MESSAGE_USERNAME = "messageShowUsername";
    public static final String KEY_MESSAGE_TIMESTAMP = "messageShowTimestamp";
    public static final String KEY_MESSAGE_USERFORMAT = "messageUsernameFormat";
    public static final String KEY_MESSAGE_TIMEFORMAT = "messageTimestampFormat";
    public static final String KEY_MESSAGE_CONTENT_BREAK = "messageContentBreak";
    public static final String KEY_MESSAGE_QUEUE_SIZE = "messageQueueSize";
    public static final String KEY_MESSAGE_SPEED = "messageSpeed";
    public static final String KEY_MESSAGE_EXPIRATION_TIME = "messageExpirationTime";
    public static final String KEY_MESSAGE_HIDE_EMPTY_BORDER = "messageHideEmptyBorder";
    public static final String KEY_MESSAGE_HIDE_EMPTY_BACKGROUND = "messageHideEmptyBackground";
    public static final String KEY_MESSAGE_CASE_TYPE = "messageUserCase";
    public static final String KEY_MESSAGE_CASE_SPECIFY = "messageUserCaseSpecify";
    public static final String KEY_MESSAGE_CASING = "messageCasing";
    public static final String[] MESSAGE_KEYS = new String[]{"messageShowJoin", "messageShowUsername", "messageShowTimestamp", "messageUsernameFormat", "messageTimestampFormat", "messageContentBreak", "messageQueueSize", "messageSpeed", "messageExpirationTime", "messageHideEmptyBorder", "messageHideEmptyBackground", "messageUserCase", "messageUserCaseSpecify", "messageCasing"};
    public static final String KEY_EMOJI_ENABLED = "emojiEnabled";
    public static final String KEY_EMOJI_ANIMATION = "emojiAnimationEnabled";
    public static final String KEY_EMOJI_TWITCH_BADGES = "badgesEnabled";
    public static final String KEY_EMOJI_FFZ_BADGES = "badgesFfzEnabled";
    public static final String KEY_EMOJI_SCALE_TO_LINE = "emojiScaleToLine";
    public static final String KEY_EMOJI_BADGE_SCALE_TO_LINE = "badgeScaleToLine";
    public static final String KEY_EMOJI_BADGE_HEIGHT_OFFSET = "badgeHeightOffset";
    public static final String KEY_EMOJI_SCALE = "emojiScale";
    public static final String KEY_EMOJI_BADGE_SCALE = "badgeScale";
    public static final String KEY_EMOJI_DISPLAY_STRAT = "emojiDisplayStrat";
    public static final String KEY_EMOJI_TWITCH_ENABLE = "emojiTwitchEnabled";
    public static final String KEY_EMOJI_TWITCH_CACHE = "emojiTwitchCached";
    public static final String KEY_EMOJI_FFZ_ENABLE = "emojiFfzEnabled";
    public static final String KEY_EMOJI_FFZ_CACHE = "emojiFfzCached";
    public static final String KEY_EMOJI_BTTV_ENABLE = "emojiBttvEnabled";
    public static final String KEY_EMOJI_BTTV_CACHE = "emojiBttvCached";
    public static final String KEY_EMOJI_TWITTER_ENABLE = "emojiTwitterEnabled";
    public static final String[] EMOJI_KEYS = new String[]{"emojiEnabled", "emojiAnimationEnabled", "badgesEnabled", "badgesFfzEnabled", "emojiScaleToLine", "badgeScaleToLine", "badgeHeightOffset", "emojiScale", "badgeScale", "emojiDisplayStrat", "emojiTwitchEnabled", "emojiTwitchCached", "emojiFfzEnabled", "emojiFfzCached", "emojiBttvEnabled", "emojiBttvCached", "emojiTwitterEnabled"};
    public static final String KEY_CENSOR_ENABLED = "censorEnabled";
    public static final String KEY_CENSOR_PURGE_ON_TWITCH_BAN = "censorPurgeOnTwitchBan";
    public static final String KEY_CENSOR_URL = "censorUrl";
    public static final String KEY_CENSOR_FIRST_URL = "censorFirstUrl";
    public static final String KEY_CENSOR_UNKNOWN_CHARS = "censorUnknownChars";
    public static final String KEY_CENSOR_UNKNOWN_CHARS_PERCENT = "censorUnknownCharsPercent";
    public static final String KEY_CENSOR_WHITE = "censorWhitelist";
    public static final String KEY_CENSOR_BLACK = "censorBlacklist";
    public static final String KEY_CENSOR_BANNED = "censorBannedWords";
    public static final String[] CENSOR_KEYS = new String[]{"censorEnabled", "censorPurgeOnTwitchBan", "censorUrl", "censorFirstUrl", "censorUnknownChars", "censorUnknownCharsPercent", "censorWhitelist", "censorBlacklist", "censorBannedWords"};
    public static final String[][] ALL_KEYS_EXCEPT_CHAT_WINDOW_POSITION = new String[][]{IRC_KEYS, FONT_KEYS, CHAT_KEYS_EXCEPT_WINDOW_POSITION, COLOR_KEYS, MESSAGE_KEYS, EMOJI_KEYS, CENSOR_KEYS};
    public static final String[][] ALL_KEYS = new String[][]{IRC_KEYS, FONT_KEYS, CHAT_KEYS, COLOR_KEYS, MESSAGE_KEYS, EMOJI_KEYS, CENSOR_KEYS};
    private ConfigIrc ircConfig = new ConfigIrc();
    private ConfigFont fontConfig = new ConfigFont();
    private ConfigChat chatConfig = new ConfigChat();
    private ConfigColor colorConfig = new ConfigColor();
    private ConfigMessage messageConfig = new ConfigMessage();
    private ConfigEmoji emojiConfig = new ConfigEmoji();
    private ConfigCensor censorConfig = new ConfigCensor();

    private static String[][] getKeysForEqualsTest(FontificatorProperties fProps) {
        if (fProps != null && fProps.getChatConfig() != null && fProps.getChatConfig().isRememberPosition()) {
            return ALL_KEYS_EXCEPT_CHAT_WINDOW_POSITION;
        }
        return ALL_KEYS;
    }

    @Override
    public void clear() {
        this.ircConfig.reset();
        this.fontConfig.reset();
        this.chatConfig.reset();
        this.colorConfig.reset();
        this.messageConfig.reset();
        this.emojiConfig.reset();
        this.censorConfig.reset();
        super.clear();
    }

    public ConfigIrc getIrcConfig() {
        return this.ircConfig;
    }

    public ConfigFont getFontConfig() {
        return this.fontConfig;
    }

    public ConfigChat getChatConfig() {
        return this.chatConfig;
    }

    public ConfigColor getColorConfig() {
        return this.colorConfig;
    }

    public ConfigMessage getMessageConfig() {
        return this.messageConfig;
    }

    public ConfigEmoji getEmojiConfig() {
        return this.emojiConfig;
    }

    public ConfigCensor getCensorConfig() {
        return this.censorConfig;
    }

    public boolean checkForUnsavedProps(ControlWindow ctrlWindow, Component parent) {
        if (this.hasUnsavedChanges()) {
            int response = JOptionPane.showConfirmDialog(parent, "Save configuration changes?", "Unsaved Changes", 1, 3);
            return response == 0 ? ctrlWindow.saveConfig() : response == 1;
        }
        return true;
    }

    public LoadConfigReport loadFile(String filename) throws Exception {
        if (filename.startsWith("preset://")) {
            String plainFilename = filename.substring("preset://".length());
            if (this.getClass().getClassLoader().getResource(plainFilename) == null) {
                LoadConfigReport report = new LoadConfigReport();
                String errorMsg = "Preset theme " + plainFilename + " not found";
                ChatWindow.popup.handleProblem(errorMsg);
                report.addError(errorMsg, LoadConfigErrorType.FILE_NOT_FOUND);
                return report;
            }
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(plainFilename);
            LoadConfigReport report = this.loadFile(is, filename, true);
            if (report.isErrorFree()) {
                this.lastSavedCopy = this.getCopy();
            }
            is.close();
            return report;
        }
        return this.loadFile(new File(filename));
    }

    public LoadConfigReport loadFile(File file) throws Exception {
        String absFilename = file.getAbsolutePath();
        logger.trace("Loading file " + absFilename);
        String lastDirectory = this.getLastDirectory(absFilename);
        FileInputStream is = new FileInputStream(file);
        LoadConfigReport report = this.loadFile(is, absFilename, false);
        report.setDirectory(lastDirectory);
        ((InputStream)is).close();
        return report;
    }

    private String getLastDirectory(String absFilename) {
        int slashIdx;
        String lastDirectory = null;
        if (absFilename != null && (slashIdx = absFilename.lastIndexOf(47)) >= 0) {
            lastDirectory = absFilename.substring(0, slashIdx);
        }
        return lastDirectory;
    }

    private LoadConfigReport loadFile(InputStream is, String filename, boolean isPreset) throws Exception {
        LoadConfigReport report;
        String prevAuth = this.getProperty(KEY_IRC_AUTH);
        super.load(is);
        String currAuth = this.getProperty(KEY_IRC_AUTH);
        if (prevAuth == null || !prevAuth.equals(currAuth)) {
            this.decryptProperty(KEY_IRC_AUTH);
        }
        if ((report = this.loadConfigs(!isPreset)).isErrorFree() && !isPreset) {
            this.rememberLastConfigFile(filename);
        }
        return report;
    }

    public void rememberLastConfigFile(String path) {
        block12: {
            logger.trace("Remembering last loaded file " + path);
            this.lastSavedCopy = this.getCopy();
            BufferedWriter writer = null;
            try {
                try {
                    writer = new BufferedWriter(new FileWriter(CONFIG_FILE_LAST_LOCATION, false));
                    writer.write(path);
                }
                catch (Exception e) {
                    logger.error("Unable to save last file loaded", e);
                    if (writer == null) break block12;
                    try {
                        writer.close();
                    }
                    catch (Exception e2) {
                        logger.error(e2.toString(), e2);
                    }
                }
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Exception e) {
                        logger.error(e.toString(), e);
                    }
                }
            }
        }
    }

    public void forgetLastConfigFile() {
        logger.trace("Forgetting last loaded");
        File f = new File(CONFIG_FILE_LAST_LOCATION);
        f.delete();
    }

    public void saveFile(File file) throws Exception {
        FileOutputStream os = new FileOutputStream(file);
        this.encryptProperty(KEY_IRC_AUTH);
        super.store(os, null);
        this.decryptProperty(KEY_IRC_AUTH);
        this.rememberLastConfigFile(file.getAbsolutePath());
    }

    public void encryptProperty(String key) {
        BasicTextEncryptor textEncryptor = new BasicTextEncryptor();
        textEncryptor.setPassword(ENC_PASSWORD);
        String decryptedValue = this.getProperty(key);
        if (decryptedValue != null && !decryptedValue.isEmpty()) {
            try {
                String encryptedValue = textEncryptor.encrypt(decryptedValue);
                this.setProperty(key, encryptedValue);
            }
            catch (Exception e) {
                String errorMessage = "Error encrypting value for " + key + " property";
                logger.error(errorMessage, e);
                ChatWindow.popup.handleProblem(errorMessage);
                this.setProperty(key, "");
            }
        }
    }

    public void decryptProperty(String key) {
        BasicTextEncryptor textEncryptor = new BasicTextEncryptor();
        textEncryptor.setPassword(ENC_PASSWORD);
        String encryptedValue = this.getProperty(key);
        if (encryptedValue != null && !encryptedValue.isEmpty()) {
            try {
                String decryptedValue = textEncryptor.decrypt(encryptedValue);
                this.setProperty(key, decryptedValue);
            }
            catch (Exception e) {
                String errorMessage = "Error decrypting value for " + key + " property";
                logger.error(errorMessage, e);
                ChatWindow.popup.handleProblem(errorMessage);
                this.setProperty(key, "");
            }
        }
    }

    public LoadConfigReport loadLast() throws Exception {
        logger.trace("Load last");
        String previousConfigNotFound = "Previous configuration not found.";
        String previousConfigError = "Error loading previous configuration.";
        BufferedReader reader = null;
        try {
            File lastFile = new File(CONFIG_FILE_LAST_LOCATION);
            if (!lastFile.exists()) {
                LoadConfigReport errorReport = new LoadConfigReport();
                errorReport.addError("Previous configuration not found.", LoadConfigErrorType.FILE_NOT_FOUND);
                LoadConfigReport loadConfigReport = errorReport;
                return loadConfigReport;
            }
            reader = new BufferedReader(new FileReader(lastFile));
            String lastConfigFilename = reader.readLine();
            reader.close();
            LoadConfigReport report = this.loadFile(lastConfigFilename);
            if (report.isProblem()) {
                report.setMainMessage("Error loading previous configuration.");
            }
            LoadConfigReport loadConfigReport = report;
            return loadConfigReport;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    logger.error(e.toString(), e);
                }
            }
        }
    }

    private void setPropertyOverride(String key, String value, boolean override) {
        boolean valueExists;
        boolean bl = valueExists = this.getProperty(key) != null && !this.getProperty(key).isEmpty();
        if (override || !valueExists) {
            this.setProperty(key, value);
        }
    }

    public void loadDefaultValues(boolean override) {
        logger.trace("Loading default values");
        String trueString = Boolean.toString(true);
        String falseString = Boolean.toString(false);
        this.setPropertyOverride(KEY_IRC_HOST, "irc.twitch.tv", override);
        this.setPropertyOverride(KEY_IRC_PORT, Integer.toString(6667), override);
        this.setPropertyOverride(KEY_IRC_ANON, trueString, override);
        this.setPropertyOverride(KEY_IRC_AUTO_RECONNECT, trueString, override);
        this.setPropertyOverride(KEY_FONT_FILE_BORDER, "preset://borders/dw3_border.png", override);
        this.setPropertyOverride(KEY_FONT_FILE_FONT, "preset://fonts/dw3_font.png", override);
        this.setPropertyOverride(KEY_FONT_TYPE, FontType.FIXED_WIDTH.name(), override);
        this.setPropertyOverride(KEY_FONT_GRID_WIDTH, Integer.toString(8), override);
        this.setPropertyOverride(KEY_FONT_GRID_HEIGHT, Integer.toString(12), override);
        this.setPropertyOverride(KEY_FONT_SCALE, Integer.toString(2), override);
        this.setPropertyOverride(KEY_FONT_BORDER_SCALE, Integer.toString(3), override);
        this.setPropertyOverride(KEY_FONT_BORDER_INSET_X, Integer.toString(1), override);
        this.setPropertyOverride(KEY_FONT_BORDER_INSET_Y, Integer.toString(1), override);
        this.setPropertyOverride(KEY_FONT_SPACE_WIDTH, Integer.toString(25), override);
        this.setPropertyOverride(KEY_FONT_BASELINE_OFFSET, Integer.toString(0), override);
        this.setPropertyOverride(KEY_FONT_CHARACTERS, " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u007f", override);
        this.setPropertyOverride(KEY_FONT_UNKNOWN_CHAR, Character.toString('\u007f'), override);
        this.setPropertyOverride(KEY_FONT_EXTENDED_CHAR, trueString, override);
        this.setPropertyOverride(KEY_FONT_SPACING_LINE, Integer.toString(2), override);
        this.setPropertyOverride(KEY_FONT_SPACING_CHAR, Integer.toString(0), override);
        this.setPropertyOverride(KEY_FONT_SPACING_MESSAGE, Integer.toString(0), override);
        this.setPropertyOverride(KEY_CHAT_SCROLL, falseString, override);
        this.setPropertyOverride(KEY_CHAT_RESIZABLE, trueString, override);
        this.setPropertyOverride(KEY_CHAT_POSITION, falseString, override);
        this.setPropertyOverride(KEY_CHAT_POSITION_X, Integer.toString(0), override);
        this.setPropertyOverride(KEY_CHAT_POSITION_Y, Integer.toString(0), override);
        this.setPropertyOverride(KEY_CHAT_FROM_BOTTOM, falseString, override);
        this.setPropertyOverride(KEY_CHAT_WIDTH, Integer.toString(550), override);
        this.setPropertyOverride(KEY_CHAT_HEIGHT, Integer.toString(450), override);
        this.setPropertyOverride(KEY_CHAT_CHROMA_ENABLED, falseString, override);
        this.setPropertyOverride(KEY_CHAT_INVERT_CHROMA, falseString, override);
        this.setPropertyOverride(KEY_CHAT_REVERSE_SCROLLING, falseString, override);
        this.setPropertyOverride(KEY_CHAT_CHROMA_LEFT, Integer.toString(10), override);
        this.setPropertyOverride(KEY_CHAT_CHROMA_TOP, Integer.toString(10), override);
        this.setPropertyOverride(KEY_CHAT_CHROMA_RIGHT, Integer.toString(10), override);
        this.setPropertyOverride(KEY_CHAT_CHROMA_BOTTOM, Integer.toString(10), override);
        this.setPropertyOverride(KEY_CHAT_CHROMA_CORNER, Integer.toString(10), override);
        this.setPropertyOverride(KEY_CHAT_ALWAYS_ON_TOP, falseString, override);
        this.setPropertyOverride(KEY_CHAT_ANTIALIAS, falseString, override);
        this.setPropertyOverride(KEY_COLOR_BG, "000000", override);
        this.setPropertyOverride(KEY_COLOR_FG, "FFFFFF", override);
        this.setPropertyOverride(KEY_COLOR_BORDER, "FFFFFF", override);
        this.setPropertyOverride(KEY_COLOR_HIGHLIGHT, "6699FF", override);
        this.setPropertyOverride(KEY_COLOR_PALETTE, "F7977A,FDC68A,FFF79A,A2D39C,6ECFF6,A187BE,F6989D", override);
        this.setPropertyOverride(KEY_COLOR_CHROMA_KEY, "00FF00", override);
        this.setPropertyOverride(KEY_COLOR_USERNAME, trueString, override);
        this.setPropertyOverride(KEY_COLOR_TIMESTAMP, falseString, override);
        this.setPropertyOverride(KEY_COLOR_MESSAGE, falseString, override);
        this.setPropertyOverride(KEY_COLOR_JOIN, falseString, override);
        this.setPropertyOverride(KEY_COLOR_TWITCH, falseString, override);
        this.setPropertyOverride(KEY_MESSAGE_JOIN, falseString, override);
        this.setPropertyOverride(KEY_MESSAGE_USERNAME, trueString, override);
        this.setPropertyOverride(KEY_MESSAGE_TIMESTAMP, falseString, override);
        this.setPropertyOverride(KEY_MESSAGE_USERFORMAT, "%user%", override);
        this.setPropertyOverride(KEY_MESSAGE_TIMEFORMAT, "[HH:mm:ss]", override);
        this.setPropertyOverride(KEY_MESSAGE_CONTENT_BREAK, ": ", override);
        this.setPropertyOverride(KEY_MESSAGE_QUEUE_SIZE, Integer.toString(64), override);
        this.setPropertyOverride(KEY_MESSAGE_SPEED, Integer.toString(30), override);
        this.setPropertyOverride(KEY_MESSAGE_EXPIRATION_TIME, Integer.toString(0), override);
        this.setPropertyOverride(KEY_MESSAGE_HIDE_EMPTY_BORDER, falseString, override);
        this.setPropertyOverride(KEY_MESSAGE_HIDE_EMPTY_BACKGROUND, falseString, override);
        this.setPropertyOverride(KEY_MESSAGE_CASE_TYPE, UsernameCaseResolutionType.NONE.name(), override);
        this.setPropertyOverride(KEY_MESSAGE_CASE_SPECIFY, falseString, override);
        this.setPropertyOverride(KEY_MESSAGE_CASING, MessageCasing.MIXED_CASE.name(), override);
        this.setPropertyOverride(KEY_EMOJI_ENABLED, trueString, override);
        this.setPropertyOverride(KEY_EMOJI_ANIMATION, falseString, override);
        this.setPropertyOverride(KEY_EMOJI_TWITCH_BADGES, trueString, override);
        this.setPropertyOverride(KEY_EMOJI_FFZ_BADGES, falseString, override);
        this.setPropertyOverride(KEY_EMOJI_SCALE_TO_LINE, trueString, override);
        this.setPropertyOverride(KEY_EMOJI_BADGE_SCALE_TO_LINE, falseString, override);
        this.setPropertyOverride(KEY_EMOJI_BADGE_HEIGHT_OFFSET, Integer.toString(0), override);
        this.setPropertyOverride(KEY_EMOJI_SCALE, Integer.toString(100), override);
        this.setPropertyOverride(KEY_EMOJI_BADGE_SCALE, Integer.toString(100), override);
        this.setPropertyOverride(KEY_EMOJI_DISPLAY_STRAT, EmojiLoadingDisplayStragegy.SPACE.name(), override);
        this.setPropertyOverride(KEY_EMOJI_TWITCH_ENABLE, trueString, override);
        this.setPropertyOverride(KEY_EMOJI_TWITCH_CACHE, falseString, override);
        this.setPropertyOverride(KEY_EMOJI_FFZ_ENABLE, falseString, override);
        this.setPropertyOverride(KEY_EMOJI_FFZ_CACHE, falseString, override);
        this.setPropertyOverride(KEY_EMOJI_BTTV_ENABLE, falseString, override);
        this.setPropertyOverride(KEY_EMOJI_BTTV_CACHE, falseString, override);
        this.setPropertyOverride(KEY_EMOJI_TWITTER_ENABLE, trueString, override);
        this.setPropertyOverride(KEY_CENSOR_ENABLED, trueString, override);
        this.setPropertyOverride(KEY_CENSOR_PURGE_ON_TWITCH_BAN, trueString, override);
        this.setPropertyOverride(KEY_CENSOR_URL, falseString, override);
        this.setPropertyOverride(KEY_CENSOR_FIRST_URL, falseString, override);
        this.setPropertyOverride(KEY_CENSOR_UNKNOWN_CHARS, falseString, override);
        this.setPropertyOverride(KEY_CENSOR_UNKNOWN_CHARS_PERCENT, Integer.toString(20), override);
        this.setPropertyOverride(KEY_CENSOR_WHITE, "", override);
        this.setPropertyOverride(KEY_CENSOR_BLACK, "", override);
        this.setPropertyOverride(KEY_CENSOR_BANNED, "", override);
        this.loadConfigs(true);
    }

    private FontificatorProperties getCopy() {
        FontificatorProperties copy = new FontificatorProperties();
        for (String key : this.stringPropertyNames()) {
            copy.setProperty(key, this.getProperty(key));
        }
        return copy;
    }

    private LoadConfigReport loadConfigs(boolean loadNonFontConfig) {
        LoadConfigReport report = new LoadConfigReport();
        if (loadNonFontConfig) {
            this.ircConfig.load(this, report);
            this.chatConfig.load(this, report);
            this.messageConfig.load(this, report);
            this.emojiConfig.load(this, report);
            this.censorConfig.load(this, report);
        }
        this.fontConfig.load(this, report);
        this.colorConfig.load(this, report);
        if (!report.isErrorFree()) {
            if (report.isOnlyMissingKeys()) {
                report.setMainMessage("<center>Please resave the configuration file<br />to fix these issues:</center>");
            }
            ChatWindow.popup.handleProblem(report);
        }
        return report;
    }

    private boolean hasUnsavedChanges() {
        return this.lastSavedCopy != null && !this.equals(this.lastSavedCopy);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.chatConfig == null ? 0 : this.chatConfig.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FontificatorProperties otherFp = (FontificatorProperties)obj;
        return FontificatorProperties.propertyBatchMatch(FontificatorProperties.getKeysForEqualsTest(this), this, otherFp);
    }

    private static boolean propertyBatchMatch(String[][] keys, FontificatorProperties a, FontificatorProperties b) {
        int i = 0;
        while (i < keys.length) {
            int j = 0;
            while (j < keys[i].length) {
                if (!FontificatorProperties.propertyEquals(a.getProperty(keys[i][j]), b.getProperty(keys[i][j]))) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    private static boolean propertyEquals(String one, String two) {
        if (one == null) {
            return two == null;
        }
        return one.equals(two);
    }
}

