/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.config;

import com.glitchcog.fontificator.config.Config;
import com.glitchcog.fontificator.config.FontificatorProperties;
import com.glitchcog.fontificator.config.MessageCasing;
import com.glitchcog.fontificator.config.UsernameCaseResolutionType;
import com.glitchcog.fontificator.config.loadreport.LoadConfigErrorType;
import com.glitchcog.fontificator.config.loadreport.LoadConfigReport;
import com.glitchcog.fontificator.gui.chat.clock.MessageExpirer;
import com.glitchcog.fontificator.gui.chat.clock.MessageProgressor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public class ConfigMessage
extends Config {
    public static final long SHORTEST_DELAY = 67L;
    public static final int MIN_QUEUE_SIZE = 1;
    public static final int MAX_QUEUE_SIZE = 5000;
    public static final int MIN_MESSAGE_SPEED = 1;
    public static final int MAX_MESSAGE_SPEED = 121;
    public static final int MIN_MESSAGE_EXPIRATION = 0;
    public static final int MAX_MESSAGE_EXPIRATION = 720;
    public static final String USERNAME_REPLACE = "%user%";
    public static final String DEFAULT_CONTENT_BREAKER = ": ";
    private static final long MIN_MESSAGE_DELAY = 1L;
    private Boolean joinMessages;
    private Boolean usernames;
    private Boolean timestamps;
    private String usernameFormat;
    private String timeFormat;
    private String contentBreaker;
    private DateFormat timeFormatter;
    private Integer queueSize;
    private Integer messageSpeed;
    private Integer expirationTime;
    private Boolean hideEmptyBorder;
    private Boolean hideEmptyBackground;
    private UsernameCaseResolutionType caseResolutionType;
    private Boolean specifyCaseAllowed;
    private MessageCasing messageCasing;

    @Override
    public void reset() {
        this.joinMessages = null;
        this.usernames = null;
        this.timestamps = null;
        this.usernameFormat = null;
        this.timeFormat = null;
        this.contentBreaker = null;
        this.queueSize = null;
        this.messageSpeed = null;
        this.expirationTime = null;
        this.hideEmptyBorder = null;
        this.hideEmptyBackground = null;
        this.caseResolutionType = null;
        this.specifyCaseAllowed = null;
        this.messageCasing = null;
    }

    public LoadConfigReport validateTimeFormat(LoadConfigReport report, String timeFormatStr) {
        try {
            SimpleDateFormat df = new SimpleDateFormat(timeFormatStr);
            df.format(new Date());
        }
        catch (Exception e) {
            report.addError("The value \"" + timeFormatStr + "\" of key " + "messageTimestampFormat" + " could not be used to parse a date", LoadConfigErrorType.PARSE_ERROR_STRING);
        }
        return report;
    }

    public LoadConfigReport validateStrings(LoadConfigReport report, String timeFormatStr, String queueSizeStr, String messageSpeedStr, String expirationTimeStr) {
        this.validateTimeFormat(report, timeFormatStr);
        this.validateIntegerWithLimitString("messageQueueSize", queueSizeStr, 1, 5000, report);
        this.validateIntegerWithLimitString("messageSpeed", messageSpeedStr, 1, 121, report);
        this.validateIntegerWithLimitString("messageExpirationTime", expirationTimeStr, 0, 720, report);
        return report;
    }

    public LoadConfigReport validateStrings(LoadConfigReport report, String userFormatStr, String timeFormatStr, String contentBreakStr, String queueSizeStr, String messageSpeedStr, String expirationTimerStr, String hideEmptyBorderBool, String hideEmptyBgBool, String caseTypeStr, String joinBool, String userBool, String timestampBool, String specifyCaseBool, String msgCasingStr) {
        this.validateStrings(report, timeFormatStr, queueSizeStr, messageSpeedStr, expirationTimerStr);
        this.validateBooleanStrings(report, joinBool, userBool, timestampBool, specifyCaseBool, hideEmptyBorderBool, hideEmptyBgBool);
        if (!UsernameCaseResolutionType.contains(caseTypeStr)) {
            report.addError("Value of key \"messageUserCase\" is invalid.", LoadConfigErrorType.PARSE_ERROR_ENUM);
        }
        if (!MessageCasing.contains(msgCasingStr)) {
            report.addError("Value of key \"messageCasing\" is invalid.", LoadConfigErrorType.PARSE_ERROR_ENUM);
        }
        return report;
    }

    @Override
    public LoadConfigReport load(Properties props, LoadConfigReport report) {
        this.props = props;
        this.reset();
        this.baseValidation(props, FontificatorProperties.MESSAGE_KEYS, report);
        if (report.isErrorFree()) {
            String tfString = props.getProperty("messageTimestampFormat");
            String usrString = props.getProperty("messageUsernameFormat");
            String cbString = props.getProperty("messageContentBreak");
            String quSizeStr = props.getProperty("messageQueueSize");
            String msgSpeedStr = props.getProperty("messageSpeed");
            String caseTpStr = props.getProperty("messageUserCase");
            String joinBool = props.getProperty("messageShowJoin");
            String userBool = props.getProperty("messageShowUsername");
            String timestampBool = props.getProperty("messageShowTimestamp");
            String specifyCaseBool = props.getProperty("messageUserCaseSpecify");
            String msgCaseStr = props.getProperty("messageCasing");
            String expTimerStr = props.getProperty("messageExpirationTime");
            String hideEmptyBorderStr = props.getProperty("messageHideEmptyBorder");
            String hideEmptyBgStr = props.getProperty("messageHideEmptyBackground");
            this.validateStrings(report, usrString, tfString, cbString, quSizeStr, msgSpeedStr, expTimerStr, hideEmptyBorderStr, hideEmptyBgStr, caseTpStr, joinBool, userBool, timestampBool, specifyCaseBool, msgCaseStr);
            if (report.isErrorFree()) {
                this.joinMessages = this.evaluateBooleanString(props, "messageShowJoin", report);
                this.usernames = this.evaluateBooleanString(props, "messageShowUsername", report);
                this.timestamps = this.evaluateBooleanString(props, "messageShowTimestamp", report);
                this.usernameFormat = usrString;
                this.timeFormat = tfString;
                this.contentBreaker = cbString;
                this.queueSize = this.evaluateIntegerString(props, "messageQueueSize", report);
                this.messageSpeed = this.evaluateIntegerString(props, "messageSpeed", report);
                this.expirationTime = this.evaluateIntegerString(props, "messageExpirationTime", report);
                this.hideEmptyBorder = this.evaluateBooleanString(props, "messageHideEmptyBorder", report);
                this.hideEmptyBackground = this.evaluateBooleanString(props, "messageHideEmptyBackground", report);
                this.caseResolutionType = UsernameCaseResolutionType.valueOf(caseTpStr);
                this.specifyCaseAllowed = this.evaluateBooleanString(props, "messageUserCaseSpecify", report);
                this.messageCasing = MessageCasing.valueOf(msgCaseStr);
            }
        }
        return report;
    }

    public boolean showJoinMessages() {
        return this.joinMessages;
    }

    public void setJoinMessages(boolean joinMessages) {
        this.joinMessages = joinMessages;
        this.props.setProperty("messageShowJoin", Boolean.toString(joinMessages));
    }

    public boolean showUsernames() {
        return this.usernames;
    }

    public void setShowUsernames(boolean usernames) {
        this.usernames = usernames;
        this.props.setProperty("messageShowUsername", Boolean.toString(usernames));
    }

    public boolean showTimestamps() {
        return this.timestamps;
    }

    public void setShowTimestamps(boolean timestamps) {
        this.timestamps = timestamps;
        this.props.setProperty("messageShowTimestamp", Boolean.toString(timestamps));
    }

    public String getUsernameFormat() {
        return this.usernameFormat;
    }

    public void setUsernameFormat(String usernameFormat) {
        this.usernameFormat = usernameFormat;
        this.props.setProperty("messageUsernameFormat", usernameFormat);
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    public DateFormat getTimerFormatter() {
        return this.timeFormatter;
    }

    public void setTimeFormat(String timeFormat) {
        this.timeFormat = timeFormat;
        this.timeFormatter = new SimpleDateFormat(timeFormat);
        this.props.setProperty("messageTimestampFormat", timeFormat);
    }

    public String getContentBreaker() {
        return this.contentBreaker;
    }

    public void setContentBreaker(String contentBreaker) {
        this.contentBreaker = contentBreaker;
        this.props.setProperty("messageContentBreak", contentBreaker);
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
        this.props.setProperty("messageQueueSize", Integer.toString(queueSize));
    }

    public int getMessageSpeed() {
        return this.messageSpeed == null ? 0 : this.messageSpeed;
    }

    public long getMessageDelay() {
        return this.messageSpeed <= 0 || this.messageSpeed >= 121 ? 1L : 1000L / (long)this.messageSpeed.intValue();
    }

    public void setMessageSpeed(int messageSpeed, MessageProgressor progressor) {
        this.messageSpeed = messageSpeed;
        this.props.setProperty("messageSpeed", Integer.toString(messageSpeed));
        if (progressor != null) {
            progressor.refreshTimer(this.getMessageDelay());
        }
    }

    public Integer getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(Integer expirationTime, MessageExpirer expirer) {
        this.expirationTime = expirationTime;
        this.props.setProperty("messageExpirationTime", Integer.toString(expirationTime));
        if (expirer != null) {
            if (expirationTime == 0) {
                expirer.cancelLatest();
            } else {
                expirer.startClock();
            }
        }
    }

    public boolean isMessageExpirable() {
        return this.expirationTime != null && this.expirationTime != 0;
    }

    public boolean isHideEmptyBorder() {
        return this.hideEmptyBorder;
    }

    public void setHideEmptyBorder(boolean hideEmptyBorder) {
        this.hideEmptyBorder = hideEmptyBorder;
        this.props.setProperty("messageHideEmptyBorder", Boolean.toString(hideEmptyBorder));
    }

    public boolean isHideEmptyBackground() {
        return this.hideEmptyBackground;
    }

    public void setHideEmptyBackground(boolean hideEmptyBackground) {
        this.hideEmptyBackground = hideEmptyBackground;
        this.props.setProperty("messageHideEmptyBackground", Boolean.toString(hideEmptyBackground));
    }

    public UsernameCaseResolutionType getCaseResolutionType() {
        return this.caseResolutionType;
    }

    public void setCaseResolutionType(UsernameCaseResolutionType caseResolutionType) {
        this.caseResolutionType = caseResolutionType;
        this.props.setProperty("messageUserCase", caseResolutionType.name());
    }

    public Boolean isSpecifyCaseAllowed() {
        return this.specifyCaseAllowed;
    }

    public void setSpecifyCaseAllowed(Boolean specifyCaseAllowed) {
        this.specifyCaseAllowed = specifyCaseAllowed;
        this.props.setProperty("messageUserCaseSpecify", Boolean.toString(specifyCaseAllowed));
    }

    public MessageCasing getMessageCasing() {
        return this.messageCasing;
    }

    public void setMessageCasing(MessageCasing messageCasing) {
        this.messageCasing = messageCasing;
        this.props.setProperty("messageCasing", messageCasing.name());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.joinMessages == null ? 0 : this.joinMessages.hashCode());
        result = 31 * result + (this.usernameFormat == null ? 0 : this.usernameFormat.hashCode());
        result = 31 * result + (this.timeFormat == null ? 0 : this.timeFormat.hashCode());
        result = 31 * result + (this.contentBreaker == null ? 0 : this.contentBreaker.hashCode());
        result = 31 * result + (this.timestamps == null ? 0 : this.timestamps.hashCode());
        result = 31 * result + (this.usernames == null ? 0 : this.usernames.hashCode());
        result = 31 * result + (this.messageCasing == null ? 0 : this.messageCasing.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigMessage other = (ConfigMessage)obj;
        if (this.messageCasing != other.messageCasing) {
            return false;
        }
        if (this.joinMessages == null ? other.joinMessages != null : !this.joinMessages.equals(other.joinMessages)) {
            return false;
        }
        if (this.usernameFormat == null ? other.usernameFormat != null : !this.usernameFormat.equals(other.usernameFormat)) {
            return false;
        }
        if (this.timeFormat == null ? other.timeFormat != null : !this.timeFormat.equals(other.timeFormat)) {
            return false;
        }
        if (this.contentBreaker == null ? other.contentBreaker != null : !this.contentBreaker.equals(other.contentBreaker)) {
            return false;
        }
        if (this.timestamps == null ? other.timestamps != null : !this.timestamps.equals(other.timestamps)) {
            return false;
        }
        return !(this.usernames == null ? other.usernames != null : !this.usernames.equals(other.usernames));
    }

    public void deepCopy(ConfigMessage copy) {
        this.joinMessages = copy.joinMessages;
        this.usernameFormat = copy.usernameFormat;
        this.timeFormat = copy.timeFormat;
        this.contentBreaker = copy.contentBreaker;
        this.timestamps = copy.timestamps;
        this.usernames = copy.usernames;
        this.messageCasing = copy.messageCasing;
    }
}

