/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.config;

import com.glitchcog.fontificator.config.Config;
import com.glitchcog.fontificator.config.loadreport.LoadConfigReport;
import java.util.Properties;

public class ConfigIrc
extends Config {
    private String username;
    private String host;
    private String port;
    private String authorization;
    private String channel;
    private Boolean anonymous;
    private Boolean autoReconnect;

    @Override
    public void reset() {
        this.username = null;
        this.host = null;
        this.port = null;
        this.authorization = null;
        this.anonymous = null;
        this.channel = null;
        this.setAutoReconnect(null);
    }

    @Override
    public LoadConfigReport load(Properties props, LoadConfigReport report) {
        this.props = props;
        this.reset();
        String anonStr = props.getProperty("ircAnon");
        this.validateBooleanStrings(report, anonStr);
        if (report.isErrorFree()) {
            this.anonymous = this.evaluateBooleanString(props, "ircAnon", report);
        }
        String propUser = props.getProperty("ircUser");
        String propAuth = props.getProperty("ircAuth");
        String propChan = props.getProperty("ircChannel");
        String propHost = props.getProperty("ircHost");
        String propPort = props.getProperty("ircPort");
        if (propUser != null && !propUser.isEmpty()) {
            this.username = propUser;
        }
        if (propAuth != null && !propAuth.isEmpty()) {
            this.authorization = propAuth;
        }
        if (propChan != null && !propChan.isEmpty()) {
            this.channel = propChan;
        }
        if (propHost != null && !propHost.isEmpty()) {
            this.host = propHost;
        }
        if (propPort != null && !propPort.isEmpty()) {
            this.port = propPort;
        }
        this.setAutoReconnect(!Boolean.FALSE.toString().equalsIgnoreCase(props.getProperty("ircAutoReconnect")));
        return report;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
        this.props.setProperty("ircUser", username);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
        this.props.setProperty("ircHost", host);
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
        this.props.setProperty("ircPort", port);
    }

    public String getAuthorization() {
        return this.authorization;
    }

    public void setAuthorization(String authorization) {
        this.authorization = authorization;
        this.props.setProperty("ircAuth", authorization);
    }

    public String getChannel() {
        if (this.channel != null && !this.channel.startsWith("#")) {
            return "#" + this.channel;
        }
        return this.channel;
    }

    public String getChannelNoHash() {
        return this.getChannel() == null ? null : (this.getChannel().length() < 1 ? "" : this.getChannel().substring(1));
    }

    public void setChannel(String channel) {
        this.channel = channel;
        this.props.setProperty("ircChannel", channel);
    }

    public Boolean isAnonymous() {
        return this.anonymous;
    }

    public void setAnonymous(Boolean anonymous) {
        this.anonymous = anonymous;
        this.props.setProperty("ircAnon", Boolean.toString(anonymous));
    }

    public Boolean isAutoReconnect() {
        return this.autoReconnect;
    }

    public void setAutoReconnect(Boolean autoReconnect) {
        this.autoReconnect = autoReconnect;
        if (autoReconnect != null) {
            this.props.setProperty("ircAutoReconnect", Boolean.toString(autoReconnect));
        }
    }
}

