/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.config;

import com.glitchcog.fontificator.config.Config;
import com.glitchcog.fontificator.config.FontType;
import com.glitchcog.fontificator.config.FontificatorProperties;
import com.glitchcog.fontificator.config.loadreport.LoadConfigErrorType;
import com.glitchcog.fontificator.config.loadreport.LoadConfigReport;
import java.io.File;
import java.util.Properties;

public class ConfigFont
extends Config {
    public static final String INTERNAL_FILE_PREFIX = "preset://";
    public static final String INTERNAL_FONT_DIR = "fonts/";
    public static final String INTERNAL_BORDER_DIR = "borders/";
    public static final float FONT_BORDER_SCALE_GRANULARITY = 0.25f;
    public static final float MIN_FONT_SCALE = 0.25f;
    public static final int MAX_FONT_SCALE = 32;
    public static final int MIN_BORDER_SCALE = 0;
    public static final int MAX_BORDER_SCALE = 32;
    public static final int MIN_BORDER_INSET = -256;
    public static final int MAX_BORDER_INSET = 256;
    public static final int MIN_SPACE_WIDTH = 0;
    public static final int MAX_SPACE_WIDTH = 250;
    public static final int MIN_BASELINE_OFFSET = -32;
    public static final int MAX_BASELINE_OFFSET = 64;
    public static final int MIN_LINE_SPACING = -16;
    public static final int MAX_LINE_SPACING = 32;
    public static final int MIN_CHAR_SPACING = -16;
    public static final int MAX_CHAR_SPACING = 32;
    public static final int MIN_MESSAGE_SPACING = 0;
    public static final int MAX_MESSAGE_SPACING = 128;
    private String fontFilename;
    private String borderFilename;
    private int gridWidth;
    private int gridHeight;
    private float fontScale;
    private float borderScale;
    private int borderInsetX;
    private int borderInsetY;
    private int spaceWidth;
    private int baselineOffset;
    private String characterKey;
    private char unknownChar;
    private Boolean extendedCharEnabled;
    private int lineSpacing;
    private int charSpacing;
    private int messageSpacing;
    private FontType fontType;

    @Override
    public void reset() {
        this.fontFilename = null;
        this.borderFilename = null;
        this.fontType = null;
        this.spaceWidth = 0;
        this.baselineOffset = 0;
        this.gridWidth = 0;
        this.gridHeight = 0;
        this.fontScale = 1.0f;
        this.borderScale = 1.0f;
        this.borderInsetX = 0;
        this.borderInsetY = 0;
        this.characterKey = null;
        this.unknownChar = '\u0000';
        this.extendedCharEnabled = null;
        this.lineSpacing = 0;
        this.charSpacing = 0;
        this.messageSpacing = 0;
    }

    public void validateFontFile(LoadConfigReport report, String fontFilename) {
        if (fontFilename.startsWith(INTERNAL_FILE_PREFIX)) {
            String plainFilename = fontFilename.substring(INTERNAL_FILE_PREFIX.length());
            if (this.getClass().getClassLoader().getResource(plainFilename) == null) {
                report.addError("Preset font " + plainFilename + " not found", LoadConfigErrorType.FILE_NOT_FOUND);
            }
        } else if (!new File(fontFilename).exists()) {
            report.addError("Unable to find font PNG file \"" + fontFilename + "\"", LoadConfigErrorType.FILE_NOT_FOUND);
        }
    }

    public void validateBorderFile(LoadConfigReport report, String borderFilename) {
        if (borderFilename.startsWith(INTERNAL_FILE_PREFIX)) {
            String plainFilename = borderFilename.substring(INTERNAL_FILE_PREFIX.length());
            if (this.getClass().getClassLoader().getResource(plainFilename) == null) {
                report.addError("Preset border " + plainFilename + " not found", LoadConfigErrorType.FILE_NOT_FOUND);
            }
        } else if (!new File(borderFilename).exists()) {
            report.addError("Unable to find border PNG file \"" + borderFilename + "\"", LoadConfigErrorType.FILE_NOT_FOUND);
        }
    }

    public void validateStrings(LoadConfigReport report, String widthStr, String heightStr, String charKey, String unknownCharStr) {
        if (unknownCharStr.length() != 1) {
            report.addError("Unknown character value must be a single character", LoadConfigErrorType.PARSE_ERROR_CHAR);
        }
        this.validateIntegerWithLimitString("fontGridWidth", widthStr, 1, report);
        this.validateIntegerWithLimitString("fontGridHeight", heightStr, 1, report);
        if (report.isErrorFree()) {
            int w = Integer.parseInt(widthStr);
            int h = Integer.parseInt(heightStr);
            if (w > 0 && w > 0 && w * h != charKey.length()) {
                report.addError("Character key length (" + charKey.length() + ") must match the number of characters in the font image (" + w + " x " + h + " = " + w * h + ")", LoadConfigErrorType.VALUE_OUT_OF_RANGE);
            }
            if (!charKey.contains(unknownCharStr)) {
                report.addError("The value for fontUnknownChar (" + unknownCharStr + ") must also be in the value for " + "fontCharacters", LoadConfigErrorType.VALUE_OUT_OF_RANGE);
            }
        }
    }

    public void validateStrings(LoadConfigReport report, String fontFilenameStr, String borderFilenameStr, String widthStr, String heightStr, String charKey, String unknownCharStr, String extendedCharStr, String scaleStr, String borderScaleStr, String borderInsetXStr, String borderInsetYStr, String spaceWidthStr, String baselineStr, String lineStr, String charStr, String msgStr, String fontTypeStr) {
        this.validateStrings(report, widthStr, heightStr, charKey, unknownCharStr);
        if (fontFilenameStr.isEmpty()) {
            report.addError("A font filename is required", LoadConfigErrorType.MISSING_VALUE);
        }
        if (borderFilenameStr.isEmpty()) {
            report.addError("A border filename is required", LoadConfigErrorType.MISSING_VALUE);
        }
        this.validateBooleanStrings(report, extendedCharStr);
        this.validateFloatWithLimitString("fontScale", scaleStr, 0.25f, 32.0f, report);
        this.validateFloatWithLimitString("fontBorderScale", borderScaleStr, 0.0f, 32.0f, report);
        this.validateIntegerWithLimitString("fontBorderInsetX", borderInsetXStr, -256, 256, report);
        this.validateIntegerWithLimitString("fontBorderInsetY", borderInsetYStr, -256, 256, report);
        this.validateIntegerWithLimitString("fontSpaceWidth", spaceWidthStr, 0, 250, report);
        this.validateIntegerWithLimitString("fontBaselineOffset", baselineStr, -32, 64, report);
        this.validateIntegerWithLimitString("fontLineSpacing", lineStr, -16, 32, report);
        this.validateIntegerWithLimitString("fontCharSpacing", charStr, -16, 32, report);
        this.validateIntegerWithLimitString("fontMessageSpacing", msgStr, 0, 128, report);
        if (!FontType.contains(fontTypeStr)) {
            report.addError("Value of key \"fontType\" is invalid.", LoadConfigErrorType.PARSE_ERROR_ENUM);
        }
    }

    @Override
    public LoadConfigReport load(Properties props, LoadConfigReport report) {
        this.props = props;
        this.reset();
        this.baseValidation(props, FontificatorProperties.FONT_KEYS, report);
        if (report.isErrorFree()) {
            String gridWidthStr = props.getProperty("fontGridWidth");
            String gridHeightStr = props.getProperty("fontGridHeight");
            String scaleStr = props.getProperty("fontScale");
            String borderScaleStr = props.getProperty("fontBorderScale");
            String borderInsetXStr = props.getProperty("fontBorderInsetX");
            String borderInsetYStr = props.getProperty("fontBorderInsetY");
            String spaceWidthStr = props.getProperty("fontSpaceWidth");
            String baselineStr = props.getProperty("fontBaselineOffset");
            String unknownCharStr = props.getProperty("fontUnknownChar");
            String extendedCharStr = props.getProperty("fontExtendedChar");
            String lineSpacingStr = props.getProperty("fontLineSpacing");
            String charSpacingStr = props.getProperty("fontCharSpacing");
            String messageSpacingStr = props.getProperty("fontMessageSpacing");
            String fontTypeStr = props.getProperty("fontType");
            String charKeyStr = props.getProperty("fontCharacters");
            String borderFilenameStr = props.getProperty("fontBorderFile");
            String fontFilenameStr = props.getProperty("fontFile");
            this.validateStrings(report, fontFilenameStr, borderFilenameStr, gridWidthStr, gridHeightStr, charKeyStr, unknownCharStr, extendedCharStr, scaleStr, borderScaleStr, borderInsetXStr, borderInsetYStr, spaceWidthStr, baselineStr, lineSpacingStr, charSpacingStr, messageSpacingStr, fontTypeStr);
            if (report.isErrorFree()) {
                this.borderFilename = props.getProperty("fontBorderFile");
                this.fontFilename = props.getProperty("fontFile");
                this.fontType = FontType.valueOf(props.getProperty("fontType"));
                this.unknownChar = unknownCharStr.charAt(0);
                this.extendedCharEnabled = this.evaluateBooleanString(props, "fontExtendedChar", report);
                this.characterKey = props.getProperty("fontCharacters");
                this.gridWidth = Integer.parseInt(gridWidthStr);
                this.gridHeight = Integer.parseInt(gridHeightStr);
                this.fontScale = Float.parseFloat(scaleStr);
                this.borderScale = Float.parseFloat(borderScaleStr);
                this.borderInsetX = Integer.parseInt(borderInsetXStr);
                this.borderInsetY = Integer.parseInt(borderInsetYStr);
                this.spaceWidth = Integer.parseInt(spaceWidthStr);
                this.baselineOffset = Integer.parseInt(baselineStr);
                this.lineSpacing = Integer.parseInt(lineSpacingStr);
                this.charSpacing = Integer.parseInt(charSpacingStr);
                this.messageSpacing = Integer.parseInt(messageSpacingStr);
            }
        }
        return report;
    }

    public String getFontFilename() {
        return this.fontFilename;
    }

    public void setFontFilename(String fontFilename) {
        this.fontFilename = fontFilename;
        this.props.setProperty("fontFile", fontFilename);
    }

    public String getBorderFilename() {
        return this.borderFilename;
    }

    public void setBorderFilename(String borderFilename) {
        this.borderFilename = borderFilename;
        this.props.setProperty("fontBorderFile", borderFilename);
    }

    public int getGridWidth() {
        return this.gridWidth;
    }

    public void setGridWidth(int gridWidth) {
        this.gridWidth = gridWidth;
        this.props.setProperty("fontGridWidth", Integer.toString(gridWidth));
    }

    public int getGridHeight() {
        return this.gridHeight;
    }

    public void setGridHeight(int gridHeight) {
        this.gridHeight = gridHeight;
        this.props.setProperty("fontGridHeight", Integer.toString(gridHeight));
    }

    public float getFontScale() {
        return this.fontScale;
    }

    public void setFontScale(float fontScale) {
        this.fontScale = fontScale;
        this.props.setProperty("fontScale", Float.toString(fontScale));
    }

    public float getBorderScale() {
        return this.borderScale;
    }

    public void setBorderScale(float borderScale) {
        this.borderScale = borderScale;
        this.props.setProperty("fontBorderScale", Float.toString(borderScale));
    }

    public int getBorderInsetX() {
        return this.borderInsetX;
    }

    public void setBorderInsetX(int borderInsetX) {
        this.borderInsetX = borderInsetX;
        this.props.setProperty("fontBorderInsetX", Integer.toString(borderInsetX));
    }

    public int getBorderInsetY() {
        return this.borderInsetY;
    }

    public void setBorderInsetY(int borderInsetY) {
        this.borderInsetY = borderInsetY;
        this.props.setProperty("fontBorderInsetY", Integer.toString(borderInsetY));
    }

    public int getSpaceWidth() {
        return this.spaceWidth;
    }

    public void setSpaceWidth(int spaceWidth) {
        this.spaceWidth = spaceWidth;
        this.props.setProperty("fontSpaceWidth", Integer.toString(spaceWidth));
    }

    public int getBaselineOffset() {
        return this.baselineOffset;
    }

    public void setBaselineOffset(int baselineOffset) {
        this.baselineOffset = baselineOffset;
        this.props.getProperty("fontBaselineOffset", Integer.toString(baselineOffset));
    }

    public String getCharacterKey() {
        return this.characterKey;
    }

    public void setCharacterKey(String characterKey) {
        this.characterKey = characterKey;
        this.props.setProperty("fontCharacters", characterKey);
    }

    public char getUnknownChar() {
        return this.unknownChar;
    }

    public void setUnknownChar(char unknownChar) {
        this.unknownChar = unknownChar;
        this.props.setProperty("fontUnknownChar", Character.toString(unknownChar));
    }

    public boolean isExtendedCharEnabled() {
        return this.extendedCharEnabled;
    }

    public void setExtendedCharEnabled(boolean extendedCharEnabled) {
        this.extendedCharEnabled = extendedCharEnabled;
        this.props.setProperty("fontExtendedChar", Boolean.toString(extendedCharEnabled));
    }

    public int getLineSpacing() {
        return this.lineSpacing;
    }

    public void setLineSpacing(int lineSpacing) {
        this.lineSpacing = lineSpacing;
        this.props.setProperty("fontLineSpacing", Integer.toString(lineSpacing));
    }

    public int getCharSpacing() {
        return this.charSpacing;
    }

    public void setCharSpacing(int charSpacing) {
        this.charSpacing = charSpacing;
        this.props.setProperty("fontCharSpacing", Integer.toString(charSpacing));
    }

    public int getMessageSpacing() {
        return this.messageSpacing;
    }

    public void setMessageSpacing(int messageSpacing) {
        this.messageSpacing = messageSpacing;
        this.props.setProperty("fontMessageSpacing", Integer.toString(messageSpacing));
    }

    public FontType getFontType() {
        return this.fontType;
    }

    public void setFontType(FontType fontType) {
        this.fontType = fontType;
        this.props.setProperty("fontType", fontType.name());
    }
}

