/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.config;

import com.glitchcog.fontificator.config.Config;
import com.glitchcog.fontificator.config.EmojiLoadingDisplayStragegy;
import com.glitchcog.fontificator.config.FontificatorProperties;
import com.glitchcog.fontificator.config.loadreport.LoadConfigReport;
import com.glitchcog.fontificator.emoji.EmojiJob;
import com.glitchcog.fontificator.emoji.EmojiOperation;
import com.glitchcog.fontificator.emoji.EmojiType;
import java.awt.Color;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ConfigEmoji
extends Config {
    private static final Logger logger = Logger.getLogger(ConfigEmoji.class);
    public static final int MIN_SCALE = 10;
    public static final int MAX_SCALE = 500;
    public static final int MIN_BADGE_OFFSET = -32;
    public static final int MAX_BADGE_OFFSET = 64;
    public static final Color MOD_BADGE_COLOR = new Color(3452426);
    private Boolean emojiEnabled;
    private Boolean animationEnabled;
    private Boolean twitchBadgesEnabled;
    private Boolean ffzBadgesEnabled;
    private Boolean emojiScaleToLine;
    private Boolean badgeScaleToLine;
    private Integer badgeHeightOffset;
    private Integer emojiScale;
    private Integer badgeScale;
    private EmojiLoadingDisplayStragegy displayStrategy;
    private Boolean twitchEnabled;
    private Boolean twitchCacheEnabled;
    private Boolean ffzEnabled;
    private Boolean ffzCacheEnabled;
    private String twitchBadgesLoadedChannel;
    private String ffzBadgesLoadedChannel;
    private Boolean twitchLoaded;
    private Boolean twitchCached;
    private String ffzLoadedChannel;
    private Boolean ffzGlobalLoaded;
    private Boolean ffzCached;
    private Boolean bttvEnabled;
    private Boolean bttvCacheEnabled;
    private String bttvLoadedChannel;
    private Boolean bttvGlobalLoaded;
    private Boolean bttvCached;
    private Boolean twitterEnabled;

    public ConfigEmoji() {
        this.resetWorkCompleted();
    }

    @Override
    public void reset() {
        this.emojiEnabled = null;
        this.animationEnabled = null;
        this.twitchBadgesEnabled = null;
        this.ffzBadgesEnabled = null;
        this.emojiScaleToLine = null;
        this.badgeScaleToLine = null;
        this.badgeHeightOffset = null;
        this.emojiScale = null;
        this.badgeScale = null;
        this.displayStrategy = null;
        this.twitchEnabled = null;
        this.twitchCacheEnabled = null;
        this.ffzEnabled = null;
        this.ffzCacheEnabled = null;
        this.bttvEnabled = null;
        this.bttvCacheEnabled = null;
        this.bttvLoadedChannel = null;
        this.bttvGlobalLoaded = null;
        this.bttvCached = null;
        this.twitterEnabled = null;
    }

    public boolean isEmojiEnabled() {
        return this.emojiEnabled != null && this.emojiEnabled != false;
    }

    public void setEmojiEnabled(Boolean emojiEnabled) {
        this.emojiEnabled = emojiEnabled;
        this.props.setProperty("emojiEnabled", Boolean.toString(emojiEnabled));
    }

    public boolean isAnimationEnabled() {
        return this.animationEnabled != null && this.animationEnabled != false;
    }

    public void setAnimationEnabled(Boolean animationEnabled) {
        this.animationEnabled = animationEnabled;
        this.props.setProperty("emojiAnimationEnabled", Boolean.toString(animationEnabled));
    }

    public boolean isTwitchBadgesEnabled() {
        return this.twitchBadgesEnabled != null && this.twitchBadgesEnabled != false;
    }

    public void setTwitchBadgesEnabled(Boolean twitchBadgesEnabled) {
        this.twitchBadgesEnabled = twitchBadgesEnabled;
        this.props.setProperty("badgesEnabled", Boolean.toString(twitchBadgesEnabled));
    }

    public boolean isFfzBadgesEnabled() {
        return this.ffzBadgesEnabled != null && this.ffzBadgesEnabled != false;
    }

    public void setFfzBadgesEnabled(Boolean ffzBadgesEnabled) {
        this.ffzBadgesEnabled = ffzBadgesEnabled;
        this.props.setProperty("badgesFfzEnabled", Boolean.toString(ffzBadgesEnabled));
    }

    public boolean isAnyBadgesEnabled() {
        return this.isFfzBadgesEnabled() || this.isTwitchBadgesEnabled();
    }

    public boolean isEmojiScaleToLine() {
        return this.emojiScaleToLine != null && this.emojiScaleToLine != false;
    }

    public void setEmojiScaleToLine(Boolean emojiScaleToLine) {
        this.emojiScaleToLine = emojiScaleToLine;
        this.props.setProperty("emojiScaleToLine", Boolean.toString(emojiScaleToLine));
    }

    public boolean isBadgeScaleToLine() {
        return this.badgeScaleToLine != null && this.badgeScaleToLine != false;
    }

    public void setBadgeScaleToLine(Boolean badgeScaleToLine) {
        this.badgeScaleToLine = badgeScaleToLine;
        this.props.setProperty("badgeScaleToLine", Boolean.toString(badgeScaleToLine));
    }

    public int getBadgeHeightOffset() {
        return this.badgeHeightOffset;
    }

    public void setBadgeHeightOffset(int badgeHeightOffset) {
        this.badgeHeightOffset = badgeHeightOffset;
        this.props.setProperty("badgeHeightOffset", Integer.toString(badgeHeightOffset));
    }

    public Integer getEmojiScale() {
        return this.emojiScale;
    }

    public void setEmojiScale(Integer emojiScale) {
        this.emojiScale = emojiScale;
        this.props.setProperty("emojiScale", Integer.toString(emojiScale));
    }

    public Integer getBadgeScale() {
        return this.badgeScale;
    }

    public void setBadgeScale(Integer badgeScale) {
        this.badgeScale = badgeScale;
        this.props.setProperty("badgeScale", Integer.toString(badgeScale));
    }

    public EmojiLoadingDisplayStragegy getDisplayStrategy() {
        return this.displayStrategy;
    }

    public void setDisplayStrategy(EmojiLoadingDisplayStragegy displayStrategy) {
        this.displayStrategy = displayStrategy;
        this.props.setProperty("emojiDisplayStrat", displayStrategy.name());
    }

    public boolean isTwitchEnabled() {
        return this.twitchEnabled != null && this.twitchEnabled != false;
    }

    public void setTwitchEnabled(Boolean twitchEnabled) {
        this.twitchEnabled = twitchEnabled;
        this.props.setProperty("emojiTwitchEnabled", Boolean.toString(twitchEnabled));
    }

    public boolean isTwitchCacheEnabled() {
        return this.twitchCacheEnabled != null && this.twitchCacheEnabled != false;
    }

    public void setTwitchCacheEnabled(Boolean twitchCacheEnabled) {
        this.twitchCacheEnabled = twitchCacheEnabled;
        this.props.setProperty("emojiTwitchCached", Boolean.toString(twitchCacheEnabled));
    }

    public boolean isFfzEnabled() {
        return this.ffzEnabled != null && this.ffzEnabled != false;
    }

    public void setFfzEnabled(Boolean ffzEnabled) {
        this.ffzEnabled = ffzEnabled;
        this.props.setProperty("emojiFfzEnabled", Boolean.toString(ffzEnabled));
    }

    public boolean isFfzCacheEnabled() {
        return this.ffzCacheEnabled != null && this.ffzCacheEnabled != false;
    }

    public void setFfzCacheEnabled(Boolean ffzCacheEnabled) {
        this.ffzCacheEnabled = ffzCacheEnabled;
        this.props.setProperty("emojiFfzCached", Boolean.toString(ffzCacheEnabled));
    }

    public Boolean isBttvEnabled() {
        if (this.bttvEnabled != null && this.bttvEnabled.booleanValue()) {
            return true;
        }
        return false;
    }

    public Boolean isBttvCacheEnabled() {
        if (this.bttvCacheEnabled != null && this.bttvCacheEnabled.booleanValue()) {
            return true;
        }
        return false;
    }

    public void setBttvCacheEnabled(Boolean bttvCacheEnabled) {
        this.bttvCacheEnabled = bttvCacheEnabled;
        this.props.setProperty("emojiBttvCached", Boolean.toString(bttvCacheEnabled));
    }

    public boolean isTypeEnabledAndLoaded(EmojiType type) {
        if (type == null) {
            return false;
        }
        switch (type) {
            case FRANKERFACEZ_CHANNEL: {
                return this.ffzEnabled != null && this.ffzEnabled != false && this.ffzLoadedChannel != null;
            }
            case FRANKERFACEZ_GLOBAL: {
                return this.ffzEnabled != null && this.ffzEnabled != false && this.ffzGlobalLoaded != null && this.ffzGlobalLoaded != false;
            }
            case FRANKERFACEZ_BADGE: {
                return this.ffzBadgesEnabled != null && this.ffzBadgesEnabled != false && this.ffzBadgesLoadedChannel != null;
            }
            case BETTER_TTV_CHANNEL: {
                return this.bttvEnabled != null && this.bttvEnabled != false && this.bttvLoadedChannel != null;
            }
            case BETTER_TTV_GLOBAL: {
                return this.bttvEnabled != null && this.bttvEnabled != false && this.bttvGlobalLoaded != null && this.bttvGlobalLoaded != false;
            }
            case TWITCH_BADGE: {
                return this.twitchBadgesEnabled != null && this.twitchBadgesEnabled != false && this.twitchBadgesLoadedChannel != null;
            }
            case TWITTER_EMOJI: {
                return this.twitterEnabled;
            }
        }
        return false;
    }

    public LoadConfigReport validateStrings(LoadConfigReport report, String enabledBool, String aniBool, String badgeTwitchBool, String badgeFfzBool, String scaleEnabledBool, String scaleBadgeEnabledBool, String badgeHeightOffsetStr, String scale, String scaleBadge, String displayStrat, String twitchBool, String twitchCacheBool, String ffzBool, String ffzCacheBool, String bttvBool, String bttvCacheBool, String twitterBool) {
        this.validateBooleanStrings(report, enabledBool, aniBool, badgeTwitchBool, badgeFfzBool, scaleEnabledBool, scaleBadgeEnabledBool, twitchBool, twitchCacheBool, ffzBool, ffzCacheBool, bttvBool, bttvCacheBool);
        this.validateIntegerWithLimitString("emojiScale", scale, 10, 500, report);
        this.validateIntegerWithLimitString("badgeScale", scaleBadge, 10, 500, report);
        this.validateIntegerWithLimitString("badgeHeightOffset", badgeHeightOffsetStr, -32, 64, report);
        return report;
    }

    @Override
    public LoadConfigReport load(Properties props, LoadConfigReport report) {
        this.props = props;
        this.reset();
        this.baseValidation(props, FontificatorProperties.EMOJI_KEYS, report);
        if (report.isErrorFree()) {
            String enabledStr = props.getProperty("emojiEnabled");
            String aniStr = props.getProperty("emojiAnimationEnabled");
            String twitchBadgeStr = props.getProperty("badgesEnabled");
            String ffzBadgeStr = props.getProperty("badgesFfzEnabled");
            String scaleEnabledStr = props.getProperty("emojiScaleToLine");
            String scaleBadgeEnabledStr = props.getProperty("badgeScaleToLine");
            String badgeHeightOffsetStr = props.getProperty("badgeHeightOffset");
            String scaleStr = props.getProperty("emojiScale");
            String scaleBadgeStr = props.getProperty("badgeScale");
            String displayStratStr = props.getProperty("emojiDisplayStrat");
            String twitchEnabledStr = props.getProperty("emojiTwitchEnabled");
            String twitchCacheStr = props.getProperty("emojiTwitchCached");
            String ffzEnabledStr = props.getProperty("emojiFfzEnabled");
            String ffzCacheStr = props.getProperty("emojiFfzCached");
            String bttvEnabledStr = props.getProperty("emojiBttvEnabled");
            String bttvCacheStr = props.getProperty("emojiBttvCached");
            String twitterStr = props.getProperty("emojiTwitterEnabled");
            this.validateStrings(report, enabledStr, aniStr, twitchBadgeStr, ffzBadgeStr, scaleEnabledStr, scaleBadgeEnabledStr, badgeHeightOffsetStr, scaleStr, scaleBadgeStr, displayStratStr, twitchEnabledStr, twitchCacheStr, ffzEnabledStr, ffzCacheStr, bttvEnabledStr, bttvCacheStr, twitterStr);
            if (report.isErrorFree()) {
                this.emojiEnabled = this.evaluateBooleanString(props, "emojiEnabled", report);
                this.animationEnabled = this.evaluateBooleanString(props, "emojiAnimationEnabled", report);
                this.twitchBadgesEnabled = this.evaluateBooleanString(props, "badgesEnabled", report);
                this.ffzBadgesEnabled = this.evaluateBooleanString(props, "badgesFfzEnabled", report);
                this.emojiScaleToLine = this.evaluateBooleanString(props, "emojiScaleToLine", report);
                this.badgeScaleToLine = this.evaluateBooleanString(props, "badgeScaleToLine", report);
                this.badgeHeightOffset = this.evaluateIntegerString(props, "badgeHeightOffset", report);
                this.emojiScale = this.evaluateIntegerString(props, "emojiScale", report);
                this.badgeScale = this.evaluateIntegerString(props, "badgeScale", report);
                this.displayStrategy = EmojiLoadingDisplayStragegy.valueOf(displayStratStr);
                this.twitchEnabled = this.evaluateBooleanString(props, "emojiTwitchEnabled", report);
                this.twitchCacheEnabled = this.evaluateBooleanString(props, "emojiTwitchCached", report);
                this.ffzEnabled = this.evaluateBooleanString(props, "emojiFfzEnabled", report);
                this.ffzCacheEnabled = this.evaluateBooleanString(props, "emojiFfzCached", report);
                this.bttvEnabled = this.evaluateBooleanString(props, "emojiBttvEnabled", report);
                this.bttvCacheEnabled = this.evaluateBooleanString(props, "emojiBttvCached", report);
                this.twitterEnabled = this.evaluateBooleanString(props, "emojiTwitterEnabled", report);
            }
        }
        return report;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.displayStrategy == null ? 0 : this.displayStrategy.hashCode());
        result = 31 * result + (this.emojiEnabled == null ? 0 : this.emojiEnabled.hashCode());
        result = 31 * result + (this.animationEnabled == null ? 0 : this.animationEnabled.hashCode());
        result = 31 * result + (this.twitchBadgesEnabled == null ? 0 : this.twitchBadgesEnabled.hashCode());
        result = 31 * result + (this.ffzBadgesEnabled == null ? 0 : this.ffzBadgesEnabled.hashCode());
        result = 31 * result + (this.ffzEnabled == null ? 0 : this.ffzEnabled.hashCode());
        result = 31 * result + (this.ffzLoadedChannel == null ? 0 : this.ffzLoadedChannel.hashCode());
        result = 31 * result + (this.ffzGlobalLoaded == null ? 0 : this.ffzGlobalLoaded.hashCode());
        result = 31 * result + (this.bttvEnabled == null ? 0 : this.bttvEnabled.hashCode());
        result = 31 * result + (this.bttvLoadedChannel == null ? 0 : this.bttvLoadedChannel.hashCode());
        result = 31 * result + (this.bttvGlobalLoaded == null ? 0 : this.bttvGlobalLoaded.hashCode());
        result = 31 * result + (this.emojiScale == null ? 0 : this.emojiScale.hashCode());
        result = 31 * result + (this.emojiScaleToLine == null ? 0 : this.emojiScaleToLine.hashCode());
        result = 31 * result + (this.badgeScale == null ? 0 : this.badgeScale.hashCode());
        result = 31 * result + (this.badgeScaleToLine == null ? 0 : this.badgeScaleToLine.hashCode());
        result = 31 * result + (this.badgeHeightOffset == null ? 0 : this.badgeHeightOffset.hashCode());
        result = 31 * result + (this.twitchEnabled == null ? 0 : this.twitchEnabled.hashCode());
        result = 31 * result + (this.twitchLoaded == null ? 0 : this.twitchLoaded.hashCode());
        result = 31 * result + (this.twitchBadgesLoadedChannel == null ? 0 : this.twitchBadgesLoadedChannel.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigEmoji other = (ConfigEmoji)obj;
        if (this.displayStrategy != other.displayStrategy) {
            return false;
        }
        if (this.emojiEnabled == null ? other.emojiEnabled != null : !this.emojiEnabled.equals(other.emojiEnabled)) {
            return false;
        }
        if (this.twitchBadgesEnabled == null ? other.twitchBadgesEnabled != null : !this.twitchBadgesEnabled.equals(other.twitchBadgesEnabled)) {
            return false;
        }
        if (this.ffzBadgesEnabled == null ? other.ffzBadgesEnabled != null : !this.ffzBadgesEnabled.equals(other.ffzBadgesEnabled)) {
            return false;
        }
        if (this.ffzEnabled == null ? other.ffzEnabled != null : !this.ffzEnabled.equals(other.ffzEnabled)) {
            return false;
        }
        if (this.ffzLoadedChannel == null ? other.ffzLoadedChannel != null : !this.ffzLoadedChannel.equals(other.ffzLoadedChannel)) {
            return false;
        }
        if (this.ffzGlobalLoaded == null ? other.ffzGlobalLoaded != null : !this.ffzGlobalLoaded.equals(other.ffzGlobalLoaded)) {
            return false;
        }
        if (this.bttvEnabled == null ? other.bttvEnabled != null : !this.bttvEnabled.equals(other.bttvEnabled)) {
            return false;
        }
        if (this.bttvLoadedChannel == null ? other.bttvLoadedChannel != null : !this.bttvLoadedChannel.equals(other.bttvLoadedChannel)) {
            return false;
        }
        if (this.bttvGlobalLoaded == null ? other.bttvGlobalLoaded != null : !this.bttvGlobalLoaded.equals(other.bttvGlobalLoaded)) {
            return false;
        }
        if (this.emojiScale == null ? other.emojiScale != null : !this.emojiScale.equals(other.emojiScale)) {
            return false;
        }
        if (this.badgeScale == null ? other.badgeScale != null : !this.badgeScale.equals(other.badgeScale)) {
            return false;
        }
        if (this.emojiScaleToLine == null ? other.emojiScaleToLine != null : !this.emojiScaleToLine.equals(other.emojiScaleToLine)) {
            return false;
        }
        if (this.badgeScaleToLine == null ? other.badgeScaleToLine != null : !this.badgeScaleToLine.equals(other.badgeScaleToLine)) {
            return false;
        }
        if (this.badgeHeightOffset == null ? other.badgeHeightOffset != null : !this.badgeHeightOffset.equals(other.badgeHeightOffset)) {
            return false;
        }
        if (this.twitchEnabled == null ? other.twitchEnabled != null : !this.twitchEnabled.equals(other.twitchEnabled)) {
            return false;
        }
        if (this.twitchLoaded == null ? other.twitchLoaded != null : !this.twitchLoaded.equals(other.twitchLoaded)) {
            return false;
        }
        if (this.twitchBadgesLoadedChannel == null ? other.twitchBadgesLoadedChannel != null : !this.twitchBadgesLoadedChannel.equals(other.twitchBadgesLoadedChannel)) {
            return false;
        }
        return !(this.twitterEnabled == null ? other.twitterEnabled != null : !this.twitterEnabled.equals(other.twitterEnabled));
    }

    public void deepCopy(ConfigEmoji copy) {
        this.emojiEnabled = copy.emojiEnabled;
        this.twitchBadgesEnabled = copy.twitchBadgesEnabled;
        this.ffzBadgesEnabled = copy.ffzBadgesEnabled;
        this.emojiScaleToLine = copy.emojiScaleToLine;
        this.emojiScale = copy.emojiScale;
        this.badgeScaleToLine = copy.badgeScaleToLine;
        this.badgeHeightOffset = copy.badgeHeightOffset;
        this.badgeScale = copy.badgeScale;
        this.displayStrategy = copy.displayStrategy;
        this.twitchEnabled = copy.twitchEnabled;
        this.ffzEnabled = copy.ffzEnabled;
        this.twitchLoaded = copy.twitchLoaded;
        this.twitchBadgesLoadedChannel = copy.twitchBadgesLoadedChannel;
        this.ffzLoadedChannel = copy.ffzLoadedChannel;
        this.ffzGlobalLoaded = copy.ffzGlobalLoaded;
        this.bttvEnabled = copy.bttvEnabled;
        this.bttvCacheEnabled = copy.bttvCacheEnabled;
        this.bttvLoadedChannel = copy.bttvLoadedChannel;
        this.bttvGlobalLoaded = copy.bttvGlobalLoaded;
        this.bttvCached = copy.bttvCached;
        this.twitterEnabled = copy.twitterEnabled;
    }

    public Boolean isTwitchLoaded() {
        if (this.twitchLoaded != null && this.twitchLoaded.booleanValue()) {
            return true;
        }
        return false;
    }

    public void setTwitchLoaded(Boolean twitchLoaded) {
        this.twitchLoaded = twitchLoaded;
    }

    public Boolean isTwitchCached() {
        if (this.twitchCached != null && this.twitchCached.booleanValue()) {
            return true;
        }
        return false;
    }

    public void setTwitchCached(Boolean twitchCached) {
        this.twitchCached = twitchCached;
    }

    public boolean isTwitchBadgesLoaded(String testChannel) {
        return this.twitchBadgesLoadedChannel != null && this.twitchBadgesLoadedChannel.equals(testChannel);
    }

    public boolean isFfzBadgesLoaded(String testChannel) {
        return this.ffzBadgesLoadedChannel != null && this.ffzBadgesLoadedChannel.equals(testChannel);
    }

    public void setTwitchBadgesLoaded(String twitchBadgesLoadedChannel) {
        this.twitchBadgesLoadedChannel = twitchBadgesLoadedChannel;
    }

    public void setFfzBadgesLoaded(String ffzBadgesLoadedChannel) {
        this.ffzBadgesLoadedChannel = ffzBadgesLoadedChannel;
    }

    public boolean isFfzLoaded(String testChannel) {
        return this.ffzLoadedChannel != null && this.ffzLoadedChannel.equals(testChannel);
    }

    public void setFfzLoaded(String ffzLoadedChannel) {
        this.ffzLoadedChannel = ffzLoadedChannel;
    }

    public Boolean isFfzGlobalLoaded() {
        if (this.ffzGlobalLoaded != null && this.ffzGlobalLoaded.booleanValue()) {
            return true;
        }
        return false;
    }

    public void setFfzGlobalLoaded(Boolean ffzGlobalLoaded) {
        this.ffzGlobalLoaded = ffzGlobalLoaded;
    }

    public boolean isFfzCached() {
        return this.ffzCached != null && this.ffzCached != false;
    }

    public void setFfzCached(Boolean ffzCached) {
        this.ffzCached = ffzCached;
    }

    public void setBttvEnabled(Boolean bttvEnabled) {
        this.bttvEnabled = bttvEnabled;
        this.props.setProperty("emojiBttvEnabled", Boolean.toString(bttvEnabled));
    }

    public String getBttvLoadedChannel() {
        return this.bttvLoadedChannel;
    }

    public void setBttvLoadedChannel(String bttvLoadedChannel) {
        this.bttvLoadedChannel = bttvLoadedChannel;
    }

    public void setBttvGlobalLoaded(Boolean bttvGlobalLoaded) {
        this.bttvGlobalLoaded = bttvGlobalLoaded;
    }

    public boolean isBttvLoaded(String testChannel) {
        return this.bttvLoadedChannel != null && this.bttvLoadedChannel.equals(testChannel);
    }

    public void setBttfLoaded(String bttvLoadedChannel) {
        this.bttvLoadedChannel = bttvLoadedChannel;
    }

    public Boolean isBttvGlobalLoaded() {
        if (this.bttvGlobalLoaded != null && this.bttvGlobalLoaded.booleanValue()) {
            return true;
        }
        return false;
    }

    public void setBttfGlobalLoaded(Boolean bttvGlobalLoaded) {
        this.bttvGlobalLoaded = bttvGlobalLoaded;
    }

    public boolean isBttvCached() {
        return this.bttvCached != null && this.bttvCached != false;
    }

    public void setBttvCached(Boolean bttvCached) {
        this.bttvCached = bttvCached;
    }

    public boolean isTwitterEnabled() {
        return this.twitterEnabled;
    }

    public void setTwitterEnabled(Boolean twitterEnabled) {
        this.twitterEnabled = twitterEnabled;
        this.props.setProperty("emojiTwitterEnabled", Boolean.toString(twitterEnabled));
    }

    public void setWorkCompleted(EmojiJob job) {
        logger.trace(String.valueOf(job.toString()) + " completed");
        EmojiType emojiType = job.getType();
        EmojiOperation emojiOp = job.getOp();
        if (EmojiType.TWITCH_BADGE.equals((Object)emojiType)) {
            this.twitchBadgesLoadedChannel = job.getChannel();
        } else if (EmojiType.FRANKERFACEZ_BADGE.equals((Object)emojiType)) {
            this.ffzBadgesLoadedChannel = job.getChannel();
        } else if (emojiType.isTwitchEmote()) {
            if (EmojiOperation.LOAD == emojiOp) {
                this.twitchLoaded = true;
            } else if (EmojiOperation.CACHE == emojiOp) {
                this.twitchCached = true;
            }
        } else if (emojiType.isFrankerFaceZEmote()) {
            if (EmojiOperation.LOAD == emojiOp) {
                if (emojiType == EmojiType.FRANKERFACEZ_CHANNEL) {
                    this.ffzLoadedChannel = job.getChannel();
                } else if (emojiType == EmojiType.FRANKERFACEZ_GLOBAL) {
                    this.ffzGlobalLoaded = true;
                }
            } else if (EmojiOperation.CACHE == emojiOp) {
                this.ffzCached = true;
            }
        } else if (emojiType.isBetterTtvEmote()) {
            if (EmojiOperation.LOAD == emojiOp) {
                if (emojiType == EmojiType.BETTER_TTV_CHANNEL) {
                    this.bttvLoadedChannel = job.getChannel();
                } else if (emojiType == EmojiType.BETTER_TTV_GLOBAL) {
                    this.bttvGlobalLoaded = true;
                }
            } else if (EmojiOperation.CACHE == emojiOp) {
                this.bttvCached = true;
            }
        }
    }

    public void resetWorkCompleted() {
        this.twitchLoaded = false;
        this.twitchCached = false;
        this.twitchBadgesLoadedChannel = null;
        this.ffzBadgesLoadedChannel = null;
        this.ffzLoadedChannel = null;
        this.ffzGlobalLoaded = false;
        this.ffzCached = null;
        this.bttvLoadedChannel = null;
        this.bttvGlobalLoaded = false;
        this.bttvCached = null;
    }

    public boolean isAnyWorkDone() {
        return this.twitchBadgesLoadedChannel != null || this.isTwitchLoaded() != false || this.isTwitchCached() != false || this.ffzBadgesLoadedChannel != null || this.ffzLoadedChannel != null || this.isFfzGlobalLoaded() != false || this.isFfzCached() || this.bttvLoadedChannel != null || this.isBttvGlobalLoaded() != false || this.isBttvCached();
    }
}

