/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.config;

import com.glitchcog.fontificator.config.Config;
import com.glitchcog.fontificator.config.FontificatorProperties;
import com.glitchcog.fontificator.config.loadreport.LoadConfigReport;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ConfigColor
extends Config {
    private static final Logger logger = Logger.getLogger(ConfigColor.class);
    private Color bgColor;
    private Color fgColor;
    private Color borderColor;
    private Color highlight;
    private Color chromaColor;
    private List<Color> palette;
    private Boolean colorUsername;
    private Boolean colorTimestamp;
    private Boolean colorMessage;
    private Boolean colorJoin;
    private Boolean useTwitchColors;

    @Override
    public void reset() {
        this.bgColor = null;
        this.fgColor = null;
        this.borderColor = null;
        this.highlight = null;
        this.chromaColor = null;
        this.palette = null;
        this.colorUsername = null;
        this.colorTimestamp = null;
        this.colorMessage = null;
        this.colorJoin = null;
        this.useTwitchColors = null;
    }

    private void validateStrings(LoadConfigReport report, String palStr, String userBool, String timeBool, String msgBool, String joinBool, String twitchBool) {
        this.evaluateColorString(this.props, "colorBackground", report);
        this.evaluateColorString(this.props, "colorForeground", report);
        this.evaluateColorString(this.props, "colorBorder", report);
        this.evaluateColorString(this.props, "colorHighlight", report);
        this.evaluateColorString(this.props, "chromaKey", report);
        this.validateBooleanStrings(report, userBool, timeBool, msgBool, joinBool, twitchBool);
        if (!palStr.trim().isEmpty()) {
            String[] palColStrs = palStr.split(",");
            int i = 0;
            while (i < palColStrs.length) {
                this.evaluateColorString(palColStrs[i], report);
                ++i;
            }
        }
    }

    @Override
    public LoadConfigReport load(Properties props, LoadConfigReport report) {
        logger.trace("Loading config color via raw properties object");
        this.props = props;
        this.reset();
        this.baseValidation(props, FontificatorProperties.COLOR_KEYS_WITHOUT_PALETTE, report);
        if (report.isErrorFree()) {
            String paletteStr = props.getProperty("colorPalette");
            String userBool = props.getProperty("colorUsername");
            String timeBool = props.getProperty("colorTimestamp");
            String msgBool = props.getProperty("colorMessage");
            String joinBool = props.getProperty("colorJoin");
            String twitchBool = props.getProperty("colorUseTwitch");
            this.validateStrings(report, paletteStr, userBool, timeBool, msgBool, joinBool, twitchBool);
            if (report.isErrorFree()) {
                this.bgColor = this.evaluateColorString(props, "colorBackground", report);
                this.fgColor = this.evaluateColorString(props, "colorForeground", report);
                this.borderColor = this.evaluateColorString(props, "colorBorder", report);
                this.highlight = this.evaluateColorString(props, "colorHighlight", report);
                this.chromaColor = this.evaluateColorString(props, "chromaKey", report);
                this.palette = new ArrayList<Color>();
                String[] palColStrs = paletteStr.isEmpty() ? new String[]{} : paletteStr.split(",");
                int i = 0;
                while (i < palColStrs.length) {
                    Color palAddition = this.evaluateColorString(palColStrs[i], report);
                    if (palAddition != null) {
                        this.palette.add(palAddition);
                    }
                    ++i;
                }
                this.colorUsername = this.evaluateBooleanString(props, "colorUsername", report);
                this.colorTimestamp = this.evaluateBooleanString(props, "colorTimestamp", report);
                this.colorMessage = this.evaluateBooleanString(props, "colorMessage", report);
                this.colorJoin = this.evaluateBooleanString(props, "colorJoin", report);
                this.useTwitchColors = this.evaluateBooleanString(props, "colorUseTwitch", report);
            }
        }
        return report;
    }

    public Color getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(Color bgColor) {
        this.bgColor = bgColor;
        this.props.setProperty("colorBackground", ConfigColor.getColorHex(bgColor));
    }

    public Color getFgColor() {
        return this.fgColor;
    }

    public void setFgColor(Color fgColor) {
        this.fgColor = fgColor;
        this.props.setProperty("colorForeground", ConfigColor.getColorHex(fgColor));
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
        this.props.setProperty("colorBorder", ConfigColor.getColorHex(borderColor));
    }

    public Color getHighlight() {
        return this.highlight;
    }

    public void setHighlight(Color highlight) {
        this.highlight = highlight;
        this.props.setProperty("colorHighlight", ConfigColor.getColorHex(highlight));
    }

    public Color getChromaColor() {
        return this.chromaColor;
    }

    public void setChromaColor(Color chromaColor) {
        this.chromaColor = chromaColor;
        this.props.setProperty("chromaKey", ConfigColor.getColorHex(chromaColor));
    }

    public List<Color> getPalette() {
        return this.palette == null ? new ArrayList() : this.palette;
    }

    public void setPalette(List<Color> palette) {
        this.palette = palette;
        String paletteString = "";
        int i = 0;
        while (i < palette.size()) {
            paletteString = String.valueOf(paletteString) + (i == 0 ? "" : ",") + ConfigColor.getColorHex(palette.get(i));
            ++i;
        }
        this.props.setProperty("colorPalette", paletteString);
    }

    public boolean isColorUsername() {
        return this.colorUsername;
    }

    public void setColorUsername(Boolean colorUsername) {
        this.colorUsername = colorUsername;
        this.props.setProperty("colorUsername", Boolean.toString(colorUsername));
    }

    public boolean isColorTimestamp() {
        return this.colorTimestamp;
    }

    public void setColorTimestamp(Boolean colorTimestamp) {
        this.colorTimestamp = colorTimestamp;
        this.props.setProperty("colorTimestamp", Boolean.toString(colorTimestamp));
    }

    public boolean isColorMessage() {
        return this.colorMessage;
    }

    public void setColorMessage(Boolean colorMessage) {
        this.colorMessage = colorMessage;
        this.props.setProperty("colorMessage", Boolean.toString(colorMessage));
    }

    public boolean isColorJoin() {
        return this.colorJoin;
    }

    public void setColorJoin(Boolean colorJoin) {
        this.colorJoin = colorJoin;
        this.props.setProperty("colorJoin", Boolean.toString(colorJoin));
    }

    public boolean isUseTwitchColors() {
        return this.useTwitchColors;
    }

    public void setUseTwitchColors(Boolean useTwitchColors) {
        this.useTwitchColors = useTwitchColors;
        this.props.setProperty("colorUseTwitch", Boolean.toString(useTwitchColors));
    }

    public static String getColorHex(Color c) {
        return String.format("%06X", 0xFFFFFF & c.getRGB());
    }
}

