/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.config;

import com.glitchcog.fontificator.config.Config;
import com.glitchcog.fontificator.config.FontificatorProperties;
import com.glitchcog.fontificator.config.loadreport.LoadConfigReport;
import java.awt.Rectangle;
import java.util.Properties;

public class ConfigChat
extends Config {
    public static final int MIN_CHROMA_CORNER_RADIUS = 0;
    public static final int MAX_CHROMA_CORNER_RADIUS = 128;
    private Boolean scrollable;
    private Boolean resizable;
    private Boolean rememberPosition;
    private Integer chatWindowPositionX;
    private Integer chatWindowPositionY;
    private Boolean chatFromBottom;
    private Integer width;
    private Integer height;
    private Integer windowWidth;
    private Integer windowHeight;
    private Boolean chromaEnabled;
    private Boolean chromaInvert;
    private Rectangle chromaBorder;
    private Integer chromaCornerRadius;
    private Boolean reverseScrolling;
    private Boolean alwaysOnTop;
    private Boolean antiAlias;

    @Override
    public void reset() {
        this.scrollable = null;
        this.resizable = null;
        this.rememberPosition = null;
        this.chatWindowPositionX = null;
        this.chatWindowPositionY = null;
        this.chatFromBottom = null;
        this.width = null;
        this.height = null;
        this.windowWidth = null;
        this.windowHeight = null;
        this.chromaEnabled = null;
        this.chromaInvert = null;
        this.chromaBorder = null;
        this.chromaCornerRadius = null;
        this.reverseScrolling = null;
        this.alwaysOnTop = null;
        this.antiAlias = null;
    }

    public LoadConfigReport validateDimStrings(LoadConfigReport report, String widthStr, String heightStr) {
        this.validateIntegerWithLimitString("chatWidth", widthStr, 1, report);
        this.validateIntegerWithLimitString("chatHeight", heightStr, 1, report);
        return report;
    }

    public LoadConfigReport validateChromaDimStrings(LoadConfigReport report, String leftStr, String topStr, String rightStr, String botStr) {
        this.validateIntegerWithLimitString("chromaLeft", leftStr, 0, report);
        this.validateIntegerWithLimitString("chromaTop", topStr, 0, report);
        this.validateIntegerWithLimitString("chromaRight", rightStr, 0, report);
        this.validateIntegerWithLimitString("chromaBottom", botStr, 0, report);
        return report;
    }

    public LoadConfigReport validateStrings(LoadConfigReport report, String widthStr, String heightStr, String windowWidthStr, String windowHeightStr, String chromaLeftStr, String chromaTopStr, String chromaRightStr, String chromaBottomStr, String chromaCornerStr, String scrollBool, String reverseScrollBool, String resizeBool, String remPosBool, String fromBottomBool, String chromaBool, String invertBool, String topBool) {
        this.validateBooleanStrings(report, scrollBool, reverseScrollBool, resizeBool, remPosBool, fromBottomBool, chromaBool, invertBool, topBool);
        if (widthStr != null && heightStr != null) {
            this.validateDimStrings(report, widthStr, heightStr);
        } else if (windowWidthStr != null && windowHeightStr != null) {
            this.validateDimStrings(report, windowWidthStr, windowHeightStr);
        }
        this.validateChromaDimStrings(report, chromaLeftStr, chromaTopStr, chromaRightStr, chromaBottomStr);
        this.validateIntegerWithLimitString("chromaCornerRadius", chromaCornerStr, 0, report);
        return report;
    }

    @Override
    public LoadConfigReport load(Properties props, LoadConfigReport report) {
        this.props = props;
        this.reset();
        this.baseValidation(props, FontificatorProperties.CHAT_KEYS, report);
        if (report.isErrorFree()) {
            String widthStr = props.getProperty("chatPixelWidth");
            String heightStr = props.getProperty("chatPixelHeight");
            String windowWidthStr = props.getProperty("chatWidth");
            String windowHeightStr = props.getProperty("chatHeight");
            String chromaLeftStr = props.getProperty("chromaLeft");
            String chromaTopStr = props.getProperty("chromaTop");
            String chromaRightStr = props.getProperty("chromaRight");
            String chromaBottomStr = props.getProperty("chromaBottom");
            String chromaCornerStr = props.getProperty("chromaCornerRadius");
            String scrollBool = props.getProperty("chatScrollEnabled");
            String resizeBool = props.getProperty("chatResizable");
            String remPosBool = props.getProperty("chatPosition");
            String fromBottomBool = props.getProperty("chatFromBottom");
            String reverseScrollBool = props.getProperty("reverseScrolling");
            String chromaBool = props.getProperty("chromaEnabled");
            String invertBool = props.getProperty("invertChroma");
            String topBool = props.getProperty("chatAlwaysOnTop");
            this.validateStrings(report, widthStr, heightStr, windowWidthStr, windowHeightStr, chromaLeftStr, chromaTopStr, chromaRightStr, chromaBottomStr, chromaCornerStr, scrollBool, reverseScrollBool, resizeBool, remPosBool, fromBottomBool, chromaBool, invertBool, topBool);
            if (report.isErrorFree()) {
                if (windowWidthStr != null && windowHeightStr != null) {
                    this.windowWidth = Integer.parseInt(windowWidthStr);
                    this.windowHeight = Integer.parseInt(windowHeightStr);
                } else if (widthStr != null && heightStr != null) {
                    this.width = Integer.parseInt(widthStr);
                    this.height = Integer.parseInt(heightStr);
                }
                this.chromaCornerRadius = Integer.parseInt(chromaCornerStr);
                int left = Integer.parseInt(chromaLeftStr);
                int top = Integer.parseInt(chromaTopStr);
                int right = Integer.parseInt(chromaRightStr);
                int bot = Integer.parseInt(chromaBottomStr);
                this.setChromaBorder(left, top, right, bot);
                this.scrollable = this.evaluateBooleanString(props, "chatScrollEnabled", report);
                this.resizable = this.evaluateBooleanString(props, "chatResizable", report);
                this.rememberPosition = this.evaluateBooleanString(props, "chatPosition", report);
                this.chatWindowPositionX = this.evaluateIntegerString(props, "chatPositionX", report);
                this.chatWindowPositionY = this.evaluateIntegerString(props, "chatPositionY", report);
                this.chatFromBottom = this.evaluateBooleanString(props, "chatFromBottom", report);
                this.reverseScrolling = this.evaluateBooleanString(props, "reverseScrolling", report);
                this.chromaEnabled = this.evaluateBooleanString(props, "chromaEnabled", report);
                this.chromaInvert = this.evaluateBooleanString(props, "invertChroma", report);
                this.alwaysOnTop = this.evaluateBooleanString(props, "chatAlwaysOnTop", report);
                this.antiAlias = this.evaluateBooleanString(props, "chatAntialias", report);
            }
        }
        return report;
    }

    public boolean isScrollable() {
        return this.scrollable;
    }

    public void setScrollable(boolean scrollable) {
        this.scrollable = scrollable;
        this.props.setProperty("chatScrollEnabled", Boolean.toString(scrollable));
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public void setResizable(boolean resizable) {
        this.resizable = resizable;
        this.props.setProperty("chatResizable", Boolean.toString(resizable));
    }

    public boolean isRememberPosition() {
        return this.rememberPosition;
    }

    public void setRememberPosition(boolean rememberPosition) {
        this.rememberPosition = rememberPosition;
        this.props.setProperty("chatPosition", Boolean.toString(rememberPosition));
    }

    public int getChatWindowPositionX() {
        return this.chatWindowPositionX == null ? 0 : this.chatWindowPositionX;
    }

    public void setChatWindowPositionX(int chatWindowPositionX) {
        this.chatWindowPositionX = chatWindowPositionX;
        this.props.setProperty("chatPositionX", Integer.toString(chatWindowPositionX));
    }

    public int getChatWindowPositionY() {
        return this.chatWindowPositionY == null ? 0 : this.chatWindowPositionY;
    }

    public void setChatWindowPositionY(int chatWindowPositionY) {
        this.chatWindowPositionY = chatWindowPositionY;
        this.props.setProperty("chatPositionY", Integer.toString(chatWindowPositionY));
    }

    public boolean isChatFromBottom() {
        return this.chatFromBottom;
    }

    public void setChatFromBottom(boolean chatFromBottom) {
        this.chatFromBottom = chatFromBottom;
        this.props.setProperty("chatFromBottom", Boolean.toString(chatFromBottom));
    }

    public boolean isReverseScrolling() {
        return this.reverseScrolling;
    }

    public void setReverseScrolling(boolean reverseScrolling) {
        this.reverseScrolling = reverseScrolling;
        this.props.setProperty("reverseScrolling", Boolean.toString(reverseScrolling));
    }

    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
        this.props.setProperty("chatPixelWidth", Integer.toString(width));
    }

    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
        this.props.setProperty("chatPixelHeight", Integer.toString(height));
    }

    public Integer getWindowWidth() {
        return this.windowWidth;
    }

    public void setWindowWidth(Integer windowWidth) {
        this.windowWidth = windowWidth;
    }

    public Integer getWindowHeight() {
        return this.windowHeight;
    }

    public void setWindowHeight(Integer windowHeight) {
        this.windowHeight = windowHeight;
    }

    public boolean isAlwaysOnTop() {
        return this.alwaysOnTop;
    }

    public void setAlwaysOnTop(boolean alwaysOnTop) {
        this.alwaysOnTop = alwaysOnTop;
        this.props.setProperty("chatAlwaysOnTop", Boolean.toString(alwaysOnTop));
    }

    public boolean isAntiAlias() {
        return this.antiAlias;
    }

    public void setAntiAlias(boolean antiAlias) {
        this.antiAlias = antiAlias;
        this.props.setProperty("chatAntialias", Boolean.toString(antiAlias));
    }

    public Boolean isChromaEnabled() {
        return this.chromaEnabled;
    }

    public void setChromaEnabled(Boolean chromaEnabled) {
        this.chromaEnabled = chromaEnabled;
        this.props.setProperty("chromaEnabled", Boolean.toString(chromaEnabled));
    }

    public boolean isChromaInvert() {
        return this.chromaInvert;
    }

    public void setChromaInvert(boolean chromaInvert) {
        this.chromaInvert = chromaInvert;
        this.props.setProperty("invertChroma", Boolean.toString(chromaInvert));
    }

    public Rectangle getChromaBorder() {
        return this.chromaBorder;
    }

    public void setChromaBorder(int left, int top, int right, int bottom) {
        this.setChromaBorder(new Rectangle(left, top, right, bottom));
    }

    public void setChromaBorder(Rectangle chromaBorder) {
        this.chromaBorder = chromaBorder;
        this.props.setProperty("chromaLeft", Integer.toString(chromaBorder.x));
        this.props.setProperty("chromaTop", Integer.toString(chromaBorder.y));
        this.props.setProperty("chromaRight", Integer.toString(chromaBorder.width));
        this.props.setProperty("chromaBottom", Integer.toString(chromaBorder.height));
    }

    public int getChromaCornerRadius() {
        return this.chromaCornerRadius;
    }

    public void setChromaCornerRadius(int chromaCornerRadius) {
        this.chromaCornerRadius = chromaCornerRadius;
        this.props.setProperty("chromaCornerRadius", Integer.toString(chromaCornerRadius));
    }

    public void clearLegacyWindowSize() {
        this.windowWidth = null;
        this.windowHeight = null;
        this.props.remove("chatWidth");
        this.props.remove("chatHeight");
    }
}

