/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.config;

import com.glitchcog.fontificator.config.Config;
import com.glitchcog.fontificator.config.loadreport.LoadConfigReport;
import java.util.Properties;

public class ConfigCensor
extends Config {
    public static final int MIN_UNKNOWN_CHAR_PCT = 0;
    public static final int MAX_UNKNOWN_CHAR_PCT = 100;
    private Boolean censorshipEnabled;
    private Boolean purgeOnTwitchBan;
    private Boolean censorAllUrls;
    private Boolean censorFirstUrls;
    private Boolean censorUnknownChars;
    private Integer unknownCharsPercent;
    private String[] userWhitelist;
    private String[] userBlacklist;
    private String[] bannedWords;

    @Override
    public void reset() {
        this.censorshipEnabled = null;
        this.purgeOnTwitchBan = null;
        this.censorAllUrls = null;
        this.censorFirstUrls = null;
        this.censorUnknownChars = null;
        this.unknownCharsPercent = null;
        this.userWhitelist = null;
        this.userBlacklist = null;
    }

    public LoadConfigReport validateStrings(LoadConfigReport report, String enabledStr, String twitchPurgeStr, String urlStr, String firstUrlStr, String unknownCharStr, String unknownCharPctStr) {
        this.validateBooleanStrings(report, enabledStr, twitchPurgeStr, urlStr, firstUrlStr);
        this.validateIntegerWithLimitString("censorUnknownCharsPercent", unknownCharPctStr, 0, 100, report);
        return report;
    }

    @Override
    public LoadConfigReport load(Properties props, LoadConfigReport report) {
        this.props = props;
        this.reset();
        if (report.isErrorFree()) {
            String enabledStr = props.getProperty("censorEnabled");
            String twitchPurgeStr = props.getProperty("censorPurgeOnTwitchBan");
            String urlStr = props.getProperty("censorUrl");
            String firstUrlStr = props.getProperty("censorFirstUrl");
            String unknownCharStr = props.getProperty("censorUnknownChars");
            String unknownCharPctStr = props.getProperty("censorUnknownCharsPercent");
            String whiteStr = props.containsKey("censorWhitelist") ? props.getProperty("censorWhitelist") : "";
            String blackStr = props.containsKey("censorBlacklist") ? props.getProperty("censorBlacklist") : "";
            String bannedStr = props.containsKey("censorBannedWords") ? props.getProperty("censorBannedWords") : "";
            this.validateStrings(report, enabledStr, twitchPurgeStr, urlStr, firstUrlStr, unknownCharStr, unknownCharPctStr);
            if (report.isErrorFree()) {
                this.censorshipEnabled = this.evaluateBooleanString(props, "censorEnabled", report);
                this.purgeOnTwitchBan = this.evaluateBooleanString(props, "censorPurgeOnTwitchBan", report);
                this.censorAllUrls = this.evaluateBooleanString(props, "censorUrl", report);
                this.censorFirstUrls = this.evaluateBooleanString(props, "censorFirstUrl", report);
                this.censorUnknownChars = this.evaluateBooleanString(props, "censorUnknownChars", report);
                this.unknownCharsPercent = this.evaluateIntegerString(props, "censorUnknownCharsPercent", report);
                this.userWhitelist = whiteStr.split(",");
                this.userBlacklist = blackStr.split(",");
                this.bannedWords = bannedStr.split(",");
            }
        }
        return report;
    }

    public boolean isCensorshipEnabled() {
        return this.censorshipEnabled;
    }

    public void setCensorshipEnabled(Boolean censorshipEnabled) {
        this.censorshipEnabled = censorshipEnabled;
        this.props.setProperty("censorEnabled", Boolean.toString(censorshipEnabled));
    }

    public boolean isPurgeOnTwitchBan() {
        return this.purgeOnTwitchBan;
    }

    public void setPurgeOnTwitchBan(Boolean purgeOnTwitchBan) {
        this.purgeOnTwitchBan = purgeOnTwitchBan;
        this.props.setProperty("censorPurgeOnTwitchBan", Boolean.toString(purgeOnTwitchBan));
    }

    public boolean isCensorAllUrls() {
        return this.censorAllUrls;
    }

    public void setCensorAllUrls(Boolean censorAllUrls) {
        this.censorAllUrls = censorAllUrls;
        this.props.setProperty("censorUrl", Boolean.toString(censorAllUrls));
    }

    public boolean isCensorFirstUrls() {
        return this.censorFirstUrls;
    }

    public void setCensorFirstUrls(Boolean censorFirstUrls) {
        this.censorFirstUrls = censorFirstUrls;
        this.props.setProperty("censorFirstUrl", Boolean.toString(censorFirstUrls));
    }

    public boolean isCensorUnknownChars() {
        return this.censorUnknownChars;
    }

    public void setCensorUnknownChars(Boolean censorUnknownChars) {
        this.censorUnknownChars = censorUnknownChars;
        this.props.setProperty("censorUnknownChars", Boolean.toString(censorUnknownChars));
    }

    public int getUnknownCharPercentage() {
        return this.unknownCharsPercent;
    }

    public void setUnknownCharPercentage(Integer unknownCharsPercent) {
        this.unknownCharsPercent = unknownCharsPercent;
        this.props.setProperty("censorUnknownCharsPercent", Integer.toString(unknownCharsPercent));
    }

    public String[] getUserWhitelist() {
        return this.userWhitelist;
    }

    public void setUserWhitelist(String[] userWhitelist) {
        this.userWhitelist = userWhitelist;
        this.props.setProperty("censorWhitelist", this.getUserWhiteListString());
    }

    public String[] getUserBlacklist() {
        return this.userBlacklist;
    }

    public void setUserBlacklist(String[] userBlacklist) {
        this.userBlacklist = userBlacklist;
        this.props.setProperty("censorBlacklist", this.getUserBlackListString());
    }

    public String[] getBannedWords() {
        return this.bannedWords;
    }

    public void setBannedWords(String[] bannedWords) {
        this.bannedWords = bannedWords;
        this.props.setProperty("censorBlacklist", this.getBannedWordsString());
    }

    public String getUserWhiteListString() {
        return this.getListAsString(this.userWhitelist);
    }

    public String getUserBlackListString() {
        return this.getListAsString(this.userBlacklist);
    }

    public String getBannedWordsString() {
        return this.getListAsString(this.bannedWords);
    }

    private String getListAsString(String[] list) {
        String output = "";
        int i = 0;
        while (i < list.length) {
            output = String.valueOf(output) + (i == 0 ? "" : ",") + list[i];
            ++i;
        }
        return output;
    }
}

