/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.config;

import com.glitchcog.fontificator.config.loadreport.LoadConfigErrorType;
import com.glitchcog.fontificator.config.loadreport.LoadConfigReport;
import java.awt.Color;
import java.util.Properties;

public abstract class Config {
    protected Properties props;
    protected static final String[] TRUES = new String[]{Boolean.toString(true), "yes", "+", "t", "1"};
    protected static final String[] FALSES = new String[]{Boolean.toString(false), "no", "-", "f", "0"};

    public abstract LoadConfigReport load(Properties var1, LoadConfigReport var2);

    public abstract void reset();

    protected LoadConfigReport baseValidation(Properties props, String[] keys, LoadConfigReport report) {
        int i = 0;
        while (i < keys.length) {
            if (!props.containsKey(keys[i])) {
                report.addError("Key " + keys[i] + " missing in the configuration", LoadConfigErrorType.MISSING_KEY);
            } else if ((props.getProperty(keys[i]) == null || props.getProperty(keys[i]).trim().isEmpty()) && (!"fontUnknownChar".equals(keys[i]) && !"messageContentBreak".equals(keys[i]) || props.getProperty(keys[i]).isEmpty())) {
                report.addError("Value for key " + keys[i] + " missing in the configuration", LoadConfigErrorType.MISSING_VALUE);
            }
            ++i;
        }
        return report;
    }

    protected LoadConfigReport validateBooleanStrings(LoadConfigReport report, String ... booleans) {
        int i = 0;
        while (i < booleans.length) {
            this.evaluateBooleanString(booleans[i], report);
            ++i;
        }
        return report;
    }

    protected LoadConfigReport validateIntegerWithLimitString(String key, String value, int minimum, LoadConfigReport report) {
        return this.validateIntegerWithLimitString(key, value, minimum, Integer.MAX_VALUE, report);
    }

    protected LoadConfigReport validateIntegerWithLimitString(String key, String value, int minimum, int maximum, LoadConfigReport report) {
        this.validateIntegerString(key, value, report);
        if (report.isErrorFree()) {
            int test = Integer.parseInt(value);
            if (test < minimum) {
                report.addError("Value \"" + value + "\" for key \"" + key + "\" must be at least " + minimum, LoadConfigErrorType.VALUE_OUT_OF_RANGE);
            } else if (test > maximum) {
                report.addError("Value \"" + value + "\" for key \"" + key + "\" must be at most " + maximum, LoadConfigErrorType.VALUE_OUT_OF_RANGE);
            }
        }
        return report;
    }

    protected LoadConfigReport validateIntegerString(String key, String value, LoadConfigReport report) {
        if (value == null) {
            report.addError("Value missing for key \"" + key + "\"", LoadConfigErrorType.MISSING_VALUE);
        } else {
            try {
                Integer.parseInt(value);
            }
            catch (Exception e) {
                report.addError("Unable to parse the value \"" + value + "\" for key \"" + key + "\"", LoadConfigErrorType.PARSE_ERROR_INT);
            }
        }
        return report;
    }

    protected LoadConfigReport validateFloatWithLimitString(String key, String value, float minimum, float maximum, LoadConfigReport report) {
        this.validateFloatString(key, value, report);
        if (report.isErrorFree()) {
            float test = Float.parseFloat(value);
            if (test < minimum) {
                report.addError("Value \"" + value + "\" for key \"" + key + "\" must be at least " + minimum, LoadConfigErrorType.VALUE_OUT_OF_RANGE);
            } else if (test > maximum) {
                report.addError("Value \"" + value + "\" for key \"" + key + "\" must be at most " + maximum, LoadConfigErrorType.VALUE_OUT_OF_RANGE);
            }
        }
        return report;
    }

    protected LoadConfigReport validateFloatString(String key, String value, LoadConfigReport report) {
        if (value == null) {
            report.addError("Value missing for key \"" + key + "\"", LoadConfigErrorType.MISSING_VALUE);
        } else {
            try {
                Float.parseFloat(value);
            }
            catch (Exception e) {
                report.addError("Unable to parse the value \"" + value + "\" for key \"" + key + "\"", LoadConfigErrorType.PARSE_ERROR_FLOAT);
            }
        }
        return report;
    }

    protected Boolean evaluateBooleanString(String value, LoadConfigReport report) {
        Boolean result = null;
        int i = 0;
        while (i < TRUES.length) {
            if (TRUES[i].equalsIgnoreCase(value)) {
                return Boolean.TRUE;
            }
            ++i;
        }
        i = 0;
        while (i < FALSES.length) {
            if (FALSES[i].equalsIgnoreCase(value)) {
                return Boolean.FALSE;
            }
            ++i;
        }
        report.addError("Value \"" + value + "\" must be a boolean (true or false)", LoadConfigErrorType.PARSE_ERROR_BOOL);
        return result;
    }

    protected Boolean evaluateBooleanString(Properties props, String key, LoadConfigReport report) {
        Boolean result = null;
        if (props.containsKey(key)) {
            String value = props.getProperty(key);
            int i = 0;
            while (i < TRUES.length) {
                if (TRUES[i].equalsIgnoreCase(value)) {
                    return Boolean.TRUE;
                }
                ++i;
            }
            i = 0;
            while (i < FALSES.length) {
                if (FALSES[i].equalsIgnoreCase(value)) {
                    return Boolean.FALSE;
                }
                ++i;
            }
            report.addError("Value \"" + value + "\" for key \"" + key + "\" must be a boolean (true or false)", LoadConfigErrorType.PARSE_ERROR_BOOL);
        } else {
            report.addError("key \"" + key + "\" missing in the configuration", LoadConfigErrorType.MISSING_KEY);
        }
        return result;
    }

    protected Integer evaluateIntegerString(Properties props, String key, LoadConfigReport report) {
        Integer result = null;
        if (props.containsKey(key)) {
            String value = props.getProperty(key);
            try {
                result = Integer.parseInt(value);
            }
            catch (Exception e) {
                report.addError("Value \"" + value + "\" for key \"" + key + "\" must be an integer", LoadConfigErrorType.PARSE_ERROR_INT);
            }
        }
        return result;
    }

    protected Color evaluateColorString(Properties props, String key, LoadConfigReport report) {
        String hexString = props.getProperty(key);
        Color result = this.evaluateColorString(hexString, report);
        return result;
    }

    protected Color evaluateColorString(String hexString, LoadConfigReport report) {
        try {
            return new Color(Integer.parseInt(hexString, 16));
        }
        catch (Exception e) {
            report.addError("Color value \"" + hexString + "\" is invalid", LoadConfigErrorType.PARSE_ERROR_COLOR);
            return null;
        }
    }
}

