/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.bot;

import com.glitchcog.fontificator.bot.EmoteAndIndices;
import com.glitchcog.fontificator.bot.MessageType;
import com.glitchcog.fontificator.bot.TwitchPrivmsg;
import com.glitchcog.fontificator.bot.UserType;
import com.glitchcog.fontificator.config.ConfigEmoji;
import com.glitchcog.fontificator.config.ConfigMessage;
import com.glitchcog.fontificator.config.MessageCasing;
import com.glitchcog.fontificator.emoji.EmojiManager;
import com.glitchcog.fontificator.emoji.EmojiType;
import com.glitchcog.fontificator.emoji.LazyLoadEmoji;
import com.glitchcog.fontificator.emoji.TypedEmojiMap;
import com.glitchcog.fontificator.sprite.SpriteCharacterKey;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class Message {
    private static final Logger logger = Logger.getLogger(Message.class);
    private static final long UNCOMPLETED_TIME = 0L;
    public static final String SPACE_BOUNDARY_REGEX = "(?:(?=\\s+)(?<!\\s+)|(?<=\\s+)(?!\\s+))";
    private static final String TWITTER_EMOJI_REGEX = "((([\ud83c\udf00-\ud83d\uddff]|[\ud83d\ude00-\ud83d\ude4f]|[\ud83d\ude80-\ud83d\udeff]|[\u2600-\u26ff]|[\u2700-\u27bf])[\\x{1F3FB}-\\x{1F3FF}]?))";
    private static final Pattern TWITTER_EMOJI_PATTERN = Pattern.compile("((([\ud83c\udf00-\ud83d\uddff]|[\ud83d\ude00-\ud83d\ude4f]|[\ud83d\ude80-\ud83d\udeff]|[\u2600-\u26ff]|[\u2700-\u27bf])[\\x{1F3FB}-\\x{1F3FF}]?))");
    private final TwitchPrivmsg privmsg;
    private boolean censored;
    private boolean purged;
    private String censoredReason;
    private boolean manualCensorship;
    private final String rawUsername;
    private final Date timestamp;
    private final String content;
    private final MessageType type;
    private Map<String, LazyLoadEmoji> badges;
    private SpriteCharacterKey[] text;
    private static final String TIMESTAMP_USERNAME_SPACER = " ";
    private static final float MAX_INT_AS_FLOAT = 2.1474836E9f;
    private float drawCursor;
    private ConfigMessage lastMessageConfig;
    private ConfigEmoji lastEmojiConfig;
    private long completedTime;

    public Message(MessageType type, String rawUsername, String content, TwitchPrivmsg privmsg) {
        this(type, rawUsername, new Date(), content, privmsg);
    }

    public Message(MessageType type, String rawUsername, Date timestamp, String content, TwitchPrivmsg privmsg) {
        this.type = type;
        this.rawUsername = rawUsername;
        this.timestamp = timestamp;
        this.content = content;
        this.drawCursor = 0.0f;
        this.lastMessageConfig = new ConfigMessage();
        this.lastEmojiConfig = new ConfigEmoji();
        this.privmsg = privmsg;
        this.completedTime = 0L;
    }

    public boolean isJoinType() {
        return MessageType.JOIN.equals((Object)this.type);
    }

    public MessageType getType() {
        return this.type;
    }

    public String getUsername() {
        return this.rawUsername;
    }

    public void incrementDrawCursor(EmojiManager emojiManager, ConfigMessage messageConfig, ConfigEmoji emojiConfig) {
        float characterCount = 1.0f;
        if (messageConfig.getMessageSpeed() < 1) {
            characterCount = 2.1474836E9f;
        } else if (1000L / (long)messageConfig.getMessageSpeed() < 67L) {
            characterCount = (float)messageConfig.getMessageSpeed() * 67.0f / 1000.0f;
        }
        this.drawCursor += characterCount;
        if (this.drawCursor >= (float)this.getMessageLength(emojiManager, messageConfig, emojiConfig)) {
            this.completedTime = System.currentTimeMillis();
        }
    }

    public int getMessageLength(EmojiManager emojiManager, ConfigMessage messageConfig, ConfigEmoji emojiConfig) {
        return this.getText(emojiManager, messageConfig, emojiConfig).length;
    }

    public float getDrawCursor() {
        return this.isCompletelyDrawn() ? 2.1474836E9f : this.drawCursor;
    }

    public boolean isCompletelyDrawn() {
        return this.completedTime != 0L;
    }

    public void setCompletelyDrawn() {
        this.drawCursor = 2.1474836E9f;
        this.completedTime = System.currentTimeMillis();
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String getTimestampString(ConfigMessage messageConfig) {
        return messageConfig.getTimerFormatter().format(this.timestamp);
    }

    public String getContent() {
        return this.content;
    }

    public String toString() {
        return String.valueOf(this.rawUsername) + ": " + this.content;
    }

    public int getIndexTimestamp(ConfigMessage messageConfig) {
        return messageConfig.showTimestamps() ? this.getTimestampString(messageConfig).length() : 0;
    }

    public int[] getIndexUsername(ConfigMessage messageConfig) {
        int start;
        int n = start = this.badges == null ? 0 : this.badges.size();
        if (messageConfig.showTimestamps()) {
            start += this.getIndexTimestamp(messageConfig);
        }
        if (messageConfig.showUsernames()) {
            String usernameFormat;
            if (messageConfig.showTimestamps()) {
                start += TIMESTAMP_USERNAME_SPACER.length();
            }
            if ((usernameFormat = messageConfig.getUsernameFormat()).indexOf("%user%") > 0) {
                int distanceIntoFormat = usernameFormat.indexOf("%user%");
                start += distanceIntoFormat;
            }
            int end = start;
            return new int[]{start, end += this.rawUsername.length()};
        }
        return new int[]{start, start};
    }

    public SpriteCharacterKey[] getText(EmojiManager emojiManager, ConfigMessage messageConfig, ConfigEmoji emojiConfig) {
        if (this.text != null && !this.isConfigChanged(messageConfig, emojiConfig)) {
            return this.text;
        }
        this.text = this.parseIntoText(emojiManager, messageConfig, emojiConfig);
        this.lastMessageConfig.deepCopy(messageConfig);
        this.lastEmojiConfig.deepCopy(emojiConfig);
        return this.text;
    }

    private boolean isConfigChanged(ConfigMessage messageConfig, ConfigEmoji emojiConfig) {
        boolean emojiConfigChanged;
        boolean messageConfigChanged = !messageConfig.equals(this.lastMessageConfig);
        boolean bl = emojiConfigChanged = !emojiConfig.equals(this.lastEmojiConfig);
        return messageConfigChanged || emojiConfigChanged;
    }

    private SpriteCharacterKey[] parseIntoText(EmojiManager emojiManager, ConfigMessage messageConfig, ConfigEmoji emojiConfig) {
        ArrayList<SpriteCharacterKey> keyList = new ArrayList<SpriteCharacterKey>();
        if (messageConfig.showTimestamps()) {
            String timeStampStr = messageConfig.getTimerFormatter().format(this.timestamp);
            timeStampStr = Message.applyCasing(timeStampStr, messageConfig.getMessageCasing());
            keyList.addAll(Message.toSpriteArray(timeStampStr));
        }
        if (emojiConfig.isAnyBadgesEnabled()) {
            this.badges = new LinkedHashMap<String, LazyLoadEmoji>();
            boolean userIsModerator = this.privmsg.getUserType() == UserType.MOD;
            TypedEmojiMap twitchBadgeBank = emojiManager.getEmojiByType(EmojiType.TWITCH_BADGE);
            TypedEmojiMap ffzBadgeBank = emojiManager.getEmojiByType(EmojiType.FRANKERFACEZ_BADGE);
            if (this.privmsg.getUserType() != null && this.privmsg.getUserType() != UserType.NONE) {
                LazyLoadEmoji testBadge;
                if (emojiConfig.isFfzBadgesEnabled() && userIsModerator && ffzBadgeBank.getEmoji(UserType.MOD.getKey()) != null) {
                    this.badges.put(UserType.MOD.getKey(), ffzBadgeBank.getEmoji(UserType.MOD.getKey()));
                } else if (emojiConfig.isTwitchBadgesEnabled() && (testBadge = twitchBadgeBank.getEmoji(this.privmsg.getUserType().getKey())) != null) {
                    this.badges.put(this.privmsg.getUserType().getKey(), testBadge);
                }
            }
            LazyLoadEmoji replacementBadge = null;
            if (emojiConfig.isFfzBadgesEnabled()) {
                Map<Integer, Set<String>> ffzBadgeUsers = emojiManager.getFfzBadgeUsers();
                for (Integer ffzBadgeType : ffzBadgeUsers.keySet()) {
                    String ffzBadgeKey = ffzBadgeType == null ? null : Integer.toString(ffzBadgeType);
                    Set<String> users = ffzBadgeUsers.get(ffzBadgeType);
                    if (!users.contains(this.rawUsername.toLowerCase())) continue;
                    LazyLoadEmoji ffzBadge = ffzBadgeBank.getEmoji(ffzBadgeType);
                    if (ffzBadge.isReplacement() && this.badges.containsKey(ffzBadge.getReplaces())) {
                        this.badges.put(ffzBadge.getReplaces(), ffzBadge);
                        if (!userIsModerator) continue;
                        replacementBadge = ffzBadge;
                        continue;
                    }
                    this.badges.put(ffzBadgeKey, ffzBadge);
                }
            }
            if (emojiConfig.isTwitchBadgesEnabled()) {
                String subStr = "subscriber";
                if (this.privmsg.isSubscriber() && twitchBadgeBank.getEmoji("subscriber") != null) {
                    this.badges.put("subscriber", twitchBadgeBank.getEmoji("subscriber"));
                }
            }
            String turboStr = "turbo";
            if (emojiConfig.isTwitchBadgesEnabled() && this.privmsg.isTurbo() && twitchBadgeBank.getEmoji("turbo") != null) {
                this.badges.put("turbo", twitchBadgeBank.getEmoji("turbo"));
            }
            String primeStr = "prime";
            if (emojiConfig.isTwitchBadgesEnabled() && this.privmsg.isPrime() && twitchBadgeBank.getEmoji("prime") != null) {
                this.badges.put("prime", twitchBadgeBank.getEmoji("prime"));
            }
            for (LazyLoadEmoji lle : this.badges.values()) {
                SpriteCharacterKey sck = new SpriteCharacterKey(lle, true);
                if (userIsModerator && lle == replacementBadge) {
                    sck.setEmojiBgColorOverride(ConfigEmoji.MOD_BADGE_COLOR);
                }
                keyList.add(sck);
            }
        }
        if (messageConfig.showUsernames()) {
            if (messageConfig.showTimestamps()) {
                keyList.addAll(Message.toSpriteArray(TIMESTAMP_USERNAME_SPACER));
            }
            String casedUsername = this.getFormattedUsername(messageConfig);
            keyList.addAll(Message.toSpriteArray(casedUsername));
        }
        if (messageConfig.showUsernames() || messageConfig.showTimestamps() || emojiConfig.isAnyBadgesEnabled() && this.badges != null && !this.badges.isEmpty()) {
            if (this.type == MessageType.NORMAL || this.type == MessageType.MANUAL) {
                keyList.addAll(Message.toSpriteArray(messageConfig.getContentBreaker()));
            } else {
                keyList.addAll(Message.toSpriteArray(this.type.getContentBreaker()));
            }
        }
        if (emojiConfig.isEmojiEnabled()) {
            Message.processEmoji(this.content, this.privmsg, keyList, emojiManager, emojiConfig, MessageType.MANUAL.equals((Object)this.type), messageConfig.getMessageCasing());
        } else {
            keyList.addAll(Message.toSpriteArray(Message.applyCasing(this.content, messageConfig.getMessageCasing())));
        }
        return keyList.toArray(new SpriteCharacterKey[keyList.size()]);
    }

    private static String[] codePointSpaceSplit(String content) {
        ArrayList<String> words = new ArrayList<String>();
        if (!content.isEmpty()) {
            int breakIndex = 0;
            int c = 0;
            boolean currentlyInWord = !Character.isWhitespace(content.codePointAt(c));
            while (c < content.length()) {
                int codePoint = content.codePointAt(c);
                boolean isWhitespace = Character.isWhitespace(codePoint);
                int charSize = Character.charCount(codePoint);
                if (currentlyInWord && isWhitespace || !currentlyInWord && !isWhitespace) {
                    words.add(content.substring(breakIndex, c));
                    breakIndex = c;
                    currentlyInWord = !currentlyInWord;
                }
                c += charSize;
            }
            words.add(content.substring(breakIndex, content.length()));
        }
        return words.toArray(new String[words.size()]);
    }

    private static void processEmoji(String content, TwitchPrivmsg privmsg, List<SpriteCharacterKey> keyList, EmojiManager emojiManager, ConfigEmoji emojiConfig, boolean isManualMessage, MessageCasing casing) {
        Map<Integer, EmoteAndIndices> emotes = privmsg.getEmotes();
        String[] words = Message.codePointSpaceSplit(content);
        int codeIndex = 0;
        LazyLoadEmoji emoji = null;
        int w = 0;
        while (w < words.length) {
            EmoteAndIndices eai = emotes.get(codeIndex);
            if (eai != null && emojiConfig.isTwitchEnabled()) {
                emoji = emojiManager.getEmojiById(eai.getEmoteId(), words[w], emojiConfig);
                if (emoji == null) {
                    try {
                        emoji = emojiManager.putEmojiById(eai.getEmoteId(), words[w], emojiConfig);
                    }
                    catch (MalformedURLException e) {
                        logger.error("Unable to load emote for emote ID " + eai.getEmoteId(), e);
                    }
                }
            } else {
                emoji = isManualMessage ? emojiManager.getEmojiWords(EmojiType.MANUAL_EMOJI_TYPES, words[w], emojiConfig) : emojiManager.getEmojiWords(EmojiType.THIRD_PARTY_EMOJI_TYPES, words[w], emojiConfig);
            }
            if (emoji == null) {
                Matcher matcher = TWITTER_EMOJI_PATTERN.matcher(words[w]);
                if (emojiConfig.isTwitterEnabled() && matcher.find()) {
                    matcher.reset();
                    String twitterEmojiUrl = null;
                    int i = 0;
                    while (matcher.find()) {
                        String rawCode = matcher.group(2);
                        String iconId = Message.toCodePoint(rawCode.indexOf(8205) < 0 ? rawCode.replace("\ufe0f", "") : rawCode);
                        twitterEmojiUrl = "https://twemoji.maxcdn.com/2/72x72/" + iconId + ".png";
                        LazyLoadEmoji lle = emojiManager.getEmojiByType(EmojiType.TWITTER_EMOJI).getEmoji(iconId);
                        if (lle == null) {
                            try {
                                lle = new LazyLoadEmoji(iconId, twitterEmojiUrl, EmojiType.TWITTER_EMOJI);
                                emojiManager.getEmojiByType(EmojiType.TWITTER_EMOJI).put(iconId, lle);
                            }
                            catch (MalformedURLException e) {
                                logger.error("Couldn't parse emoji URL: " + twitterEmojiUrl, e);
                            }
                        }
                        String wordBit = words[w].substring(i, matcher.start());
                        keyList.addAll(Message.toSpriteArray(Message.applyCasing(wordBit, casing)));
                        if (lle != null) {
                            keyList.add(new SpriteCharacterKey(lle, false));
                        }
                        i = matcher.end();
                    }
                    String wordBit = words[w].substring(i, words[w].length());
                    keyList.addAll(Message.toSpriteArray(Message.applyCasing(wordBit, casing)));
                } else {
                    keyList.addAll(Message.toSpriteArray(Message.applyCasing(words[w], casing)));
                }
            }
            if (emoji != null) {
                keyList.add(new SpriteCharacterKey(emoji, false));
            }
            codeIndex += words[w].codePointCount(0, words[w].length());
            ++w;
        }
    }

    private static String toCodePoint(String unicodeSurrogates) {
        ArrayList<String> r = new ArrayList<String>();
        char c = '\u0000';
        int p = 0;
        int i = 0;
        while (i < unicodeSurrogates.length()) {
            c = unicodeSurrogates.charAt(i++);
            if (p != 0) {
                r.add(Integer.toString(65536 + (p - 55296 << 10) + (c - 56320), 16));
                p = 0;
                continue;
            }
            if ('\ud800' <= c && c <= '\udbff') {
                p = c;
                continue;
            }
            r.add(Integer.toString(c, 16));
        }
        String output = "";
        for (String str : r) {
            output = String.valueOf(output) + (output.isEmpty() ? "" : "-") + str;
        }
        return output;
    }

    public String getCensoredReason() {
        return this.censoredReason;
    }

    public void setCensoredReason(String censoredReason) {
        this.censoredReason = censoredReason;
    }

    public boolean isCensored() {
        return this.censored;
    }

    public void setCensored(boolean censored, boolean isCensorshipEnabled) {
        if (censored && isCensorshipEnabled) {
            this.setCompletelyDrawn();
        }
        this.censored = censored;
    }

    public void setPurged(boolean purged) {
        this.purged = purged;
    }

    public void resetCensorship(boolean overrideManual) {
        if (!(this.purged || this.manualCensorship && !overrideManual)) {
            this.manualCensorship = false;
            this.censored = false;
            this.censoredReason = null;
        }
    }

    public boolean isManualCensorship() {
        return this.manualCensorship;
    }

    public void setManualCensorship(boolean manualCensorship) {
        this.manualCensorship = manualCensorship;
        this.censoredReason = "MANUAL";
    }

    public int getUserPostCount() {
        return this.privmsg.getPostCount();
    }

    public TwitchPrivmsg getPrivmsg() {
        return this.privmsg;
    }

    public long getAge(long currentTime) {
        return this.completedTime == 0L ? 0L : (currentTime - this.completedTime) / 1000L;
    }

    private static String applyCasing(String str, MessageCasing casing) {
        if (casing == null) {
            return null;
        }
        switch (casing) {
            case LOWERCASE: {
                return str.toLowerCase();
            }
            case UPPERCASE: {
                return str.toUpperCase();
            }
        }
        return str;
    }

    private static List<SpriteCharacterKey> toSpriteArray(String str) {
        ArrayList<SpriteCharacterKey> keyList = new ArrayList<SpriteCharacterKey>();
        int i = 0;
        while (i < str.length()) {
            int codepoint = str.codePointAt(i);
            keyList.add(new SpriteCharacterKey(codepoint));
            i += Character.charCount(codepoint);
        }
        return keyList;
    }

    private String getFormattedUsername(ConfigMessage messageConfig) {
        String usernameFormat = messageConfig.getUsernameFormat();
        String casedUsername = Message.applyCasing(this.rawUsername, messageConfig.getMessageCasing());
        String formattedUsername = usernameFormat.replaceAll("%user%", casedUsername);
        return formattedUsername;
    }
}

