/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator.bot;

import com.glitchcog.fontificator.bot.EmoteAndIndices;
import com.glitchcog.fontificator.bot.Message;
import com.glitchcog.fontificator.bot.MessageType;
import com.glitchcog.fontificator.bot.TwitchPrivmsg;
import com.glitchcog.fontificator.bot.UserType;
import com.glitchcog.fontificator.config.ConfigMessage;
import com.glitchcog.fontificator.gui.chat.ChatPanel;
import com.glitchcog.fontificator.gui.controls.panel.ControlPanelIrc;
import com.google.gson.Gson;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.jibble.pircbot.PircBot;

public class ChatViewerBot
extends PircBot {
    private static final Logger logger = Logger.getLogger(ChatViewerBot.class);
    private static final String POST_SEPARATOR = " :";
    private static final String CTCP_INDICATOR = Character.toString('\u0001');
    private static final String USERNAME_LOOKUP_BASE_URL = "https://api.twitch.tv/kraken/users/";
    private boolean disconnectExpected;
    private ChatPanel chat;
    private ControlPanelIrc controlPanel;
    private ConfigMessage messageConfig;
    private Map<String, String> usernameCases = new HashMap<String, String>();
    private Map<String, String> usernameIds = new HashMap<String, String>();
    private Map<String, TwitchPrivmsg> privmsgs = new HashMap<String, TwitchPrivmsg>();
    private static final String TWITCH_CAP_MESSAGE = ":tmi.twitch.tv CAP * ACK :twitch.tv/";
    private static final String PING_MESSAGE = "PING ";

    public void debug(String filename) throws Exception {
        String line;
        File f = new File(filename);
        BufferedReader br = new BufferedReader(new FileReader(f));
        while ((line = br.readLine()) != null) {
            this.onUnknown(line);
        }
        br.close();
    }

    public ChatViewerBot() {
        String encoding = "UTF-8";
        try {
            this.setEncoding("UTF-8");
            logger.debug("IRC encoding set to UTF-8");
        }
        catch (Exception e) {
            logger.error("Unable to set IRC encoding to UTF-8", e);
        }
    }

    public void reset() {
        for (TwitchPrivmsg state : this.privmsgs.values()) {
            state.resetPostCount();
        }
        this.usernameCases.clear();
    }

    @Override
    public void log(String line) {
        this.controlPanel.log(line);
    }

    public void clearUsernameCases() {
        this.usernameCases.clear();
    }

    public void setChatPanel(ChatPanel chat) {
        this.chat = chat;
    }

    public void setUsername(String name) {
        if (!this.isConnected()) {
            super.setName(name);
        }
    }

    @Override
    protected void onConnect() {
        this.disconnectExpected = false;
        logger.info("Connected");
        this.controlPanel.toggleConnect(true);
        this.sendRawLine("CAP REQ :twitch.tv/membership");
        this.sendRawLine("CAP REQ :twitch.tv/tags");
        this.sendRawLine("CAP REQ :twitch.tv/commands");
    }

    @Override
    protected void onJoin(String channel, String sender, String login, String hostname) {
        TwitchPrivmsg privmsg = this.getPrivmsg(sender);
        this.sendMessageToChat(MessageType.JOIN, "joined " + channel + ".", privmsg);
    }

    @Override
    protected void onAction(String sender, String login, String hostname, String target, String action) {
        TwitchPrivmsg privmsg = this.getPrivmsg(sender);
        this.sendMessageToChat(MessageType.ACTION, action, privmsg);
    }

    @Override
    protected void handleLine(String response) {
        if (response == null) {
            return;
        }
        if (response.startsWith(TWITCH_CAP_MESSAGE)) {
            return;
        }
        if (response.startsWith(PING_MESSAGE)) {
            this.sendRawLine("PONG " + response.substring(PING_MESSAGE.length()));
        } else if (response.startsWith("@")) {
            if (response.startsWith("@ban")) {
                try {
                    String banDuration;
                    int firstBreak = response.indexOf(POST_SEPARATOR);
                    int secondBreak = response.indexOf(POST_SEPARATOR, firstBreak + POST_SEPARATOR.length());
                    Map<String, String> params = this.parseMessageParams(response, firstBreak, secondBreak);
                    String bannedUserId = params.get("target-user-id");
                    String bannedUsername = this.usernameIds.get(bannedUserId);
                    String bannedReason = params.get("ban-reason");
                    if (bannedReason == null || bannedReason.trim().isEmpty()) {
                        bannedReason = "TWITCH PURGE";
                    }
                    if ((banDuration = params.get("ban-duration")) != null && banDuration.trim().isEmpty()) {
                        banDuration = null;
                    }
                    this.chat.purgeMessagesForUser(bannedUsername, String.valueOf(bannedReason) + (banDuration == null ? "" : " FOR " + banDuration + " ms"));
                }
                catch (Exception e) {
                    this.log("Unparsable ban: " + response);
                }
            } else {
                try {
                    TwitchPrivmsg privmsg = this.parseRawTwitchMessage(response);
                    String message = response.substring(response.indexOf(POST_SEPARATOR, response.indexOf(POST_SEPARATOR) + POST_SEPARATOR.length()) + POST_SEPARATOR.length());
                    if (message.startsWith(CTCP_INDICATOR)) {
                        if ((message = message.substring(CTCP_INDICATOR.length())).endsWith(CTCP_INDICATOR)) {
                            message = message.substring(0, message.length() - 1);
                        }
                        String commandSplit = " ";
                        if (message.contains(" ")) {
                            String command = message.substring(0, message.indexOf(" "));
                            message = message.substring(message.indexOf(" ") + " ".length());
                            if ("ACTION".equals(command)) {
                                this.sendMessageToChat(MessageType.ACTION, message, privmsg);
                            } else {
                                this.log("Unknown CTCP command: " + command);
                            }
                        } else {
                            this.log("CTCP message missing command type: " + message);
                        }
                    } else if (privmsg.isDisplayMessage()) {
                        this.sendMessageToChat(MessageType.NORMAL, message, privmsg);
                    }
                }
                catch (Exception e) {
                    this.log("Unparsable message: " + response);
                }
            }
        } else {
            this.log(response);
        }
    }

    private TwitchPrivmsg getPrivmsg(String sender) {
        TwitchPrivmsg privmsg = this.privmsgs.get(sender.toLowerCase());
        if (privmsg == null) {
            privmsg = new TwitchPrivmsg(sender);
            this.privmsgs.put(sender.toLowerCase(), privmsg);
        }
        return privmsg;
    }

    private TwitchPrivmsg parseRawTwitchMessage(String rawMessage) {
        String turboStr;
        String subStr;
        String emotesStr;
        String displayName;
        TwitchPrivmsg privmsg = new TwitchPrivmsg();
        int firstBreak = rawMessage.indexOf(POST_SEPARATOR);
        int secondBreak = rawMessage.indexOf(POST_SEPARATOR, firstBreak + POST_SEPARATOR.length());
        Map<String, String> paramMap = this.parseMessageParams(rawMessage, firstBreak, secondBreak);
        String messageClassification = null;
        try {
            String mc = rawMessage.substring(firstBreak, secondBreak).trim();
            messageClassification = mc.split(" ")[1].trim();
        }
        catch (Exception e) {
            logger.debug("Unable to determine message classification for " + rawMessage, e);
            messageClassification = null;
        }
        privmsg.setMessageClassification(messageClassification);
        String colorStr = paramMap.get("color");
        if (colorStr != null && !colorStr.trim().isEmpty()) {
            try {
                String hexString = colorStr.substring((colorStr.startsWith("#") ? 1 : 0) + (colorStr.startsWith("0x") ? 2 : 0));
                Color color = new Color(Integer.parseInt(hexString, 16));
                privmsg.setColor(color);
            }
            catch (Exception e) {
                logger.trace("Unable to parse color from Twitch", e);
            }
        }
        if ((displayName = paramMap.get("display-name")) != null && !displayName.trim().isEmpty()) {
            privmsg.setDisplayName(displayName);
            String userIdStr = paramMap.get("user-id");
            if (userIdStr != null) {
                this.usernameIds.put(userIdStr, displayName.toLowerCase());
            }
        }
        if ((emotesStr = paramMap.get("emotes")) != null && !emotesStr.trim().isEmpty()) {
            try {
                String[] stringArray = emotesStr.split("/");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String eaiStr = stringArray[n2];
                    String[] idIndexSplit = eaiStr.split(":");
                    Integer emoteId = "null".equals(idIndexSplit[0]) ? null : Integer.valueOf(Integer.parseInt(idIndexSplit[0]));
                    String indices = idIndexSplit[1];
                    String[] indicesStr = indices.split(",");
                    int i = 0;
                    while (i < indicesStr.length) {
                        String[] begEndSplit = indicesStr[i].split("-");
                        int beg = Integer.parseInt(begEndSplit[0]);
                        int end = Integer.parseInt(begEndSplit[1]);
                        EmoteAndIndices eai = new EmoteAndIndices(emoteId, beg, end);
                        privmsg.addEmote(eai);
                        ++i;
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                logger.error("Something went wrong parsing the message emote data: " + emotesStr, e);
            }
        }
        if ((subStr = paramMap.get("subscriber")) != null && !subStr.trim().isEmpty()) {
            try {
                int subVal = Integer.parseInt(subStr);
                privmsg.setSubscriber(subVal > 0);
            }
            catch (Exception e) {
                this.log("Error parsing subscriber value \"" + subStr + "\" in Twitch header");
            }
        }
        if ((turboStr = paramMap.get("turbo")) != null && !turboStr.trim().isEmpty()) {
            try {
                int turboVal = Integer.parseInt(turboStr);
                privmsg.setTurbo(turboVal > 0);
            }
            catch (Exception e) {
                this.log("Error parsing subscriber value \"" + turboStr + "\" in Twitch header");
            }
        }
        privmsg.setPrime(paramMap.get("badges") != null && paramMap.get("badges").contains("premium"));
        String userTypeStr = paramMap.get("user-type");
        if (displayName != null && !displayName.trim().isEmpty() && displayName.equalsIgnoreCase(this.controlPanel.getChannelNoHash())) {
            privmsg.setUserType(UserType.BROADCASTER);
        } else if (userTypeStr != null && !userTypeStr.trim().isEmpty()) {
            privmsg.setUserType(UserType.getByKey(userTypeStr));
        }
        String prefix = rawMessage.substring(firstBreak + POST_SEPARATOR.length(), secondBreak);
        if (displayName == null || displayName.trim().isEmpty()) {
            privmsg.setDisplayName(prefix.substring(0, prefix.indexOf("!")));
        }
        return privmsg;
    }

    private Map<String, String> parseMessageParams(String rawMessage, int firstBreak, int secondBreak) {
        int startIndex = rawMessage.length() > 1 && rawMessage.charAt(0) == '@' ? 1 : 0;
        String[] params = rawMessage.substring(startIndex, firstBreak).split(";");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String paramSplitter = "=";
        int i = 0;
        while (i < params.length) {
            String[] paramHalves = params[i].split("=");
            String key = paramHalves[0];
            String value = "";
            int v = 1;
            while (v < paramHalves.length) {
                value = String.valueOf(value) + paramHalves[v] + (v > 1 ? "=" : "");
                ++v;
            }
            paramMap.put(key, value);
            ++i;
        }
        return paramMap;
    }

    private TwitchPrivmsg getPrivmsg(String sender, String rawMessage) {
        TwitchPrivmsg privmsg = this.privmsgs.get((sender = sender == null ? null : sender.toLowerCase()).toLowerCase());
        if (privmsg == null) {
            privmsg = new TwitchPrivmsg(sender);
            this.privmsgs.put(sender.toLowerCase(), privmsg);
        }
        return privmsg;
    }

    @Override
    protected void onMessage(String channel, String sender, String login, String hostname, String message) {
        TwitchPrivmsg privmsg = this.getPrivmsg(sender, null);
        this.sendMessageToChat(message, privmsg);
    }

    public void sendMessageToChat(String message, TwitchPrivmsg privmsg) {
        this.sendMessageToChat(MessageType.NORMAL, message, privmsg);
    }

    public void sendMessageToChat(MessageType type, String message, TwitchPrivmsg privmsg) {
        String casedUsername = this.handleUsernameCasing(type, privmsg.getDisplayName(), message);
        privmsg.setDisplayName(casedUsername);
        privmsg.incrementPostCount();
        Message msg = new Message(type, casedUsername, message, privmsg);
        this.chat.addMessage(msg);
    }

    private String handleUsernameCasing(MessageType type, String username, String message) {
        String casedUsername = username;
        String lowerCaseUsername = username.toLowerCase();
        if (type != MessageType.JOIN) {
            Pattern pat;
            Matcher mtch;
            if (this.messageConfig.isSpecifyCaseAllowed().booleanValue() && message.toLowerCase().contains(lowerCaseUsername) && (mtch = (pat = Pattern.compile("\\b" + lowerCaseUsername + "\\b")).matcher(message.toLowerCase())).find()) {
                int usernameIndex = message.toLowerCase().indexOf(lowerCaseUsername);
                casedUsername = message.substring(usernameIndex, usernameIndex + username.length());
                this.usernameCases.put(lowerCaseUsername, casedUsername);
            }
            if (!this.usernameCases.containsKey(lowerCaseUsername)) {
                switch (this.messageConfig.getCaseResolutionType()) {
                    case ALL_CAPS: {
                        casedUsername = username.toUpperCase();
                        break;
                    }
                    case ALL_LOWERCASE: {
                        casedUsername = lowerCaseUsername;
                        break;
                    }
                    case FIRST: {
                        casedUsername = String.valueOf(username.substring(0, 1).toUpperCase()) + username.substring(1).toLowerCase();
                        break;
                    }
                    case LOOKUP: {
                        if (!type.containsParsableUsername()) break;
                        try {
                            String line;
                            URL url = new URL(USERNAME_LOOKUP_BASE_URL + lowerCaseUsername);
                            URLConnection conn = url.openConnection();
                            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                            String jsonResult = "";
                            while ((line = br.readLine()) != null) {
                                jsonResult = String.valueOf(jsonResult) + line;
                            }
                            br.close();
                            casedUsername = (String)new Gson().fromJson(jsonResult, Map.class).get("display_name");
                        }
                        catch (Exception e) {
                            logger.debug("Attempt to look up " + username + " on Twitch API failed.");
                        }
                        break;
                    }
                    default: {
                        casedUsername = username;
                    }
                }
                this.usernameCases.put(lowerCaseUsername, casedUsername);
            }
            if (this.usernameCases.containsKey(lowerCaseUsername)) {
                casedUsername = this.usernameCases.get(lowerCaseUsername);
            }
        }
        return casedUsername;
    }

    @Override
    protected void onPrivateMessage(String sender, String login, String hostname, String message) {
        logger.info("Private message from " + sender + "(" + login + "@" + hostname + "): " + message);
    }

    @Override
    protected void onSetChannelBan(String channel, String sourceNick, String sourceLogin, String sourceHostname, String hostmask) {
        this.chat.banUser(hostmask);
    }

    @Override
    protected void onRemoveChannelBan(String channel, String sourceNick, String sourceLogin, String sourceHostname, String hostmask) {
        this.chat.unbanUser(hostmask);
    }

    @Override
    protected void onDisconnect() {
        logger.info("Disconnected");
        this.controlPanel.toggleConnect(false);
        while (!this.disconnectExpected && this.controlPanel.isAutoReconnect() && !this.isConnected()) {
            try {
                logger.info("Attempting to reconnect");
                this.reconnect();
                logger.info("Attempting to rejoin channel");
                this.controlPanel.joinChannel();
            }
            catch (Exception e) {
                logger.error("Error reconnecting", e);
            }
            try {
                Thread.sleep(250L);
            }
            catch (Exception e) {
                logger.trace("Reconnect attempt sleep exception");
            }
        }
        this.disconnectExpected = false;
    }

    public void setControlPanel(ControlPanelIrc controlPanel) {
        this.controlPanel = controlPanel;
    }

    public void setMessageConfig(ConfigMessage messageConfig) {
        this.messageConfig = messageConfig;
    }

    public void setDisconnectExpected(boolean disconnectExpected) {
        this.disconnectExpected = disconnectExpected;
    }
}

