/*
 * Decompiled with CFR 0.152.
 */
package com.glitchcog.fontificator;

import com.glitchcog.fontificator.config.FontificatorProperties;
import com.glitchcog.fontificator.gui.chat.ChatWindow;
import com.glitchcog.fontificator.gui.controls.ControlWindow;
import com.glitchcog.fontificator.gui.controls.panel.LogBox;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class FontificatorMain {
    private static final Logger logger = Logger.getLogger(FontificatorMain.class);
    public static final PatternLayout LOG_PATTERN_LAYOUT = new PatternLayout("[%p] %d{MM-dd-yyyy HH:mm:ss} %c %M - %m%n");

    public static void main(String[] args) {
        BasicConfigurator.configure(new ConsoleAppender(LOG_PATTERN_LAYOUT));
        Logger.getRootLogger().setLevel(Level.INFO);
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception e) {
            logger.error(e.toString(), e);
        }
        LogBox logBox = new LogBox();
        FontificatorProperties fProps = new FontificatorProperties();
        ChatWindow chatWindow = new ChatWindow();
        final ControlWindow controlWindow = new ControlWindow(chatWindow, fProps, logBox);
        controlWindow.loadLastData(chatWindow);
        try {
            chatWindow.initChat(fProps, controlWindow);
        }
        catch (Exception e) {
            logger.error(e.toString(), e);
            ChatWindow.popup.handleProblem(e.toString(), e);
            System.exit(1);
        }
        controlWindow.build(logBox);
        controlWindow.loadAfterInit();
        chatWindow.getChatPanel().setMessageCensor(controlWindow.getMessageDialog().getCensorPanel());
        chatWindow.getChatPanel().setDebugSettings(controlWindow.getDebugPanel());
        chatWindow.setVisible(true);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    controlWindow.setVisible(true);
                }
            });
        }
        catch (Exception e) {
            logger.error("Unable to display control window on initialization", e);
        }
    }
}

