# Security Policies and Procedures

This document outlines security procedures and general policies for this project.

* [Reporting a Bug](#reporting-a-bug)
* [Disclosure Policy](#disclosure-policy)
* [Comments on this Policy](#comments-on-this-policy)

## Reporting a Bug

We take **ALL** security related bugs and issues very seriously.

If you think you have identified a security related issue, please
[report it immediately](mailto:disclose@wolfsoftware.com) and include
the word "SECURITY" in the subject line. If you are not sure, don’t worry.
Better safe than sorry – just send an email.

* Please provide as much information as you can.
* Please do not open issues related to any security concerns publicly.
* Please do not include anyone else on the disclosure email.

Report security bugs in third-party modules to the person or team maintaining
the module.

## Disclosure Policy

When a security report is received, we will carry out the following steps:

* Confirm the problem and determine the affected versions.
* Audit code to find any potential similar problems.
* Prepare fixes for all releases still under maintenance. These fixes will be
  released as fast as possible.

We will endeavour to keep you informed of the progress towards a fix and full
announcement, and may ask for additional information or guidance.

## Comments on this Policy

If you have suggestions on how this process could be improved please submit a
pull request.
