//
// Copyright © 2025 Stream.io Inc. All rights reserved.
//

import Combine
import StreamChat
import SwiftUI

/// Protocol of `ChatChannelAvatarView` wrapper for use in SwiftUI.
public protocol ChatChannelAvatarViewSwiftUIView: View {
    init(dataSource: ChatChannelAvatarView.ObservedObject<Self>)
}

extension ChatChannelAvatarView {
    /// Data source of `ChatChannelAvatarView` represented as `ObservedObject`.
    public typealias ObservedObject<Content: SwiftUIView> = SwiftUIWrapper<Content>

    /// `ChatChannelAvatarView` represented in SwiftUI.
    public typealias SwiftUIView = ChatChannelAvatarViewSwiftUIView

    /// SwiftUI wrapper of `ChatChannelAvatarView`.
    public class SwiftUIWrapper<Content: SwiftUIView>: ChatChannelAvatarView, ObservableObject {
        var hostingController: UIViewController?

        override public var intrinsicContentSize: CGSize {
            hostingController?.view.intrinsicContentSize ?? super.intrinsicContentSize
        }

        override public func setUp() {
            super.setUp()

            let view = Content(dataSource: self)
                .environmentObject(components.asObservableObject)
                .environmentObject(appearance.asObservableObject)
            hostingController = UIHostingController(rootView: view)
            hostingController?.view.backgroundColor = .clear
        }

        override public func setUpLayout() {
            hostingController!.view.translatesAutoresizingMaskIntoConstraints = false
            embed(hostingController!.view)
        }

        override public func updateContent() {
            objectWillChange.send()
        }
    }
}
