//
// Copyright © 2025 Stream.io Inc. All rights reserved.
//

import StreamChat
import SwiftUI

// A `UIViewControllerRepresentable` subclass which wraps `ChatChannelListVC` and shows list of channels.
public typealias ChatChannelList = SwiftUIViewControllerRepresentable<ChatChannelListVC>

@available(iOSApplicationExtension, unavailable)
extension ChatChannelListVC: SwiftUIRepresentable {
    public var content: ChatChannelListController {
        get {
            controller
        }
        set {
            controller = newValue
        }
    }
}
