# Radon _(1.0.3)_

Radon is an open-source free obfuscator. It has a UI that's visually similar to Skidfuscator/Proguard and it is very intuitive to use. 

***

### String Encryption

**Light**: Light level is a lot like older DashO string encryption. For example take this code snippet:

```java
print("1. Option 1");
print("2. Option 2");
print("3. Option 3");
print("4. Option 4");
print("5. Exit");
```
This is transformed so that string constants are replaced by a method call such as `decrypt(encoded, key)`.

```java
// \u200e\u2008\u200e\u2004 is the method name.
// It's descriptor is (Ljava/lang/String;I)Ljava/lang/String;
print(MyClass$Sub.\u200e\u2008\u200e\u2004("\u5164\u517b\u5175\u511a\u5125\u5121\u513c\u513a\u513b\u5175\u5164", -672050859));
print(MyClass$Sub.\u200e\u2008\u200e\u2004("\uc4b0\uc4ac\uc4a2\uc4cd\uc4f2\uc4f6\uc4eb\uc4ed\uc4ec\uc4a2\uc4b0", 1793377410));
print(MyClass$Sub.\u200e\u2008\u200e\u2004("\u677f\u6762\u676c\u6703\u673c\u6738\u6725\u6723\u6722\u676c\u677f", 580216652));
print(MyClass$Sub.\u200e\u2008\u200e\u2004("\u8c29\u8c33\u8c3d\u8c52\u8c6d\u8c69\u8c74\u8c72\u8c73\u8c3d\u8c29", 595758109));
print(MyClass$Sub.\u200e\u2008\u200e\u2004("\u8dff\u8de4\u8dea\u8d8f\u8db2\u8da3\u8dbe", 1042779594));
```

The `MyClass$Sub` is shorthand for a new generated class that serves as a decryptor. Typically this name is generated by combining two names of existing classes so that it looks like an inner class. For instance if `MyClass` and `Sub` are two separate classes, Radon mixes them with the `$` character, which makes it look like an inner-class at face-value. No actual inner-class relation is defined it is only in-name only.

Decryption is rather simple. Its a XOR loop. Decrypted values are stored in a HashMap for lookup purposes.

**Normal**: Normal level is the same visually, but the internals of the decryptor class are bolstered. 

Now the decrypt method has a descriptor of `(Ljava/lang/Object;I)Ljava/lang/String;` and is much more than a simple XOR loop. It uses a combination of all bitwise operators and uses the stacktrace as a secondary key. This is an interesting step, but is fairly weak since the stacktrace just points to the caller class/method, which you already know if you are dumping some string in the context of a method.

**Heavy**: Heavy level is the same visually, but the internals of the decryptor class are bolstered again. 

The same additions from normal exist here but there is now some flow-manipulation with intentional exception throws _(IndexOutOfBounds for example)_. There's some additional confusion by using `Runtime.availableProcessors()` but it boils down to `(n + 1) % n` which evaluates to `1`.

***

### InvokeDynamic

**Light**: Because of the fact that Radon doesn't use the expected InvokeDynamic content pattern that would be generated by a typical compiler, all decompilers fail to decompile method calls correctly.

Sometimes depending on the decompiler you can determine what is going on. For instance in Procyon a call to our `print(String)` function from before now looks like:
```java
invokedynamic(\u2001\u200a\u2002\u2007:(Ljava/lang/String;)V, "1. Option 1")
```
The non-method calling code looks OK with Procyon, but with CFR 133 it fails to decompile the entire method. 

The generated Callsite handler is pretty basic.

**Normal**: Very similar in both presentation and the Callsite class.

**Heavy**: Similar in presentation, but the Callsite class is much more complex. It uses a combination of string encryption _(decrypts data passed as an arg, this info contains the relevant Callsite data)_ and reflection.

***

### Flow Obfuscation

**Light**: Light level consistently transforms `for` loops into `while` loops when using Procyon by injecting a opaque-predicate that leads to an invalid `throw null` statement. This bad statement will never be called, but its placement messes up the pattern recognition of the `for` structure.

CFR is unaffected by this level of flow obfuscation if you exclude the obviously bogus `throw null` statements.

**Normal**: Normal level kills Procyon. It generates massive `if () -> if ()` staircase/chains. You can think of it by wrapping every single line of code in its own pointless `if(true)` statement. On _very short_ and _simple_ methods this may not _kill_ procyon per-say, but anything beyond that will have it poop out the feared `This method could not be decompiled.`.

CFR on the other-hand outputs lots of dummy lines such as `if (bl) return;`. The bad `throw null` statements still are around and for some reason in a few cases CFR starts emitting local-variable types as being `void` when they're clearly `int` in the bytecode. 

**Heavy**: Heavy level still kills Procyon. CFR now gets very confused on loop structures and begins using raw labels over proper `for` or `while` structures.

*** 

### Number Obfuscation

**Light**: Light level uses simple XORs to obfuscate constant number values. There is some stack-manipulation `DUP2_X2 -> POP2 -> POP2` but this is effectively an opaque predicate. CFR and Procyon outputs only show the simple XOR operation.

**Normal**: Normal level is similar but it uses `SWAP -> DUP_X1 -> POP2` instead. Same decompilation results.

**Heavy**: Its actually closer to light-level than normal. Same decompilation results.

***

### Crasher

Crasher works by adding some obviously garbage data into the `signature` of the class _(This is how generics are stored)_. Procyon and CFR both abort decompilation.
