# Malware

## Java.Chesire.A

**Links**

* Source: [VX-Underground: MalwareSourceCode](https://github.com/vxunderground/MalwareSourceCode/tree/main/Java/Virus.Java.Cheshire.a)
* Short variant: [Cheshire.b.java](mal/cheshire/Cheshire.b.java)

**Description**: Chesire is a self-replicating piece of Java malware targeting Java 8 and above written by B0t of VX-Underground.

## CurseForge Fractureiser

**Links**

* Write-up: [Fractureiser Investigation](https://github.com/fractureiser-investigation/fractureiser)
  * [Technical details](https://github.com/fractureiser-investigation/fractureiser/blob/main/docs/tech.md)
* [PrismLauncher statement](https://prismlauncher.org/news/cf-compromised-alert/)

**Description**: Malicious actors creates a self-replicating Java malware that explicitly targeted the modding/plugin communities. It spreads to all JAR files on the local system, and stolen credentials of mod authors are used by the bad actor to upload backdoored versions of their mods to hosting sites like CurseForge.

## Squished Worm

**Links**

* Release thread: [Hackforums](https://hackforums.net/showthread.php?tid=4094560)
* Source: [mal/squished-worm/src](mal/squished-worm)

**Description**: Squished Worm is Java malware that targets Bukkit plugins, and supports persistence injection into adjacent server files, and remote SSH/FTP access.

## StrRat / Strigoi

**Links**

* Write-up: [Jai Minton: strrat](https://www.jaiminton.com/reverse-engineering/strrat)
* Config decoder: [Misc-Tools/decrypt-strrat.py](https://github.com/JPMinty/Misc-Tools/blob/main/Malware-Analysis/decrypt-strrat.py)

**Description**: StrRat is a dynamic, plugin-extensible Java RAT. After moving on from just credential stealing, it later gained ransomware like-abilities.

## jRat

**Links**

* Source: [willie/jrat](https://github.com/wille/jrat)
  * Contains full git history of jRat up to v6 from 2018
* Remover tool: [willie/jrat-remover](https://github.com/wille/jrat-remover)
* Config decoder: [RATDecoders/jrat.py](https://github.com/kevthehermit/RATDecoders/blob/master/malwareconfig/decoders/jrat.py)
* Hackforum / seller threads:
  * [Last jRat thread by original author, redpois0n (July 2013)](https://hackforums.net/showthread.php?tid=3615316)
  * [Reseller for later versions (August 2013 and beyond)](https://hackforums.net/showthread.php?tid=3727137)

**Description**: Common back in its active years (ending around 2014) it was the primary go-to Java malware for quite some time.

## Cobalt Stike

**Links**

* Product page: [cobaltstrike.com](https://www.cobaltstrike.com/)
* Write-up: [thedfirreport: cobalt strike, a defender's guide](https://thedfirreport.com/2021/08/29/cobalt-strike-a-defenders-guide/)

**Description**: A tool for post-exploitation pentesting written in Java, commonly used by bad actors for their own _real_ C2 servers.

> [_(Back to README)_](README.md)

