package me.genericskid.gui.action.analysis;

import javassist.NotFoundException;
import javassist.bytecode.ConstPool;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.MethodInfo;
import javassist.CtMethod;
import javassist.CtClass;
import javassist.ClassPath;
import javassist.ClassClassPath;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.ClassNode;

import java.util.List;
import java.util.zip.ZipEntry;
import me.genericskid.util.bytecode.ASMUtil;
import me.genericskid.util.signatures.Signature;
import me.genericskid.util.signatures.SignatureUtil;
import me.genericskid.util.signatures.SignatureRules;
import me.genericskid.gui.frames.panel.impl.MainPanel;
import javassist.ClassPool;

import java.util.zip.ZipInputStream;
import java.io.FileInputStream;
import java.net.URLClassLoader;
import java.net.URL;
import me.genericskid.gui.frames.EnumPanel;
import me.genericskid.gui.frames.panel.impl.AnalyzePanel;
import java.util.ArrayList;
import java.io.File;
import java.awt.Desktop;
import me.genericskid.util.io.FileIO;
import java.awt.event.ActionEvent;
import me.genericskid.gui.frames.FrameMain;
import java.awt.event.ActionListener;

public class ActionSearchMalware implements ActionListener
{
    private final FrameMain instance;
    
    public ActionSearchMalware(final FrameMain instance) {
        this.instance = instance;
    }
    
    @Override
    public void actionPerformed(final ActionEvent arg0) {
        final File file = FrameMain.getFileObfu();
        if (file != null && file.exists()) {
            final ArrayList<String> lines = this.search(file);
            final String fileName = file.getName() + "-malware_report.txt";
            FileIO.saveAllLines(fileName, lines);
            try {
                final Desktop d = Desktop.getDesktop();
                d.open(new File(fileName));
            }
            catch (Exception ex) {}
        }
    }
    
    private ArrayList<String> search(final File file) {
        final AnalyzePanel panel = (AnalyzePanel)this.instance.getPanel(EnumPanel.Analyze);
        final ArrayList<String> suspiciousStrings = new ArrayList<>();
        final ArrayList<String> links = new ArrayList<>();
        final ArrayList<String> bytecode = new ArrayList<>();
        final ArrayList<String> signatures = new ArrayList<>();
        try {
            final URLClassLoader child = URLClassLoader.newInstance(new URL[] { file.toURI().toURL() });
            final ZipInputStream zip = new ZipInputStream(new FileInputStream(file));
            final ClassPool pool = ClassPool.getDefault();
            for (ZipEntry entry = zip.getNextEntry(); entry != null; entry = zip.getNextEntry()) {
                if (!entry.isDirectory()) {
                    if (entry.getName().endsWith(".class")) {
                        String className = entry.getName().replace('/', '.');
                        className = className.substring(0, className.length() - ".class".length());
                        if (!panel.isInclusive() || this.allowedPackage(className, panel.getPackages())) {
                            if (!panel.isExclusive() || !this.allowedPackage(className, panel.getPackages())) {
                                Class<?> classToLoad = null;
                                try {
                                    classToLoad = child.loadClass(className);
                                }
                                catch (VerifyError | NoClassDefFoundError | IllegalAccessError verifyError) {}
                                if (classToLoad != null) {
                                    links.addAll(searchStrings(classToLoad, className, pool));
                                }
                            }
                        }
                    }
                }
            }
            zip.close();
            final MainPanel mp = (MainPanel)this.instance.getPanel(EnumPanel.Main);
            final SignatureRules rules = new SignatureRules(mp.getLimitingPackagesObfu(), mp.getPackagesObfu(), mp.ignoreZKMObfu(), mp.hasObfIDsObfu(), mp.checkWithCL());
            final List<Signature> daSigs = SignatureUtil.populateSigs(file.getAbsolutePath(), rules);
            for (final Signature s : daSigs) {
                if (panel.getMalSigs().contains(s.toSig())) {
                    signatures.add("[Class] Signature detected: " + s.getOwner() + " | " + s.toSig());
                }
            }
            final ArrayList<ClassNode> cNodes = ASMUtil.loadClasses(file);
            links.addAll(this.searchFields(cNodes));
            bytecode.addAll(this.searchCode(cNodes));
            suspiciousStrings.add("Suspicion Scan for " + file.getName());
            suspiciousStrings.add("REMINDER: Detections do not essentially equate to infection");
            suspiciousStrings.add("Detections:" + (links.size() + bytecode.size() + signatures.size()) + " (String constants:" + links.size() + " | Signatures:" + signatures.size() + " | Method code:" + bytecode.size() + ")");
            suspiciousStrings.add(" ");
            suspiciousStrings.add(" ");
            suspiciousStrings.add("------------");
            suspiciousStrings.add("Links");
            suspiciousStrings.add("------------");
            suspiciousStrings.addAll(links);
            suspiciousStrings.add(" ");
            suspiciousStrings.add(" ");
            suspiciousStrings.add("------------");
            suspiciousStrings.add("Code");
            suspiciousStrings.add("------------");
            suspiciousStrings.addAll(bytecode);
            suspiciousStrings.add(" ");
            suspiciousStrings.add(" ");
            suspiciousStrings.add("------------");
            suspiciousStrings.add("Signatures");
            suspiciousStrings.add("------------");
            suspiciousStrings.addAll(signatures);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return suspiciousStrings;
    }
    
    private List<String> searchCode(final ArrayList<ClassNode> cNodes) {
        final ArrayList<String> bits = new ArrayList<>();
        for (final ClassNode classNode : cNodes) {
            final String clzName = classNode.name.replace("/", ".");
            Object[] array;
            for (int length = (array = classNode.methods.toArray()).length, i = 0; i < length; ++i) {
                final Object o = array[i];
                final MethodNode m = (MethodNode)o;
                final InsnList iList = m.instructions;
                AbstractInsnNode[] array2;
                for (int length2 = (array2 = iList.toArray()).length, j = 0; j < length2; ++j) {
                    final AbstractInsnNode a = array2[j];
                    if (a instanceof MethodInsnNode) {
                        final MethodInsnNode min = (MethodInsnNode)a;
                        if (min.owner.startsWith("java/lang/reflect")) {
                            bits.add("[Method] Method call (Reflection): " + clzName + " | " + m.name + " | " + min.owner);
                        }
                        else if (min.owner.equals("java/lang/Runtime")) {
                            bits.add("[Method] Method call (Runtime): " + clzName + " | " + m.name + " | " + min.owner);
                        }
                        else if (min.owner.startsWith("java/io")) {
                            bits.add("[Method] Method call (File IO): " + clzName + " | " + m.name + " | " + min.owner);
                        }
                        else if (min.owner.startsWith("java/net")) {
                            bits.add("[Method] Method call (Networking): " + clzName + " | " + m.name + " | " + min.owner);
                        }
                        else if (min.owner.equals("java/lang/ClassLoader")) {
                            bits.add("[Method] Method call (ClassLoader): " + clzName + " | " + m.name + " | " + min.owner);
                        }
                    }
                    else if (a instanceof MethodInsnNode && a.getOpcode() == 184) {
                        final String owner = ((MethodInsnNode)a).owner;
                        final String name = ((MethodInsnNode)a).name;
                        if (owner.equals("java/lang/System") && name.equals("setSecurityManager")) {
                            bits.add("[Method] Disabled Security Manager (Security): " + clzName + " | " + m.name + " | " + m.desc);
                        }
                    }
                }
            }
        }
        return bits;
    }
    
    private List<String> searchFields(final ArrayList<ClassNode> cNodes) throws IOException {
        final ArrayList<String> links = new ArrayList<>();
        for (final ClassNode classNode : cNodes) {
            final String clzName = classNode.name.replace("/", ".");
            Object[] array;
            for (int length = (array = classNode.fields.toArray()).length, k = 0; k < length; ++k) {
                final Object o = array[k];
                final FieldNode f = (FieldNode)o;
                final Object v = f.value;
                final String[] lookFor = { "http://", "https://", "ftp:", ".net", ".com", ".org", ".tk" };
                final String regex = "(?:[0-9]{1,3}\\.){3}[0-9]{1,3}";
                final Pattern p = Pattern.compile(regex);
                if (v instanceof String) {
                    final String s = (String)v;
                    final Matcher m = p.matcher(s);
                    if (m.find()) {
                        links.add("[Field] IP Address: " + clzName + " | " + f.name + " | " + s);
                    }
                    String[] array2;
                    for (int length2 = (array2 = lookFor).length, l = 0; l < length2; ++l) {
                        final String lf = array2[l];
                        if (s.toLowerCase().contains(lf.toLowerCase())) {
                            links.add("[Field] Possible URL: " + clzName + " | " + f.name + " | " + s);
                        }
                    }
                }
                else if (v instanceof String[]) {
                    for (int i = 0; i < ((String[])v).length; ++i) {
                        final String s2 = ((String[])v)[i];
                        final Matcher j = p.matcher(s2);
                        if (j.find()) {
                            links.add("[Field] IP Address: " + clzName + " | " + f.name + " | " + s2);
                        }
                        String[] array3;
                        for (int length3 = (array3 = lookFor).length, n = 0; n < length3; ++n) {
                            final String lf2 = array3[n];
                            if (s2.toLowerCase().contains(lf2.toLowerCase())) {
                                links.add("[Field] Possible URL: " + clzName + " | " + f.name + " | " + s2);
                            }
                        }
                    }
                }
            }
        }
        return links;
    }
    
    public static List<String> searchStrings(final Class<?> classToLoad, final String className, final ClassPool pool) throws NotFoundException {
        final ArrayList<String> links = new ArrayList<>();
        final ClassClassPath ccpath = new ClassClassPath(classToLoad);
        pool.insertClassPath(ccpath);
        final CtClass ctClass = pool.get(className);
        CtMethod[] declaredMethods;
        for (int length = (declaredMethods = ctClass.getDeclaredMethods()).length, j = 0; j < length; ++j) {
            final CtMethod cm = declaredMethods[j];
            final MethodInfo mi = cm.getMethodInfo();
            if (mi != null) {
                final CodeAttribute ca = mi.getCodeAttribute();
                if (ca != null) {
                    final ConstPool cp = ca.getConstPool();
                    if (cp != null) {
                        final int size = cp.getSize();
                        if (size != 0) {
                            for (int i = 0; i < size; ++i) {
                                final String ldcText = String.valueOf(cp.getLdcValue(i));
                                final String clazz = cp.getClassName();
                                if (ldcText != null && !ldcText.isEmpty() && !ldcText.equalsIgnoreCase("null")) {
                                    final String[] lookFor = { "http://", "https://", "ftp:", ".net", ".com", ".org", ".tk" };
                                    String[] array;
                                    for (int length2 = (array = lookFor).length, k = 0; k < length2; ++k) {
                                        final String lf = array[k];
                                        if (ldcText.toLowerCase().contains(lf.toLowerCase())) {
                                            links.add("[Method] Possible URL: " + clazz + " | " + mi.getName() + " | " + ldcText);
                                        }
                                    }
                                    final String regex = "(?:[0-9]{1,3}\\.){3}[0-9]{1,3}";
                                    final Pattern p = Pattern.compile(regex);
                                    final Matcher m = p.matcher(ldcText);
                                    if (m.find()) {
                                        links.add("[Method] IP Address: " + clazz + " | " + mi.getName() + " | " + ldcText);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return links;
    }
    
    private boolean allowedPackage(final String className, final String[] packages) {
        for (final String packageStr : packages) {
            if (className.contains(packageStr)) {
                return true;
            }
        }
        return false;
    }
}
