# Android

| Tool  | Description  | Link |
|-------|--------------|------|
| **AndroidProjectCreator** | Easily convert an APK to an Android Studio Project. | [AndroidProjectCreator](https://maxkersten.nl/projects/androidprojectcreator/) |
| **AndroTotal** | Essentially VirusTotal for android APKs. | [AndroTotal](http://andrototal.org/) | 
| **AndroWarn** | A python-based static analysis tool for automatically detecting malicious behavior in APKs | [Source](https://github.com/maaaaz/androwarn/) | 
| **APK Editor Studio** | Reverse engineering toolkit for Android. | [Source](https://github.com/kefir500/apk-editor-studio) |
| **APK Studio** | **DISCONTINUTED** Reverse engineering toolkit for Android. | [APK Studio](https://github.com/vaibhavpandeyvpz/apkstudio) |
| **Baksmali** | An assembler/disassembler for the dex format used by dalvik, Android's Java VM implementation. | [Source](https://github.com/JesusFreke/smali) | 
| **Dex2Jar** | A simple command line tool to convert `classes.dex` into `classes.jar` and back. The process is not always lossless and may not be up-to-date with current android specifications. But its usually enough to gain an understanding of what an application is doing. | [Source](https://github.com/pxb1988/dex2jar) |
| **Frida** | Frida is a dynamic instrumentation toolkit. It can be used for function hooking and more. I'd suggest checking [some examples](https://github.com/noobpk/frida-android-hook) out there to see what you can do with it. | [Frida Android](https://frida.re/docs/android/) |
| **JADX** | Dex to Java decompiler with support for Android XML decoding, navigation tools, and smali debugging | [JADX](https://github.com/skylot/jadx) |
| **JEB** | JEB is a premium _($1,200-$1,800)_ modular reverse engineering platform. It's an absolute powerhouse if you're serious about reverse engineering and are willing to drop the cash for a license. | [JEB](https://www.pnfsoftware.com/jeb/) |
| **Platform Tools** | A small download containing useful tools such as Android-Bridge-Debug _(adb)_ and Systrace. With this you don't have to download the rest of the massive Android SDK. | [Platform Tools](https://developer.android.com/studio/releases/platform-tools) |
| **Show Java** | Show Java is an android app that lets you decompile other applications on your phone. You can choose from your installed applications or by browsing your file-system. Supported decompilers are: <ul><li>FernFlower</li><li>CFR 110</li><li>JaDX 0.6.1</li></ul> | [Source](https://github.com/niranjan94/show-java) |
| **Simplify** | Simplify emulates code to optimize code. The functionality is generic so multiple obfuscators should be supported out-of-the-box. Functions: <ul><li>Constant value propagation</li><li>Dead code removal</li><li>Unreflection</li><li>Etc. _(Peephole)_</li></ul> | [Source](https://github.com/CalebFenton/simplify) |
| **Uber APK Signer** | Provides easy to use tools for APK signing, zip alignment, and more. | [Source](https://github.com/patrickfav/uber-apk-signer) | 

> [_(Back to README)_](README.md)
