# SkidSuite 3

SkidSuite 3 is a collection of useful tools pertaining to reverse engineering of Java applications.  

***

## Table of Contents

| Article Title | Description |
|---|---|
| [Deobfuscation](deobfuscation.md)      | Links to automatic deobfuscation tools. <br> Links to manual remapping tools.  |
| [Decompilation](decompilation.md)      | Links to decompilers. Translate bytecode to source-code. |
| [Editing](editing.md)                  | Links to bytecode editors. Used for manipulating already complied Java programs. |
| [Obfuscation](obfuscation.md)          | Links to obfuscators. Used to make code theft and reverse-engineering more difficult. |
| [Android](android.md)                  | Links to tools/resources for android-focused reverse-engineering. |
| [Malware](malware.md)                  | Links to JVM malware information. |
| [Relevant articles](relevant.md)       | Links to varied articles/resources for Java reverse-engineering and general JVM topics. |
| [Skidsuite2 successors](successors.md) | Links to tools that serve the same purposes as tools I previously included in SkidSuite. |

## Obfuscation Samples

A [list of obfuscation samples](obf/README.md) from different obfuscators. You can evaluate the effectiveness of each sample on your own terms with your own tools of choice. All samples are based on a [provided jar](obf/obf-sample-test.jar).

## Obfuscation Techniques

A [list of various obfuscation techniques](obf-techniques/) is also available. These provide a brief summary of what the technique is and how it works.

## Contributing

If you have an informative article or useful tool please open an issue with a link or pull request with the changes to the relevant markdown files.
