package dev.binclub.binscure.utils

/**
 * @author cook 11/Oct/2020
 */
private val opcodeArr = arrayOfNulls<String>(200).also { arr ->
	try {
		arr[0] = "NOP"
		arr[1] = "ACONST_NULL"
		arr[2] = "ICONST_M1"
		arr[3] = "ICONST_0"
		arr[4] = "ICONST_1"
		arr[5] = "ICONST_2"
		arr[6] = "ICONST_3"
		arr[7] = "ICONST_4"
		arr[8] = "ICONST_5"
		arr[9] = "LCONST_0"
		arr[10] = "LCONST_1"
		arr[11] = "FCONST_0"
		arr[12] = "FCONST_1"
		arr[13] = "FCONST_2"
		arr[14] = "DCONST_0"
		arr[15] = "DCONST_1"
		arr[16] = "BIPUSH"
		arr[17] = "SIPUSH"
		arr[18] = "LDC"
		arr[21] = "ILOAD"
		arr[22] = "LLOAD"
		arr[23] = "FLOAD"
		arr[24] = "DLOAD"
		arr[25] = "ALOAD"
		arr[46] = "IALOAD"
		arr[47] = "LALOAD"
		arr[48] = "FALOAD"
		arr[49] = "DALOAD"
		arr[50] = "AALOAD"
		arr[51] = "BALOAD"
		arr[52] = "CALOAD"
		arr[53] = "SALOAD"
		arr[54] = "ISTORE"
		arr[55] = "LSTORE"
		arr[56] = "FSTORE"
		arr[57] = "DSTORE"
		arr[58] = "ASTORE"
		arr[79] = "IASTORE"
		arr[80] = "LASTORE"
		arr[81] = "FASTORE"
		arr[82] = "DASTORE"
		arr[83] = "AASTORE"
		arr[84] = "BASTORE"
		arr[85] = "CASTORE"
		arr[86] = "SASTORE"
		arr[87] = "POP"
		arr[88] = "POP2"
		arr[89] = "DUP"
		arr[90] = "DUP_X1"
		arr[91] = "DUP_X2"
		arr[92] = "DUP2"
		arr[93] = "DUP2_X1"
		arr[94] = "DUP2_X2"
		arr[95] = "SWAP"
		arr[96] = "IADD"
		arr[97] = "LADD"
		arr[98] = "FADD"
		arr[99] = "DADD"
		arr[100] = "ISUB"
		arr[101] = "LSUB"
		arr[102] = "FSUB"
		arr[103] = "DSUB"
		arr[104] = "IMUL"
		arr[105] = "LMUL"
		arr[106] = "FMUL"
		arr[107] = "DMUL"
		arr[108] = "IDIV"
		arr[109] = "LDIV"
		arr[110] = "FDIV"
		arr[111] = "DDIV"
		arr[112] = "IREM"
		arr[113] = "LREM"
		arr[114] = "FREM"
		arr[115] = "DREM"
		arr[116] = "INEG"
		arr[117] = "LNEG"
		arr[118] = "FNEG"
		arr[119] = "DNEG"
		arr[120] = "ISHL"
		arr[121] = "LSHL"
		arr[122] = "ISHR"
		arr[123] = "LSHR"
		arr[124] = "IUSHR"
		arr[125] = "LUSHR"
		arr[126] = "IAND"
		arr[127] = "LAND"
		arr[128] = "IOR"
		arr[129] = "LOR"
		arr[130] = "IXOR"
		arr[131] = "LXOR"
		arr[132] = "IINC"
		arr[133] = "I2L"
		arr[134] = "I2F"
		arr[135] = "I2D"
		arr[136] = "L2I"
		arr[137] = "L2F"
		arr[138] = "L2D"
		arr[139] = "F2I"
		arr[140] = "F2L"
		arr[141] = "F2D"
		arr[142] = "D2I"
		arr[143] = "D2L"
		arr[144] = "D2F"
		arr[145] = "I2B"
		arr[146] = "I2C"
		arr[147] = "I2S"
		arr[148] = "LCMP"
		arr[149] = "FCMPL"
		arr[150] = "FCMPG"
		arr[151] = "DCMPL"
		arr[152] = "DCMPG"
		arr[153] = "IFEQ"
		arr[154] = "IFNE"
		arr[155] = "IFLT"
		arr[156] = "IFGE"
		arr[157] = "IFGT"
		arr[158] = "IFLE"
		arr[159] = "IF_ICMPEQ"
		arr[160] = "IF_ICMPNE"
		arr[161] = "IF_ICMPLT"
		arr[162] = "IF_ICMPGE"
		arr[163] = "IF_ICMPGT"
		arr[164] = "IF_ICMPLE"
		arr[165] = "IF_ACMPEQ"
		arr[166] = "IF_ACMPNE"
		arr[167] = "GOTO"
		arr[168] = "JSR"
		arr[169] = "RET"
		arr[170] = "TABLESWITCH"
		arr[171] = "LOOKUPSWITCH"
		arr[172] = "IRETURN"
		arr[173] = "LRETURN"
		arr[174] = "FRETURN"
		arr[175] = "DRETURN"
		arr[176] = "ARETURN"
		arr[177] = "RETURN"
		arr[178] = "GETSTATIC"
		arr[179] = "PUTSTATIC"
		arr[180] = "GETFIELD"
		arr[181] = "PUTFIELD"
		arr[182] = "INVOKEVIRTUAL"
		arr[183] = "INVOKESPECIAL"
		arr[184] = "INVOKESTATIC"
		arr[185] = "INVOKEINTERFACE"
		arr[186] = "INVOKEDYNAMIC"
		arr[187] = "NEW"
		arr[188] = "NEWARRAY"
		arr[189] = "ANEWARRAY"
		arr[190] = "ARRAYLENGTH"
		arr[191] = "ATHROW"
		arr[192] = "CHECKCAST"
		arr[193] = "INSTANCEOF"
		arr[194] = "MONITORENTER"
		arr[195] = "MONITOREXIT"
		arr[197] = "MULTIANEWARRAY"
		arr[198] = "IFNULL"
		arr[199] = "IFNONNULL"
	} catch (t: Throwable) {
		println("Couldnt construct opcode arr")
		t.printStackTrace()
		throw t
	}
}


val opcodeStrings: Map<Int, String> = object: Map<Int, String> {
	override val entries: Set<Map.Entry<Int, String>>
		get() = TODO("Not yet implemented")
	override val keys: Set<Int>
		get() = opcodeArr.indices.toSet()
	override val size: Int
		get() = opcodeArr.size
	override val values: Collection<String>
		get() = TODO("Not yet implemented")
	
	override fun containsKey(key: Int): Boolean = opcodeArr.indices.contains(key)
	
	override fun containsValue(value: String): Boolean {
		TODO("Not yet implemented")
	}
	
	override fun get(key: Int): String? = if (opcodeArr.indices.contains(key)) opcodeArr[key] else null
	
	override fun isEmpty(): Boolean = opcodeArr.isEmpty()
}
