package dev.binclub.binscure.processors.exploit

import dev.binclub.binscure.IClassProcessor
import dev.binclub.binscure.classpath.ClassSources
import dev.binclub.binscure.configuration.ConfigurationManager.rootConfig
import dev.binclub.binscure.forClass
import dev.binclub.binscure.utils.versionAtLeast
import org.objectweb.asm.Opcodes.*
import org.objectweb.asm.tree.ClassNode

/**
 * @author cook 10/Feb/2021
 */
class MultiVersionExploit(source: ClassSources): IClassProcessor(source) {
	override val progressDescription: String
		get() = "Hiding Java 9 Class Files"
	
	override val config = rootConfig.crasher
	
	override fun process(
		source: ClassSources,
		classes: MutableCollection<ClassNode>,
		passThrough: MutableMap<String, ByteArray>
	) {
		if (!config.enabled || !config.tools) return
		
		forClass(classes) {
		}
	}
	
	data class ClassReplacement(val oldClassName: String, val oldClass: ClassNode, val newClassName: String?, val newClass: ClassNode?)
	
	fun processClass(path: String, classNode: ClassNode): ClassReplacement {
		if (!classNode.versionAtLeast(V9)) return ClassReplacement(path, classNode, null, null)
		
		return ClassReplacement(path, classNode, null, null)
	}
}
