package dev.binclub.binscure.processors.exploit

import dev.binclub.binscure.CObfuscator
import dev.binclub.binscure.IClassProcessor
import dev.binclub.binscure.classpath.ClassSources
import dev.binclub.binscure.configuration.ConfigurationManager.rootConfig
import dev.binclub.binscure.processors.flow.MethodParameterObfuscator
import dev.binclub.binscure.processors.runtime.randomOpaqueJump
import dev.binclub.binscure.utils.add
import dev.binclub.binscure.utils.newLabel
import dev.binclub.binscure.utils.versionAtLeast
import dev.binclub.binscure.utils.random
import org.objectweb.asm.Handle
import org.objectweb.asm.Opcodes
import org.objectweb.asm.Opcodes.POP
import org.objectweb.asm.tree.ClassNode
import org.objectweb.asm.tree.InsnList
import org.objectweb.asm.tree.InvokeDynamicInsnNode
import org.objectweb.asm.tree.TryCatchBlockNode

/**
 * By adding an invokedynamic insn to a non existent bootstrap method we can crash procyon and similar bytecode parsers
 * (Sadly asm is immune)
 *
 * @author cookiedragon234 09/Mar/2020
 */
class BadIndyConstant(source: ClassSources): IClassProcessor(source) {
	override val progressDescription: String
		get() = "Exploiting invoke dynamics"
	override val config = rootConfig.crasher
	
	override fun process(
		source: ClassSources,
		classes: MutableCollection<ClassNode>,
		passThrough: MutableMap<String, ByteArray>
	) {
		if (!config.enabled || !config.decompilers)
			return
		
		val methodParameterObfuscator = CObfuscator.processor<MethodParameterObfuscator>()
		
		for (classNode in classes) {
			if (isExcluded(classNode))
				continue
			if (!classNode.versionAtLeast(Opcodes.V1_7))
				continue
			
			for (method in classNode.methods) {
				if (isExcluded(classNode, method))
					continue
				
				if (method.instructions?.first == null)
					continue
				
				val label = newLabel()
				val list = InsnList().apply {
					if (true) {
						add(randomOpaqueJump(label, mnStr = methodParameterObfuscator.mnToStr(classNode, method)))
						add(InvokeDynamicInsnNode(
							"while",
							"()V",
							Handle(Opcodes.H_INVOKESTATIC, "java/yeet", "\u0020\u0305\u030d\u036d\u0308\u030b\u0369\u0344\u034a\u030f\u036c\u036c\u0306\u0300\u030b\u030d\u0350\u035b\u0363\u0338\u0338\u0337\u0358\u0354\u033b\u0320\u0316\u033c\u0316\u007c\u0314\u033d\u0314\u0365\u0306\u0311\u0300\u0368\u0308\u0312\u033f\u0489\u0340\u032a\u0359\u032d\u0320\u033b\u0339\u0317\u034d\u0347\u031e\u031f\u0359\u032b\u031d\u031f\u0020\u0308\u0308\u033e\u031a\u036e\u0303\u033e\u033e\u035b\u0300\u030d\u0350\u0366\u033e\u0368\u030d\u0309\u0313\u0308\u035d\u0338\u035d\u0325\u0354\u032d\u0348\u0073\u0368\u0302\u0307\u0368\u0343\u0301\u030b\u0357\u0308\u0312\u0311\u0369\u0306\u034a\u0337\u034f\u0329\u032f\u0329\u0319\u031d\u032f\u0323\u032a\u0349\u0333\u0318\u0065\u034b\u030b\u0304\u0304\u0367\u0303\u036a\u0368\u0321\u0360\u0361\u0489\u035c\u032a\u0331\u0325\u0324\u0347\u0339\u0354\u034e\u032b\u0354\u032f", "(I)V", false)
						))
						add(InvokeDynamicInsnNode(
							"fuck", "()${descriptors.random(random)}", Handle(Opcodes.H_INVOKESTATIC, "a", "a", "(IIIIIIIIIIIIIIIIIIIIIIII)Ljava/lang/Throwable;")
						))
						add(POP)
						add(label)
					} else {
						val start = newLabel()
						val end = newLabel()
						val handler = newLabel()
						
						add(start)
						add(InvokeDynamicInsnNode(
							"hello", "()${descriptors.random(random)}", Handle(Opcodes.H_INVOKESTATIC, "a", "a", "(IIIIIIIIIIIIIIIIIIIIIIII)Ljava/lang/Throwable;")
						))
						add(handler)
						add(POP)
						add(end)
						
						method.tryCatchBlocks = method.tryCatchBlocks ?: arrayListOf()
						method.tryCatchBlocks.add(TryCatchBlockNode(start, end, handler, null))
					}
				}
				
				method.instructions.insert(list)
			}
		}
	}
	
	val descriptors = arrayOf("I", "Z", "B", "Ljava/lang/String;", "Ljava/lang/Throwable;")
}
