package dev.binclub.binscure.processors.exploit

import dev.binclub.binscure.IClassProcessor
import dev.binclub.binscure.classpath.ClassSources
import dev.binclub.binscure.configuration.ConfigurationManager.rootConfig
import dev.binclub.binscure.utils.add
import org.objectweb.asm.Opcodes.*
import org.objectweb.asm.tree.*

/**
 * The JVM uses the <clinit>()V method as the static initializer.
 *
 * Many decompilers are flawed and will assume that any method with the name <clinit> is the static initalizer,
 * even if it does not in fact have a description of ()V, meaning no parameters and void return type.
 *
 * This transformer adds a "fake" static initializer that takes a throwable as a parameter and proceeds to throw it.
 *
 * @author cookiedragon234 25/Feb/2020
 */
@Deprecated("Patched in recent JVMs")
class BadClinitExploit(source: ClassSources): IClassProcessor(source) {
	override val progressDescription: String
		get() = "Exploiting static initializers"
	override val config = rootConfig
	
	override fun process(
		source: ClassSources,
		classes: MutableCollection<ClassNode>,
		passThrough: MutableMap<String, ByteArray>
	) {
		error("Deprecated")/*
		classLoop@for (classNode in classes) {
			if (isExcluded(classNode))
				continue
			
			for (method in classNode.methods) {
				if (method.name == "<clinit>") continue@classLoop
			}
			
			classNode.methods.add(
				MethodNode(
					ACC_STATIC + ACC_PUBLIC,
					"<clinit>",
					"(Ljava/lang/Throwable;)V",
					null,
					null
				).apply {
					instructions = InsnList().apply {
						add(VarInsnNode(ALOAD, 0))
						add(ATHROW)
					}
				}
			)
		}*/
	}
}
