package dev.binclub.binscure.processors.exploit

import dev.binclub.binscure.CObfuscator.random
import dev.binclub.binscure.IClassProcessor
import dev.binclub.binscure.classpath.ClassSources
import dev.binclub.binscure.configuration.ConfigurationManager.rootConfig
import dev.binclub.binscure.utils.versionAtLeast
import org.objectweb.asm.Attribute
import org.objectweb.asm.Opcodes
import org.objectweb.asm.tree.ClassNode
import java.io.ByteArrayOutputStream
import java.io.DataOutputStream
import java.util.Arrays

/**
 * While the JVM will ignore an attribute in a classfile whos version is < the specification version that first defined
 * the attribute, OW2 ASM will still attempt to parse it.
 * Adding these attributes and filling them with garbage data will therefore crash ASM.
 *
 * @author cookiedragon234 17/Mar/2020
 */
class BadAttributeExploit(source: ClassSources): IClassProcessor(source) {
	override val progressDescription: String
		get() = "Exploiting class file parsers"
	override val config = rootConfig.crasher
	
	private val BOOTSTRAP_METHODS = DummyAttribute("BootstrapMethods")
	private val MODULE_MAIN_CLASS = DummyAttribute("ModuleMainClass")
	private val NEST_HOST = DummyAttribute("NestHost", ByteArrayOutputStream(2).also {
		DataOutputStream(it).writeInt(6) // constant pool index 6 (likely not pointing to a ClassConstant like nesthost should)
	}.toByteArray())
	private val CODE = DummyAttribute("Code")
	private val CONSTANT_VALUE = DummyAttribute("ConstantValue")
	private val STACKMAP = DummyAttribute("StackMap")
	//private val INVIS_ANNOS = InvisAnnos()
	
	override fun process(
		source: ClassSources,
		classes: MutableCollection<ClassNode>,
		passThrough: MutableMap<String, ByteArray>
	) {
		if (!config.enabled || !config.antiAsm)
			return
		
		for (classNode in classes) {
			if (isExcluded(classNode))
				continue
			
			classNode.attrs = (classNode.attrs ?: arrayListOf()).also {
				if (!classNode.versionAtLeast(Opcodes.V1_7)) {
					it.add(BOOTSTRAP_METHODS)
				} else if (!classNode.versionAtLeast(Opcodes.V9)) {
					it.add(MODULE_MAIN_CLASS)
				} else if (!classNode.versionAtLeast(Opcodes.V11)) {
					it.add(NEST_HOST)
				}
			}
			classNode.fields?.forEach { field ->
				field.attrs = (field.attrs ?: arrayListOf()).also {
					it.add(CODE)
					//it.add(INVIS_ANNOS)
				}
			}
			classNode.methods?.forEach { method ->
				method.attrs = (method.attrs ?: arrayListOf()).also {
					it.add(CONSTANT_VALUE)
					it.add(STACKMAP)
				}
			}
		}
	}
	
	private class DummyAttribute(name: String, bytes: ByteArray = ByteArray(2 + random.nextInt(4))): Attribute(name) {
		init {
			random.nextBytes(bytes)
			content = bytes
		}
	}
	
	private class InvisAnnos(): Attribute("RuntimeInvisibleAnnotations") {
		init {
			val os = ByteArrayOutputStream()//2 + (0xFFFF * 5))
			val ds = DataOutputStream(os)
			ds.writeShort(1) // num annotations
			//for (i in 0 until 0xFFFF) {
				ds.writeShort(1) // type index
				ds.writeShort(1) // num pairs
					ds.writeShort(1) // pair name
					ds.writeByte('F'.toInt()) // pair type
					ds.writeShort(1) // pair type index
			//}
			content = os.toByteArray()
			println(Arrays.toString(content))
		}
	}
}
