# GeekProto
### 特点
基于MessagePack，序列化和反序列化效率极高，同时序列化之后的数据极小，数据传输效率很高。[MessagePack-CSharp](https://github.com/neuecc/MessagePack-CSharp) 【Super Fast Binary Serialization Library】  

### 定义方式
```csharp
/// <summary>
/// 请求登录
/// </summary>
[MessagePackObject(true)]
public class ReqLogin : Message
{
    public string UserName { get; set; }
    public string Platform { get; set; }
    public int SdkType { get; set; }
    public string SdkToken { get; set; }
    public string Device { get; set; }
}

```

1.Geek.MsgPackTool为每个可序列化类自动分配唯一ID(FullName的hashcode)，如果存在hash冲突(概率很小)，工具会提示你进行修改类名。  
2.MessagePackObject注解，所有需要序列化的类都要标记,为了更好的兼容性和便捷性messagepack使用map模式，即MessagePackObject(true)  
3.仅作为消息头的类需要继承自Message，其他不用  
4.**请勿将协议中的类，存入State中（为支持协议的热更新）**

### 限制  
兼容限制：不能修改字段类型（如从bool改为long）  
[了解更多 MessagePack-CSharp](https://github.com/neuecc/MessagePack-CSharp)  

### 多态支持

MessagePack对多态支持不友好，Geek.MessagePackTool工具会在代码生成时，生成多态绑定关系来解决此问题！

```csharp
public partial class PolymorphicRegister
{
    static PolymorphicRegister()
    {
        System.Console.WriteLine("***PolymorphicRegister Init***");
		Init();
        Register();
    }

	public static void Register()
    {
		settings.RegisterType<Geek.Server.Message, Geek.Server.Proto.ReqBagInfo>(112001);
		settings.RegisterType<Geek.Server.Message, Geek.Server.Proto.ResBagInfo>(112002);
		settings.RegisterType<Geek.Server.Message, Geek.Server.Proto.ReqUseItem>(112003);
		settings.RegisterType<Geek.Server.Message, Geek.Server.Proto.ReqSellItem>(112004);
		settings.RegisterType<Geek.Server.Message, Geek.Server.Proto.ResItemChange>(112005);
		settings.RegisterType<Geek.Server.Proto.A, Geek.Server.Proto.B>(111112);
		settings.RegisterType<Geek.Server.Message, Geek.Server.Proto.ReqLogin>(111001);
		settings.RegisterType<Geek.Server.Message, Geek.Server.Proto.ResLogin>(111002);
		settings.RegisterType<Geek.Server.Message, Geek.Server.Proto.ResLevelUp>(111003);
		settings.RegisterType<Geek.Server.Message, Geek.Server.Proto.HearBeat>(111004);
		settings.RegisterType<Geek.Server.Message, Geek.Server.Proto.ResErrorCode>(111005);
    }
}
```

### 最佳实践
1.可以将Geek.MessagePackTool.exe添加到vs studio的外部工具  
![](https://github.com/leeveel/GeekServer/blob/main/Docs/imgs/vs001.png)
![](https://github.com/leeveel/GeekServer/blob/main/Docs/imgs/vs002.png)  
2.Geek.MessagePackTool工作时仅需要依赖GeekServer.Proto工程，所以其他工程编译不过时，不影响导出协议