# Entity和Component和State
GeekServer的Entity包含1个/多个Component，Component包含0个/1个State，你可以这样理解：Entity=实体，Component=功能系统，State=功能系统的数据。每个Entity都包含一个Actor成员变量，Entity的所有行为调度都有Actor完成，以保证线程安全。

Entity是GeekServer的基础，一切功能都可以作为单独的Entity（比如一个角色，一个公会，一个玩法系统。。。），Component隶属于Entity，State隶属于Component，Component承载各种逻辑，State承载各种数据。Entity拆分方式根据项目的具体需求可以任意规划。

### Entity(Actor)拆分
1. 尽可能独立（一个系统或者玩家的操作尽量不阻塞其他玩家的操作）
2. 在独立的前提下尽可能少（节约管理成本）
3. 一个角色，包含若干个功能系统（背包，宠物，任务。。。）
4. 一个公会，包含多个公会基础系统（基础信息，捐赠，工会副本。。。）

比如有2个全局玩法，世界boss和工会战，如果这2个系统归于一个Actor，那么当一个玩家挑战世界boss时，挑战逻辑到Actor线程中执行，此时另一个玩家要去报名工会战，报名逻辑也需要到Actor线程中执行，此时报名公会战的逻辑则需要等待前一个玩家挑战世界boss逻辑完成后才能执行，客户端表现可能就是更长时间的网络连接中，在cpu够用的情况下就产生了多余的等待时间，这就有些不合理了；这种功能之间没有任何交集的情况下我们建议将世界boss和工会战分别拆分为Actor，各自的逻辑便可以更加顺畅的执行，客户端等待的时间也越短。

### State(对象数据库)
GeekServer支持内嵌模式和MongoDB直连模式，其中内嵌数据库目前为Facebook的RocksDB，读写性能都相当强悍。 可以通过app_config.json中  "DBModel"(0:内嵌 1:mongodb)来指定，默认是使用的内嵌模式。     
1.单服结构，**强烈推荐使用内嵌模式**，内嵌数据库没有任何读写压力，数据就在本地磁盘，不受网络因素影响。同时由Geek.Server.RemoteBackup进程来异步远程备份，保证数据的安全。   
2.Geek.Server.RemoteBackup 启动后会定期扫描，数据库根目录下的数据库文件，异步同步到远程mongodb。由于此进程和游戏逻辑没有仍和关联，所以此进程是可以随时重启的，即便进程崩溃也不会丢失数据，极大的提高了容错性。   
3.不管哪种模式，数据库中存放的数据都是经过Messagepack序列化之后的二进制数据，需要使用Tools/GeekDB.GUI来浏览数据

GeekDB.GUI
![](https://github.com/leeveel/GeekServer/blob/main/Docs/imgs/geekdb.png)



