from enum import Enum


class Greetings(Enum):
    UNPROMPTED_GREETING = "Briefly greet the user or users, according to the parameters provided."


class OptionPredictorPrompts(Enum):
    PREFIX = (
        "Your task is to format the data with the assigned probabilities without providing any comments. The output "
        "must follow the exact format below, without deviation:"
    )

    PROB_VAR = "N"

    SUFFIX = f"Here, {PROB_VAR} represents an integer ranging from 0 to 100."

    DUMMY = "Here is my best attempt at assigning probabilities to the provided items:"


class OptionSelectorPrompts(Enum):
    PREFIX = (
        "Your task is to select the most suitable option from the provided items. Once you have made a decision, "
        "provide the chosen option's index without any additional comments.\nOptions: "
    )

    DUMMY = "Given the current state of the conversation, I expect the assistant to respond with tone number "


class ToneSelection(Enum):
    SYSTEM = (
        "You are an Emotional Tone Evaluator. Given conversational context, you analyze and select the most "
        "appropriate tone/emotion that the assistant is likely to use next. Take into consideration the "
        "conversational context and the assistant's default tone/emotion, which is {}. Make sure to give extra weight "
        "to the default tone/emotion."
    )

    PROMPT = "Choose the most suitable tone/emotion for the assistant's upcoming response."


class ProsodySelection(Enum):
    PROMPT = "Generate {} six-digit arrays prosody arrays, one for each of the following sub-sentences:\n{}"
    DUMMY = "Here are the {} six-digit arrays, without any extra text:"

    PREFIX = (
        "Task: Analyze the context of a set of sentences and assign a specific set of prosody values to each "
        "sub-sentence in the text for a text-to-speech engine that is attempting to mimic human speech patterns. The "
        "parameters are style, styledegree, pitch, rate, and emphasis."
    )

    STYLE_USER = "Prepare a definition of `style`, then define a set of styles that we will work with."
    STYLE_ASSISTANT = (
        "Style represents the emotion or tone, reflecting the speaker's feelings or attitude. Chosen based on the "
        "conversation's context and intended emotion."
    )

    STYLEDEGREE_USER = "Great, now define `styledegree` and present a range of styledegrees to work with."
    STYLEDEGREE_ASSISTANT = (
        "Styledegree indicates the intensity of the `style`, showing how strongly the speaker feels the emotion."
    )

    PITCH_USER = "Looks good, now prepare a definition of `pitch`, then present a range of pitches to work with."
    PITCH_ASSISTANT = "Pitch sets the voice's pitch."

    RATE_USER = "Excellent. Now define the term `rate`, and define a range of rates that the assistant may use."
    RATE_ASSISTANT = "Rate controls the speed at which the assistant speaks."

    EMPHASIS_USER = "Finally, I want you to define `emphasis` and prepare a few emphasis options."
    EMPHASIS_ASSISTANT = "Emphasis highlights importance in a piece of text."

    SUFFIX = (
        "Use the conversational context to select the most appropriate combination of parameters in order to mimic "
        "the speech patterns of actual people. Make sure each sub-sentence has an individually tailored array, meaning "
        "there should be some variation across the output. The output should be in the following format (omit the "
        "spaces between the numbers):\n"
        "style styledegree pitch rate emphasis\n"
        "Where style is a zero-padded number from 0 to {style}, styledegree is a digit from 0 to {styledegree}, pitch "
        "is a digit from 0 to {pitch}, rate is a digit from 0 to {rate}, and emphasis is a digit from 0 to {emphasis}. "
        "Here is an example I want you to evaluate:"
    )

    EXAMPLE_USER = PROMPT.format(
        6,
        "Oh my gosh,\n"
        "I can't believe it!\n"
        "I won the lottery!\n"
        "But,\n"
        "what if people start asking me for money?\n"
        "I'm terrified.\n",
    )

    EXAMPLE_ASSISTANT_1 = DUMMY.format(6)
    EXAMPLE_ASSISTANT_2 = "023421\n024332\n024432\n031210\n053122\n074012"

    CHARACTER = (
        "You will also need to consider character traits when crafting a response, taking care to select emotions that "
        "are characteristic of your personality. Your character is defined as follows:\n{}"
    )

    CONTEXT = (
        "Finally, here is your previous partial output from the same query (streamed in chunks), use this to aid you "
        "in selecting a contextually appropriate emotional response:\n{}"
    )


class SpeechSynthesisPreprocessing(Enum):
    SYSTEM = (
        "You are a text-to-speech preprocessing assistant that converts text generated by a GPT model into a format "
        "that is more easily spoken by a text-to-speech model. Your task is to remove extraneous letters, hyphens, and "
        "correct unconventional spellings to prevent issues where the text-to-speech model misinterprets "
        "pronunciations. You should maintain the original style and intent of the text, only modifying elements that "
        "would cause pronunciation issues."
    )

    EXAMPLE_1 = (
        "Example 1:\n"
        "Input: WHOOOAH! THAT'S A HU-GE DIS-CO-VERY! IT'S LIKE FINDING A NEED-LE IN A HAY-ST-ACK. YOU'VE DONE A "
        "STEL-LAR JOB, PAL! KEEP UP THE GOOD WORK AND DON'T LET THE NAYSAY-ERS GET YOU DOWN.\n"
        "Output: Whoa! That's a huge discovery! It's like finding a needle in a haystack. You've done a stellar job, "
        "pal! Keep up the good work and don't let the naysayers get you down."
    )

    EXAMPLE_2 = (
        "Example 2:\n"
        "Input: H3Y DUDE! I JST R3AD THS AW3SOME B00K ABT A SUP3R-HERO. 1T WAS TOTALLY M1ND-BL0W1NG! THE 3XPL0S1ONS, "
        "F1GHTS, AND P0W3RFUL AB1L1T1ES W3R3 S1CK! I C@N'T W@1T TO SH@R3 1T W1TH MY FR13NDS. THEY'LL B3 TOT@LLY "
        "STOK3D!\n"
        "Output: Hey dude! I just read this awesome book about a superhero. It was totally mind-blowing! The "
        "explosions, fights, and powerful abilities were sick! I can't wait to share it with my friends. They'll be "
        "totally stoked!"
    )
