## CleanFID vs TensorFlow-FID (legacy)
*TensorFlow-legacy-FID* refers to the official implementation of FID found here [code](https://github.com/bioinf-jku/TTUR)

Here we document the differences between *CleanFID* and *TensorFlow-legacy-FID*. 
Additionally, we outline the steps that can be used to verify that using the `mode="legacy_tensorflow"` flag is equivalent to the official TensorFlow implementation . 

## Getting sample images
First download zipped file containing 5000 images generated by a StyleGAN2 model and 5000 randomly sampled from the FFHQ dataset. 
```
wget <to_be_hosted>.zip
```

## Compare the FID scores
  - First compute the FID score using the CleanFID with
    ```
    from cleanfid import fid

    score = fid.compare_folders("test_fake/", "test_real/", mode="legacy_tensorflow")
    ```
    The above gets a score of **8.972544787448271**

  - Next compute the FID using the [code]((https://github.com/bioinf-jku/TTUR)
    ```
    pip install tensorflow-gpu==1.14
    pip install imageio
    cd test && git clone https://github.com/bioinf-jku/TTUR
    python fid.py test_fake/ test_real/
    ```
    The above gets a score of **8.972518580709163**


## Debugging Notes
  - The official TTUR repository is very sensitive to the the tensorflow version. 
  - You may need to tune and modify some shape operations
  - I tested with tensorflow 1.14 and python 3.6
