## CleanFID vs PyTorch-FID (legacy)
*PyTorch-legacy-FID* refers to the popular PyTorch implementation of FID here [code](https://github.com/mseitzer/pytorch-fid/)

Here we document the differences between *CleanFID* and *PyTorch-legacy-FID*. 
Additionally, we outline the steps that can be used to verify that using the `mode="legacy_pytorch"` flag is equivalent to the popular PyTorch implementation . 

The key details are listed below:
  - The Repository used weights that are ported by the authors of the implementation from the TensorFlow model [model](http://download.tensorflow.org/models/image/imagenet/inception-2015-12-05.tgz) to PyTorch
  - The resizing function this implementation of FID uses the `bilinear` filter implemented by the PyTorch ( speficially `torch.nn.functional.interpolate`). 

## Getting sample images
First download zipped file containing 5000 images generated by a StyleGAN2 model and 5000 randomly sampled from the FFHQ dataset. 
```
wget <to_be_hosted>.zip
```

## Compare the FID scores

  - First compute the FID score using the CleanFID with
    ```
    from cleanfid import fid

    score = fid.compare_folders("test_fake/", "test_real/", mode="legacy_pytorch")
    ```
    The above gets a score of **8.966867513671616**

  - Next compute the FID using the [code](https://github.com/mseitzer/pytorch-fid/)
    ```
    pip install pytorch-fid

    python -m pytorch_fid docs/test_fake/ docs/test_real/ \
            --device "cuda" --batch-size 128
    ```
    The above gets a score of **8.966869432185263**