# Centers of Excellence

## This repository is closed

We are no longer taking questions about the procurements on this repository.

## Phase II - Industry Day and Reverse Industry Days

On June 27-29, 2018, the [Centers of Excellence](https://coe.gsa.gov/) (CoE) teams from the [General Services Administration](https://www.gsa.gov/) (GSA) and the [U.S. Department of Agriculture](https://www.usda.gov/) (USDA) held an Industry Day (June 27) and Reverse Industry Days (June 28 and 29).

During these three days, the government and industry exchange ideas related to [potential upcoming procurements](assets/CoE-Requirements.pdf) in Phase II of our effort. Phase II's focus is on implementing the recommendations that were developed in Phase I. Though the events have passed, we are still looking for feedback, which you can submit as [Issues](https://github.com/gsa/coe-industry-day/issues) in this repository.

For more detailed information, you can review a [recording of the event](https://www.youtube.com/watch?v=uqGwaEaVlHI) as well as [the slides that were presented](assets/CoE-Industry-Day-Slides.pdf) during that event. You can also view the vendors that participated in our [Industry Day](assets/Attendance-Industry-Day.pdf) and our [Reverse Industry Day](assets/Attendance-Reverse-Industry-Day.pdf).

## A significant step forward

<img src="https://github.com/GSA/coe-industry-day/blob/master/assets/USDA-logo.png" width="75">&nbsp;&nbsp;&nbsp;<img src="https://github.com/GSA/coe-industry-day/blob/master/assets/CoE-Logomark.png" width="75">&nbsp;&nbsp;&nbsp;<img src="https://github.com/gsa/coe-industry-day/blob/master/assets/GSA-logo.png" width="75">

In 2017, the White House [Office of American Innovation](https://www.whitehouse.gov/briefings-statements/president-donald-j-trump-announces-white-house-office-american-innovation-oai/?utm_source=link) (OAI) [collaborated with CEOs from the largest IT companies in the U.S.](https://www.whitehouse.gov/articles/american-technology-council-summit-modernize-government-services/) to identify [key areas](https://www.whitehouse.gov/wp-content/uploads/2018/03/Administration-2017-ST-Highlights.pdf) where the government could gain maximum efficiency and cost savings through IT modernization. It was decided to centralize subject matter expertise, best practices, and access to the latest technology from private industry into five distinct [CoEs](https://coe.gsa.gov/), housed within the [GSA](https://www.gsa.gov/)’s [Federal Acquisition Service](https://www.gsa.gov/about-us/organization/federal-acquisition-service)'s (FAS) [Technology Transformation Services](https://www.gsa.gov/about-us/organization/federal-acquisition-service/technology-transformation-services) (TTS). We started our efforts in April 2018 with [USDA](https://www.usda.gov/) as our "lighthouse" agency.

## The Centers

In accordance with [our mission](https://coe.gsa.gov/mission/), the [CoEs](https://coe.gsa.gov/) are supporting [USDA](https://www.usda.gov/) in the following areas:

1. **[Cloud Adoption](https://coe.gsa.gov/centers-of-excellence/cloud-adoption/)**
2. **[Contact Center](https://coe.gsa.gov/centers-of-excellence/contact-center/)**
3. **[Customer Experience](https://coe.gsa.gov/centers-of-excellence/customer-experience/)**
4. **[Data and Analytics](https://coe.gsa.gov/centers-of-excellence/data-analytics/)**
5. **[IT Infrastructure Optimization](https://coe.gsa.gov/centers-of-excellence/it-infrastructure/)**

## Where things stand

In [Phase I](https://coe.gsa.gov/updates/) of our work with USDA, we put in place an approach built around [human-centered design](https://www.gsa.gov/cdnstatic/HCD-Discovery-Guide-Interagency-v12-1.pdf) and [user-focused research](https://playbook.cio.gov/). In Phase II, we will implement recommendations that arose in Phase I as a result of that approach.

# Thank you!

We thank you in advance for your interest in IT modernization and our Industry Day!
